/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class InputStreamUtils {
    private static final int BUFFER_SIZE = 4096;

    public static byte[] toByteArray(InputStream inputStream, int inputStreamSize) throws IOException {
        if (inputStreamSize == 0) {
            return new byte[0];
        }
        if (inputStreamSize < 0) {
            throw new IllegalArgumentException("inputStreamSize: " + inputStreamSize + "is less than zero: ");
        }
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            InputStreamUtils.copy(inputStream, inputStreamSize, output);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    private static int copy(InputStream inputStream, int inputStreamSize, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        int readSize = 0;
        int count = 0;
        while (readSize < inputStreamSize && (readSize = inputStream.read(buffer)) != -1) {
            output.write(buffer, 0, readSize);
            count += readSize;
        }
        if (count != inputStreamSize) {
            throw new IOException("read size err. readSizeCount: " + count + ", inputStreamSize: " + inputStreamSize);
        }
        return count;
    }
}

