/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.hap.sign;

import com.ohos.hapsigntool.codesigning.exception.CodeSignException;
import com.ohos.hapsigntool.codesigning.exception.FsVerityDigestException;
import com.ohos.hapsigntool.codesigning.sign.CodeSigning;
import com.ohos.hapsigntool.error.HapFormatException;
import com.ohos.hapsigntool.error.ProfileException;
import com.ohos.hapsigntool.hap.config.SignerConfig;
import com.ohos.hapsigntool.hap.entity.HwBlockHead;
import com.ohos.hapsigntool.hap.entity.HwSignHead;
import com.ohos.hapsigntool.hap.entity.SignBlockData;
import com.ohos.hapsigntool.hap.entity.SignatureBlockTypes;
import com.ohos.hapsigntool.utils.FileUtils;
import com.ohos.hapsigntool.utils.ParamProcessUtil;
import com.ohos.hapsigntool.utils.StringUtils;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignElf {
    public static final char CODESIGN_BLOCK_TYPE = '\u0003';
    private static final Logger LOGGER = LogManager.getLogger(SignElf.class);
    private static final String CODESIGN_OFF = "0";
    private static int blockNum = 0;
    private static final int PAGE_SIZE = 4096;
    private static final int FILE_BUFFER_BLOCK = 16384;

    private SignElf() {
    }

    public static boolean sign(SignerConfig signerConfig, Map<String, String> signParams) {
        String profileSigned;
        boolean isSuccess = false;
        String inputFile = signParams.get("inFile");
        String tmpFile = SignElf.alignFileBy4kBytes(inputFile);
        if (tmpFile == null) {
            LOGGER.error("copy input File failed");
            return isSuccess;
        }
        String outputFile = signParams.get("outFile");
        if (!SignElf.writeBlockDataToFile(signerConfig, tmpFile, outputFile, profileSigned = signParams.get("profileSigned"), signParams)) {
            LOGGER.error("The block head data made failed.`");
            ParamProcessUtil.delDir(new File(outputFile));
            return isSuccess;
        }
        LOGGER.info("The block head data made success.");
        if (!SignElf.writeSignHeadDataToOutputFile(tmpFile, outputFile, blockNum)) {
            LOGGER.error("The sign head data made failed.");
            ParamProcessUtil.delDir(new File(outputFile));
        } else {
            isSuccess = true;
        }
        return isSuccess;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String alignFileBy4kBytes(String inputFile) {
        String tmp = "tmpFile" + new Date().getTime();
        File tmpFile = new File(tmp);
        try {
            tmpFile.createNewFile();
        }
        catch (IOException e) {
            LOGGER.error("create tmp file Failed");
            return null;
        }
        try (FileOutputStream output = new FileOutputStream(tmpFile);
             FileInputStream input = new FileInputStream(inputFile);){
            int read;
            byte[] buffer = new byte[16384];
            while ((read = input.read(buffer)) != -1) {
                output.write(buffer, 0, read);
            }
            long addLength = 4096L - tmpFile.length() % 4096L;
            if (SignElf.isLongOverflowInteger(addLength)) {
                LOGGER.error("File alignment error");
                String string = null;
                return string;
            }
            byte[] bytes = new byte[(int)addLength];
            Arrays.fill(bytes, (byte)0);
            FileUtils.writeByteToOutFile(bytes, tmp);
            return tmp;
        }
        catch (IOException e) {
            LOGGER.error("copy inFile Failed");
            return null;
        }
    }

    private static boolean writeBlockDataToFile(SignerConfig signerConfig, String inputFile, String outputFile, String profileSigned, Map<String, String> signParams) {
        try {
            SignBlockData codeSign;
            String profileFile = signParams.get("profileFile");
            ArrayList<SignBlockData> signDataList = new ArrayList<SignBlockData>();
            long binFileLen = FileUtils.getFileLen(inputFile);
            if (binFileLen == -1L) {
                LOGGER.error("file length is invalid, elf file len: " + binFileLen);
                throw new IOException();
            }
            if (!StringUtils.isEmpty(signParams.get("profileFile"))) {
                signDataList.add(SignElf.generateProfileSignByte(profileFile, profileSigned));
            }
            if ((codeSign = SignElf.generateCodeSignByte(signerConfig, signParams, inputFile, blockNum = signDataList.size() + 1, binFileLen)) != null) {
                signDataList.add(0, codeSign);
            }
            blockNum = signDataList.size();
            SignElf.generateSignBlockHead(signDataList);
            return SignElf.writeSignedElf(inputFile, signDataList, outputFile);
        }
        catch (IOException e) {
            LOGGER.error("writeBlockDataToFile failed.", (Throwable)e);
            return false;
        }
        catch (CodeSignException | FsVerityDigestException | HapFormatException | ProfileException e) {
            LOGGER.error("codesign failed.", (Throwable)e);
            return false;
        }
    }

    private static boolean writeSignedElf(String inputFile, List<SignBlockData> signBlockList, String outputFile) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
             DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);){
            if (!FileUtils.writeFileToDos(inputFile, dataOutputStream)) {
                LOGGER.error("Failed to write information of input file: " + inputFile + " to outputFile: " + outputFile);
                throw new IOException();
            }
            for (SignBlockData signBlockData : signBlockList) {
                if (FileUtils.writeByteToDos(signBlockData.getBlockHead(), dataOutputStream)) continue;
                LOGGER.error("Failed to write Block Head to output file: " + outputFile);
                throw new IOException();
            }
            for (SignBlockData signBlockData : signBlockList) {
                boolean isSuccess = signBlockData.isByte() ? FileUtils.writeByteToDos(signBlockData.getSignData(), dataOutputStream) : FileUtils.writeFileToDos(signBlockData.getSignFile(), dataOutputStream);
                if (isSuccess) continue;
                LOGGER.error("Failed to write Block Data to output file: " + outputFile);
                throw new IOException();
            }
        }
        catch (IOException e) {
            LOGGER.error("writeSignedElf failed.", (Throwable)e);
            return false;
        }
        return true;
    }

    private static void generateSignBlockHead(List<SignBlockData> signDataList) throws IOException {
        long offset = (long)HwBlockHead.getElfBlockLen() * (long)signDataList.size();
        for (int i = 0; i < signDataList.size(); ++i) {
            SignBlockData signBlockData = signDataList.get(i);
            signBlockData.setBlockHead(HwBlockHead.getBlockHeadLittleEndian(signBlockData.getType(), '\u0000', (int)signBlockData.getLen(), (int)offset));
            if (!SignElf.isLongOverflowInteger(offset += signBlockData.getLen())) continue;
            LOGGER.error("The sign block " + i + "offset is overflow integer, offset: " + offset);
            throw new IOException();
        }
    }

    private static SignBlockData generateProfileSignByte(String profileFile, String profileSigned) throws IOException {
        long profileDataLen = FileUtils.getFileLen(profileFile);
        if (profileDataLen == -1L || SignElf.isLongOverflowShort(profileDataLen)) {
            LOGGER.error("file length is invalid, profileDataLen: " + profileDataLen);
            throw new IOException();
        }
        char isSigned = SignatureBlockTypes.getProfileBlockTypes(profileSigned);
        return new SignBlockData(profileFile, isSigned);
    }

    private static SignBlockData generateCodeSignByte(SignerConfig signerConfig, Map<String, String> signParams, String inputFile, int blockNum, long binFileLen) throws IOException, FsVerityDigestException, CodeSignException, HapFormatException, ProfileException {
        if (CODESIGN_OFF.equals(signParams.get("signCode"))) {
            return null;
        }
        CodeSigning codeSigning = new CodeSigning(signerConfig);
        long offset = binFileLen + (long)HwBlockHead.getElfBlockLen() * (long)blockNum;
        String profileContent = signParams.get("profileContent");
        byte[] codesignData = codeSigning.getElfCodeSignBlock(new File(inputFile), offset, signParams.get("inForm"), profileContent);
        return new SignBlockData(codesignData, '\u0003');
    }

    private static boolean writeSignHeadDataToOutputFile(String inputFile, String outputFile, int blockNum) {
        long size = FileUtils.getFileLen(outputFile) - FileUtils.getFileLen(inputFile);
        if (SignElf.isLongOverflowInteger(size)) {
            LOGGER.error("File size is Overflow integer range.");
            return false;
        }
        HwSignHead signHeadData = new HwSignHead();
        byte[] signHeadByte = signHeadData.getSignHeadLittleEndian((int)size, blockNum);
        if (signHeadByte == null) {
            LOGGER.error("Failed to get sign head data.");
            return false;
        }
        return FileUtils.writeByteToOutFile(signHeadByte, outputFile);
    }

    private static boolean isLongOverflowInteger(long num) {
        return num - (num & 0xFFFFFFFFL) != 0L;
    }

    private static boolean isLongOverflowShort(long num) {
        return num - (num & 0xFFFFL) != 0L;
    }
}

