/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.hap.sign;

import com.ohos.hapsigntool.entity.ContentDigestAlgorithm;
import com.ohos.hapsigntool.entity.Pair;
import com.ohos.hapsigntool.entity.SignatureAlgorithm;
import com.ohos.hapsigntool.error.HapFormatException;
import com.ohos.hapsigntool.error.SignatureException;
import com.ohos.hapsigntool.hap.config.SignerConfig;
import com.ohos.hapsigntool.hap.entity.SigningBlock;
import com.ohos.hapsigntool.hap.sign.Pkcs7Generator;
import com.ohos.hapsigntool.hap.utils.HapUtils;
import com.ohos.hapsigntool.utils.FileUtils;
import com.ohos.hapsigntool.utils.StringUtils;
import com.ohos.hapsigntool.zip.ZipDataInput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.DigestException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;

public abstract class SignHap {
    private static final int STORED_ENTRY_SO_ALIGNMENT = 4096;
    private static final int BUFFER_LENGTH = 4096;
    private static final int BLOCK_COUNT = 4;
    private static final int BLOCK_MAGIC = 16;
    private static final int BLOCK_VERSION = 4;
    private static final long INIT_OFFSET_LEN = 4L;
    private static final int OPTIONAL_TYPE_SIZE = 4;
    private static final int OPTIONAL_LENGTH_SIZE = 4;
    private static final int OPTIONAL_OFFSET_SIZE = 4;

    private SignHap() {
    }

    public static void copyFiles(JarFile in, JarOutputStream out, long timestamp, int defaultAlignment) throws IOException, HapFormatException {
        List<JarEntry> entryListStored = in.stream().filter(jarFile -> jarFile.getMethod() == 0).collect(Collectors.toList());
        entryListStored = SignHap.storedEntryListOfSort(entryListStored);
        long offset = 4L;
        String lastAlignmentEntryName = "";
        for (JarEntry inEntry : entryListStored) {
            String entryName = inEntry.getName();
            if (FileUtils.isRunnableFile(entryName)) continue;
            lastAlignmentEntryName = entryName;
            break;
        }
        for (JarEntry inEntry : entryListStored) {
            if (inEntry == null) continue;
            offset += 30L;
            JarEntry outEntry = SignHap.getJarEntry(timestamp, inEntry);
            int alignment = SignHap.getStoredEntryDataAlignment(inEntry.getName(), defaultAlignment, lastAlignmentEntryName);
            if (alignment > 0 && (offset += (long)outEntry.getName().length()) % (long)alignment != 0L) {
                int needed = alignment - (int)(offset % (long)alignment);
                outEntry.setExtra(new byte[needed]);
                offset += (long)needed;
            }
            out.putNextEntry(outEntry);
            offset = SignHap.writeOutputStreamAndGetOffset(in, out, inEntry, offset);
        }
        List<JarEntry> entryListNotStored = in.stream().filter(jarFile -> jarFile.getMethod() != 0).collect(Collectors.toList());
        boolean isAlignmentFlag = StringUtils.isEmpty(lastAlignmentEntryName);
        if (isAlignmentFlag) {
            if (entryListNotStored.isEmpty()) {
                throw new HapFormatException("Hap format is error, file missing");
            }
            JarEntry firstEntry = (JarEntry)entryListNotStored.get(0);
            JarEntry outEntry = SignHap.getFirstJarEntry(firstEntry, offset += 30L, timestamp);
            out.putNextEntry(outEntry);
            byte[] buffer = new byte[4096];
            SignHap.writeOutputStream(in, out, firstEntry, buffer);
        }
        SignHap.copyFilesExceptStoredFile(entryListNotStored, in, out, timestamp, isAlignmentFlag);
    }

    private static List<JarEntry> storedEntryListOfSort(List<JarEntry> entryListStored) {
        return entryListStored.stream().sorted((entry1, entry2) -> {
            String name1 = entry1.getName();
            String name2 = entry2.getName();
            boolean isSpecial1 = FileUtils.isRunnableFile(name1);
            boolean isSpecial2 = FileUtils.isRunnableFile(name2);
            if (isSpecial1 && !isSpecial2) {
                return -1;
            }
            if (!isSpecial1 && isSpecial2) {
                return 1;
            }
            return name1.compareTo(name2);
        }).collect(Collectors.toList());
    }

    private static JarEntry getFirstJarEntry(JarEntry firstEntry, long offset, long timestamp) {
        long currentOffset = offset;
        JarEntry outEntry = SignHap.getJarEntry(timestamp, firstEntry);
        if ((currentOffset += (long)outEntry.getName().length()) % 4096L != 0L) {
            int needed = 4096 - (int)(currentOffset % 4096L);
            outEntry.setExtra(new byte[needed]);
        }
        return outEntry;
    }

    private static void writeOutputStream(JarFile in, JarOutputStream out, JarEntry firstEntry, byte[] buffer) throws IOException {
        try (InputStream data = in.getInputStream(firstEntry);){
            int num;
            while ((num = data.read(buffer)) > 0) {
                out.write(buffer, 0, num);
            }
            out.flush();
        }
    }

    private static long writeOutputStreamAndGetOffset(JarFile in, JarOutputStream out, JarEntry inEntry, long offset) throws IOException {
        byte[] buffer = new byte[4096];
        long currentOffset = offset;
        try (InputStream data = in.getInputStream(inEntry);){
            int num;
            while ((num = data.read(buffer)) > 0) {
                out.write(buffer, 0, num);
                currentOffset += (long)num;
            }
            out.flush();
        }
        return currentOffset;
    }

    private static JarEntry getJarEntry(long timestamp, JarEntry inEntry) {
        JarEntry outEntry = new JarEntry(inEntry);
        outEntry.setTime(timestamp);
        outEntry.setComment(null);
        outEntry.setExtra(null);
        return outEntry;
    }

    private static void copyFilesExceptStoredFile(List<JarEntry> entryListNotStored, JarFile in, JarOutputStream out, long timestamp, boolean isAlignmentFlag) throws IOException {
        byte[] buffer = new byte[4096];
        int index = 0;
        if (isAlignmentFlag) {
            index = 1;
        }
        while (index < entryListNotStored.size()) {
            JarEntry inEntry = entryListNotStored.get(index);
            if (inEntry != null && inEntry.getMethod() != 0) {
                JarEntry outEntry = new JarEntry(inEntry.getName());
                outEntry.setTime(timestamp);
                out.putNextEntry(outEntry);
                SignHap.writeOutputStream(in, out, inEntry, buffer);
            }
            ++index;
        }
    }

    private static int getStoredEntryDataAlignment(String entryName, int defaultAlignment, String lastAlignmentEntryName) {
        if (defaultAlignment <= 0) {
            return 0;
        }
        if (!StringUtils.isEmpty(lastAlignmentEntryName) && entryName.equals(lastAlignmentEntryName)) {
            return 4096;
        }
        if (FileUtils.isRunnableFile(entryName)) {
            return 4096;
        }
        return defaultAlignment;
    }

    private static byte[] getHapSigningBlock(Set<ContentDigestAlgorithm> contentDigestAlgorithms, List<SigningBlock> optionalBlocks, SignerConfig signerConfig, ZipDataInput[] hapData) throws SignatureException {
        byte[] hapSignatureBytes = null;
        try {
            Map<ContentDigestAlgorithm, byte[]> contentDigests = HapUtils.computeDigests(contentDigestAlgorithms, hapData, optionalBlocks);
            hapSignatureBytes = SignHap.generateHapSigningBlock(signerConfig, contentDigests, optionalBlocks);
        }
        catch (IOException | DigestException e) {
            throw new SignatureException("Failed to compute digests of HAP", e);
        }
        return hapSignatureBytes;
    }

    private static byte[] generateHapSigningBlock(SignerConfig signerConfig, Map<ContentDigestAlgorithm, byte[]> contentDigests, List<SigningBlock> optionalBlocks) throws SignatureException {
        byte[] hapSignatureSchemeBlock = SignHap.generateHapSignatureSchemeBlock(signerConfig, contentDigests);
        return SignHap.generateHapSigningBlock(hapSignatureSchemeBlock, optionalBlocks, signerConfig.getCompatibleVersion());
    }

    private static byte[] generateHapSigningBlock(byte[] hapSignatureSchemeBlock, List<SigningBlock> optionalBlocks, int compatibleVersion) {
        long optionalBlockSize = 0L;
        for (SigningBlock optionalBlock : optionalBlocks) {
            optionalBlockSize += (long)optionalBlock.getLength();
        }
        long resultSize = (long)(12 * (optionalBlocks.size() + 1)) + optionalBlockSize + (long)hapSignatureSchemeBlock.length + 4L + 8L + 16L + 4L;
        if (resultSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("HapSigningBlock out of range : " + resultSize);
        }
        ByteBuffer result = ByteBuffer.allocate((int)resultSize);
        result.order(ByteOrder.LITTLE_ENDIAN);
        HashMap<Integer, Integer> typeAndOffsetMap = new HashMap<Integer, Integer>();
        int currentOffset = 12 * (optionalBlocks.size() + 1);
        int currentOffsetInBlockValue = 0;
        int blockValueSizes = (int)(optionalBlockSize + (long)hapSignatureSchemeBlock.length);
        byte[] blockValues = new byte[blockValueSizes];
        for (SigningBlock optionalBlock : optionalBlocks) {
            System.arraycopy(optionalBlock.getValue(), 0, blockValues, currentOffsetInBlockValue, optionalBlock.getLength());
            typeAndOffsetMap.put(optionalBlock.getType(), currentOffset);
            currentOffset += optionalBlock.getLength();
            currentOffsetInBlockValue += optionalBlock.getLength();
        }
        System.arraycopy(hapSignatureSchemeBlock, 0, blockValues, currentOffsetInBlockValue, hapSignatureSchemeBlock.length);
        typeAndOffsetMap.put(0x20000000, currentOffset);
        SignHap.extractedResult(optionalBlocks, result, typeAndOffsetMap);
        result.putInt(0x20000000);
        result.putInt(hapSignatureSchemeBlock.length);
        int offset = (Integer)typeAndOffsetMap.get(0x20000000);
        result.putInt(offset);
        result.put(blockValues);
        result.putInt(optionalBlocks.size() + 1);
        result.putLong(resultSize);
        result.put(HapUtils.getHapSigningBlockMagic(compatibleVersion));
        result.putInt(HapUtils.getHapSigningBlockVersion(compatibleVersion));
        return result.array();
    }

    private static void extractedResult(List<SigningBlock> optionalBlocks, ByteBuffer result, Map<Integer, Integer> typeAndOffsetMap) {
        for (SigningBlock optionalBlock : optionalBlocks) {
            result.putInt(optionalBlock.getType());
            result.putInt(optionalBlock.getLength());
            int offset = typeAndOffsetMap.get(optionalBlock.getType());
            result.putInt(offset);
        }
    }

    private static byte[] generateHapSignatureSchemeBlock(SignerConfig signerConfig, Map<ContentDigestAlgorithm, byte[]> contentDigests) throws SignatureException {
        byte[] signerBlock = null;
        try {
            signerBlock = SignHap.generateSignerBlock(signerConfig, contentDigests);
        }
        catch (SignatureException e) {
            throw new SignatureException("generate SignerBlock failed\nSolutions:\n> The keyAlias parameter is incorrect, please input a correct keyAlias parameter.\n> The certificate is incorrect, please check if your certificate matches the key");
        }
        return signerBlock;
    }

    private static byte[] generateSignerBlock(SignerConfig signerConfig, Map<ContentDigestAlgorithm, byte[]> contentDigests) throws SignatureException {
        String mode = signerConfig.getOptions().getString("mode");
        if (!"remoteSign".equalsIgnoreCase(mode) && signerConfig.getCertificates().isEmpty()) {
            throw new SignatureException("No certificates configured for signer");
        }
        ArrayList<Pair<Integer, byte[]>> digests = new ArrayList<Pair<Integer, byte[]>>(signerConfig.getSignatureAlgorithms().size());
        for (SignatureAlgorithm signatureAlgorithm : signerConfig.getSignatureAlgorithms()) {
            ContentDigestAlgorithm contentDigestAlgorithm = signatureAlgorithm.getContentDigestAlgorithm();
            byte[] contentDigest = contentDigests.get((Object)contentDigestAlgorithm);
            if (contentDigest == null) {
                throw new SignatureException(contentDigestAlgorithm.getDigestAlgorithm() + " content digest for " + signatureAlgorithm.getSignatureAlgAndParams().getFirst() + " not computed");
            }
            digests.add(Pair.create(signatureAlgorithm.getId(), contentDigest));
        }
        byte[] unsignedHapDigest = HapUtils.encodeListOfPairsToByteArray(digests);
        return Pkcs7Generator.BC.generateSignedData(unsignedHapDigest, signerConfig);
    }

    public static byte[] sign(ZipDataInput[] contents, SignerConfig signerConfig, List<SigningBlock> optionalBlocks) throws SignatureException {
        HashSet<ContentDigestAlgorithm> contentDigestAlgorithms = new HashSet<ContentDigestAlgorithm>();
        for (SignatureAlgorithm signatureAlgorithm : signerConfig.getSignatureAlgorithms()) {
            contentDigestAlgorithms.add(signatureAlgorithm.getContentDigestAlgorithm());
        }
        return SignHap.getHapSigningBlock(contentDigestAlgorithms, optionalBlocks, signerConfig, contents);
    }
}

