/*
 * Decompiled with CFR 0.152.
 */
package ohos;

import ohos.CommandParser;
import ohos.CompressVerify;
import ohos.Compressor;
import ohos.FileUtils;
import ohos.Log;
import ohos.ShowHelp;
import ohos.Utility;

public class CompressEntrance {
    private static final int EXIT_STATUS_NORMAL = 0;
    private static final int EXIT_STATUS_EXCEPTION = 1;
    private static final Log LOG = new Log(CompressEntrance.class.toString());
    private static final String HAP_SUFFIX = ".hap";
    private static final String EMPTY_STRING = "";

    public static boolean pack(String string, String string2, String string3) {
        if (string == null || string.isEmpty()) {
            LOG.error("CompressEntrance::pack hapPath is invalid!");
            return false;
        }
        if (string2 == null || string2.isEmpty()) {
            LOG.error("CompressEntrance::pack packInfoPath is invalid!");
            return false;
        }
        if (string3 == null || string3.isEmpty()) {
            LOG.error("CompressEntrance::pack outPath is invalid!");
            return false;
        }
        Utility utility = new Utility();
        utility.setMode("app");
        utility.setHapPath(string);
        utility.setPackInfoPath(string2);
        utility.setOutPath(string3);
        utility.setForceRewrite("true");
        if (!CompressVerify.commandVerify(utility)) {
            LOG.error("CompressEntrance::startCompress verity failed");
            return false;
        }
        Compressor compressor = new Compressor();
        if (!compressor.compressProcess(utility)) {
            LOG.error("CompressEntrance::startCompress compress failed");
            return false;
        }
        return true;
    }

    public static String getHapSha256(String string) {
        if (!string.endsWith(HAP_SUFFIX)) {
            LOG.error("input file is not a hap.");
            return EMPTY_STRING;
        }
        return FileUtils.getSha256(string);
    }

    public static void main(String[] stringArray) {
        Compressor compressor;
        Utility utility = new Utility();
        if (!CommandParser.commandParser(utility, stringArray)) {
            LOG.error("CompressEntrance::main exit, parser failed");
            ShowHelp.compressHelp();
            System.exit(1);
        }
        if (!CompressVerify.commandVerify(utility)) {
            LOG.error("CompressEntrance::main exit, verify failed");
            ShowHelp.compressHelp();
            System.exit(1);
        }
        if (!(compressor = new Compressor()).compressProcess(utility)) {
            LOG.error("CompressEntrance::main exit, compress failed");
            ShowHelp.compressHelp();
            System.exit(1);
        }
        if (utility.getGenerateBuildHash()) {
            utility.setForceRewrite("true");
            if (!compressor.compressProcess(utility)) {
                LOG.error("CompressEntrance::main exit, compress failed");
                ShowHelp.compressHelp();
                System.exit(1);
            }
        }
        System.exit(0);
    }
}

