/*
 * Decompiled with CFR 0.152.
 */
package ohos;

import java.util.Collections;
import java.util.List;
import ohos.HQFInfo;
import ohos.Log;

class HQFVerify {
    private static final Log LOG = new Log(HQFVerify.class.toString());

    HQFVerify() {
    }

    public static boolean checkHQFIsValid(List<HQFInfo> list) {
        if (list.isEmpty()) {
            LOG.error("input hqf file is empty.");
            return false;
        }
        if (!HQFVerify.checkAppFields(list)) {
            LOG.error("input hqf file has different fields in app.");
            return false;
        }
        if (!HQFVerify.checkModuleIsValid(list)) {
            LOG.error("input hqf file moduleName is invalid.");
            return false;
        }
        return true;
    }

    private static boolean checkAppFields(List<HQFInfo> list) {
        String string = list.get(0).getBundleName();
        int n = list.get(0).getVersionCode();
        String string2 = list.get(0).getVersionName();
        int n2 = list.get(0).getPatchVersionCode();
        String string3 = list.get(0).getPatchVersionName();
        for (HQFInfo hQFInfo : list) {
            if (string == null || !string.equals(hQFInfo.getBundleName())) {
                LOG.error("input hqf file has different bundleName.");
                return false;
            }
            if (n != hQFInfo.getVersionCode()) {
                LOG.error("input hqf file has different versionCode.");
                return false;
            }
            if (string2 == null || !string2.equals(hQFInfo.getVersionName())) {
                LOG.error("input hqf file has different versionName.");
                return false;
            }
            if (n2 != hQFInfo.getPatchVersionCode()) {
                LOG.error("input hqf file has different patchVersionCode.");
                return false;
            }
            if (string3 != null && string3.equals(hQFInfo.getPatchVersionName())) continue;
            LOG.error("input hqf file has different patchVersionName.");
            return false;
        }
        return true;
    }

    private static boolean checkModuleIsValid(List<HQFInfo> list) {
        for (int i = 0; i < list.size(); ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                if (!HQFVerify.checkModuleIsDuplicated(list.get(i), list.get(j))) continue;
                LOG.error("input hqf file moduleName duplicated.");
                return false;
            }
        }
        return true;
    }

    private static boolean checkModuleIsDuplicated(HQFInfo hQFInfo, HQFInfo hQFInfo2) {
        if (!hQFInfo.getModuleName().equals(hQFInfo2.getModuleName())) {
            return false;
        }
        return !Collections.disjoint(hQFInfo.getDeviceTypes(), hQFInfo2.getDeviceTypes());
    }
}

