/*
 * Decompiled with CFR 0.152.
 */
package ohos;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import ohos.AbilityFormInfo;
import ohos.AbilityInfo;
import ohos.AppInfo;
import ohos.AppModel;
import ohos.BundleException;
import ohos.CommonEvent;
import ohos.CustomizeData;
import ohos.DefPermission;
import ohos.DefPermissionGroup;
import ohos.DefinePermission;
import ohos.DependencyItem;
import ohos.DeviceConfig;
import ohos.Distro;
import ohos.DistroFilter;
import ohos.ExtensionAbilityInfo;
import ohos.FormInfo;
import ohos.HQFInfo;
import ohos.HapInfo;
import ohos.IntentInfo;
import ohos.JsInfo;
import ohos.Log;
import ohos.MetaData;
import ohos.MetaDataInfo;
import ohos.ModuleAbilityInfo;
import ohos.ModuleAdaption;
import ohos.ModuleAppInfo;
import ohos.ModuleAtomicService;
import ohos.ModuleDeviceType;
import ohos.ModuleInfo;
import ohos.ModuleMetadataInfo;
import ohos.ModuleProfileInfo;
import ohos.ModuleShortcut;
import ohos.PackInfo;
import ohos.PreloadItem;
import ohos.ProfileInfo;
import ohos.ReqPermission;
import ohos.ResourcesParser;
import ohos.Shortcut;
import ohos.SkillInfo;
import ohos.UsedScene;
import ohos.Want;

public class JsonUtil {
    private static final String DEVICE_TYPE = "device-type";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String RESOURCE = "resource";
    private static final String MODULE_TYPE = "module-type";
    private static final String INSTALL_FLAG = "delivery-with-install";
    private static final String DEVICE_TYPE_NEW = "deviceType";
    private static final String MODULE_TYPE_NEW = "moduleType";
    private static final String INSTALL_FLAG_NEW = "deliveryWithInstall";
    private static final String ASSETS_DIR_NAME = "assets/";
    private static final String PROFILE = "$profile:";
    private static final Log LOG = new Log(JsonUtil.class.toString());
    private static final String SUMMARY = "summary";
    private static final String APP = "app";
    private static final String VERSION = "version";
    private static final String LEGACY_VERSION_CODE = "legacyVersionCode";
    private static final String LEGACY_VERSION_NAME = "legacyVersionName";
    private static final String MULTI_FRAMEWORK_BUNDLE = "multiFrameworkBundle";
    private static final String ACTION_SYSTEM_HOME = "action.system.home";
    private static final String ENTITY_SYSTEM_HOME = "entity.system.home";
    private static final String MAIN_ABILITY = "mainAbility";
    private static final String MAIN_ELEMENT = "mainElement";
    private static final String PAGE = "page";
    private static final String SERVICE = "service";
    private static final String FORM = "form";
    private static final String PACKAGES = "packages";
    private static final String ABILITIES = "abilities";
    private static final String WHEN = "when";
    private static final String STRING_RESOURCE = "$string:";
    private static final String EMPTY = "";
    private static final String BUNDLENAME = "bundleName";
    private static final String BUNDLE_TYPE = "bundleType";
    private static final String VERSIONCODE = "versionCode";
    private static final String VERSIONNAME = "versionName";
    private static final String PATCH_VERSION_CODE = "patchVersionCode";
    private static final String PATCH_VERSION_NAME = "patchVersionName";
    private static final String ORIGINAL_MODULE_HASH = "originalModuleHash";
    private static final String MODULE = "module";
    private static final String DEVICE_TYPES = "deviceTypes";
    private static final String TYPE = "type";
    private static final String LABEL = "label";
    private static final String LABEL_ID = "labelId";
    private static final String DESCRIPTION = "description";
    private static final String DESCRIPTION_ID = "descriptionId";
    private static final String VERSION_CODE = "versionCode";
    private static final String VENDOR = "vendor";
    private static final String VERSION_NAME = "versionName";
    private static final String MIN_COMPATIBLE_VERSION_CODE = "minCompatibleVersionCode";
    private static final String DEBUG = "debug";
    private static final String MIN_API_VERSION = "minAPIVersion";
    private static final String TARGET_API_VERSION = "targetAPIVersion";
    private static final String API_RELEASE_TYPE = "apiReleaseType";
    private static final String DISTRIBUTED_NOTIFICATION_ENABLED = "distributedNotificationEnabled";
    private static final String ENTITY_TYPE = "entityType";
    private static final String UNSPECIFIED = "unspecified";
    private static final String SRC_ENTRANCE = "srcEntrance";
    private static final String SRC_ENTRY = "srcEntry";
    private static final String PROCESS = "process";
    private static final String PHONE = "phone";
    private static final String TABLET = "tablet";
    private static final String TV = "tv";
    private static final String WEARABLE = "wearable";
    private static final String AR = "ar";
    private static final String VR = "vr";
    private static final String CAR = "car";
    private static final String EARPHONES = "earphones";
    private static final String SPEAKER = "speaker";
    private static final String LINK_IOT = "linkIOT";
    private static final String ROUTER = "router";
    private static final String TWO_IN_ONE = "2in1";
    private static final String DELIVERY_WITH_INSTALL = "deliveryWithInstall";
    private static final String INSTALLATION_FREE = "installationFree";
    private static final String VIRTUAL_MACHINE = "virtualMachine";
    private static final String DEFAULT = "default";
    private static final String HML = "hml";
    private static final String UI_SYNTAX = "uiSyntax";
    private static final String PAGES = "pages";
    private static final String JSON_SUFFIX = ".json";
    private static final String META_DATA = "metadata";
    private static final String SRC = "src";
    private static final String EXTENSION_ABILITIES = "extensionAbilities";
    private static final String REQ_PERMISSIONS = "reqPermissions";
    private static final String REQUEST_PERMISSIONS = "requestPermissions";
    private static final String REASON = "reason";
    private static final String REASON_ID = "reasonId";
    private static final String USED_SCENE = "usedScene";
    private static final String DEFINE_PERMISSIONS = "definePermissions";
    private static final String DISTRO_FILTER = "distroFilter";
    private static final String DISTRIBUTION_FILTER = "distributionFilter";
    private static final String LAUNCH_TYPE = "launchType";
    private static final String STANDARD = "standard";
    private static final String PERMISSIONS = "permissions";
    private static final String READ_PERMISSION = "readPermission";
    private static final String WRITE_PERMISSION = "writePermission";
    private static final String VISIBLE = "visible";
    private static final String EXPORTED = "exported";
    private static final String CONTINUABLE = "continuable";
    private static final String SKILLS = "skills";
    private static final String BACKGROUND_MODES = "backgroundModes";
    private static final String URI = "uri";
    private static final String FORMS = "forms";
    private static final String WINDOW = "window";
    private static final String IS_DEFAULT = "isDefault";
    private static final String COLOR_MODE = "colorMode";
    private static final String SUPPORT_DIMENSIONS = "supportDimensions";
    private static final String DEFAULT_DIMENSION = "defaultDimension";
    private static final String UPDATE_ENABLED = "updateEnabled";
    private static final String SCHEDULE_UPDATE_TIME = "scheduledUpdateTime";
    private static final String UPDATE_DURATION = "updateDuration";
    private static final String FROM_CONFIG_ABILITY = "formConfigAbility";
    private static final String FORM_VISIBLE_NOTIFY = "formVisibleNotify";
    private static final String AUTO = "auto";
    private static final String DOT = ".";
    private static final String ATOMIC_SERVICE = "atomicService";
    private static final String SPLIT = "split";
    private static final String MAIN = "main";
    private static final String PRELOADS = "preloads";
    private static final String MODULE_NAME = "moduleName";
    private static final int DEFAULT_VERSION_CODE = -1;
    private static final String DEPENDENCY_BUNDLE_NAME = "bundleName";
    private static final String DEPENDENCY_MODULE_NAME = "moduleName";
    private static final String DEPENDENCIES = "dependencies";
    private static final String COMPILE_SDK_VERSION = "compileSdkVersion";
    private static final String COMPILE_SDK_TYPE = "compileSdkType";

    static List<PackInfo> parseHapList(String string, String string2) throws BundleException {
        ArrayList<PackInfo> arrayList = new ArrayList<PackInfo>();
        JSONObject jSONObject = JSONObject.parseObject((String)string2);
        if (jSONObject == null || !jSONObject.containsKey((Object)PACKAGES)) {
            LOG.error("Uncompress::parseHapList exception: packages is null.");
            throw new BundleException("Parse hap list failed, packages is null.");
        }
        JSONArray jSONArray = JSONArray.parseArray((String)JsonUtil.getJsonString(jSONObject, PACKAGES));
        if (jSONArray == null) {
            LOG.error("Uncompress::parseHapList exception: packages is null.");
            throw new BundleException("Parse hap list failed, packages is null.");
        }
        int n = jSONArray.size();
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            String string3 = JsonUtil.getJsonString(jSONObject2, DEVICE_TYPE);
            if (string3 == null || EMPTY.equals(string3)) {
                string3 = JsonUtil.getJsonString(jSONObject2, DEVICE_TYPE_NEW);
            }
            if (string3 == null || !string3.toLowerCase(Locale.ENGLISH).contains(string.toLowerCase(Locale.ENGLISH))) continue;
            PackInfo packInfo = new PackInfo();
            packInfo.name = JsonUtil.getJsonString(jSONObject2, NAME);
            packInfo.moduleType = JsonUtil.getJsonString(jSONObject2, MODULE_TYPE);
            if (packInfo.moduleType == null || EMPTY.equals(packInfo.moduleType)) {
                packInfo.moduleType = JsonUtil.getJsonString(jSONObject2, MODULE_TYPE_NEW);
            }
            packInfo.deviceType = JSONArray.parseArray((String)string3, String.class);
            String string4 = JsonUtil.getJsonString(jSONObject2, INSTALL_FLAG);
            if (string4 == null || EMPTY.equals(string4)) {
                string4 = JsonUtil.getJsonString(jSONObject2, "deliveryWithInstall");
            }
            packInfo.deliveryWithInstall = Boolean.parseBoolean(string4);
            arrayList.add(packInfo);
        }
        return arrayList;
    }

    static List<PackInfo> parsePackInfos(String string) throws BundleException {
        JSONObject jSONObject = JSONObject.parseObject((String)string);
        if (jSONObject == null || !jSONObject.containsKey((Object)PACKAGES)) {
            LOG.error("JsonUtil::parsePackInfos exception: packages is null.");
            throw new BundleException("Parse hap list failed, packages is null.");
        }
        String string2 = JsonUtil.getJsonString(jSONObject, PACKAGES);
        return JSONArray.parseArray((String)string2, PackInfo.class);
    }

    private static boolean parseShellVersionInfoToAppInfo(String string, AppInfo appInfo) throws BundleException {
        LOG.info("Uncompress::parseShellVersionInfoToAppInfo: begin.");
        if (!appInfo.isMultiFrameworkBundle()) {
            LOG.info("Uncompress::parseShellVersionInfoToAppInfo: is not a multi framewok bundle.");
            return false;
        }
        try {
            JSONObject jSONObject = JSONObject.parseObject((String)string);
            if (jSONObject == null) {
                LOG.error("Uncompress::parseShellVersionInfoToAppInfo error: summary is null.");
                return false;
            }
            JSONObject jSONObject2 = jSONObject.getJSONObject(SUMMARY);
            if (jSONObject2 == null) {
                LOG.error("Uncompress::parseShellVersionInfoToAppInfo error: summary is null.");
                return false;
            }
            JSONObject jSONObject3 = jSONObject2.getJSONObject(APP);
            if (jSONObject3 == null) {
                LOG.error("Uncompress::parseShellVersionInfoToAppInfo error: app is null.");
                return false;
            }
            JSONObject jSONObject4 = jSONObject3.getJSONObject(VERSION);
            if (jSONObject4 == null) {
                LOG.error("Uncompress::parseShellVersionInfoToAppInfo error: version is null.");
                return false;
            }
            if (!jSONObject4.containsKey((Object)LEGACY_VERSION_CODE) || !jSONObject4.containsKey((Object)LEGACY_VERSION_NAME)) {
                LOG.error("Uncompress::parseShellVersionInfoToAppInfo no legacy version info.");
                return false;
            }
            appInfo.setShellVersionCode(jSONObject4.getString(LEGACY_VERSION_CODE));
            appInfo.setShellVersionName(jSONObject4.getString(LEGACY_VERSION_NAME));
            return true;
        }
        catch (JSONException jSONException) {
            LOG.error("parseShellVersionInfoToAppInfo exception: " + jSONException.getMessage());
            throw new BundleException("parseShellVersionInfoToAppInfo exception.");
        }
    }

    private static void parseDeviceTypeToHapInfo(String string, HapInfo hapInfo, String string2) {
        LOG.info("Uncompress::parseDeviceTypeToHapInfo: begin.");
        JSONObject jSONObject = JSONObject.parseObject((String)string);
        if (jSONObject == null || !jSONObject.containsKey((Object)PACKAGES)) {
            LOG.error("Uncompress::parseDeviceTypeToHapInfo error: no packages.");
            return;
        }
        JSONArray jSONArray = JSONArray.parseArray((String)JsonUtil.getJsonString(jSONObject, PACKAGES));
        if (jSONArray == null) {
            LOG.error("Uncompress::parseDeviceTypeToHapInfo error: packages is null.");
            return;
        }
        for (int i = 0; i < jSONArray.size(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            if (jSONObject2 == null) {
                LOG.error("Uncompress::parseDeviceTypeToHapInfo error: obj is null.");
                continue;
            }
            String string3 = JsonUtil.getJsonString(jSONObject2, NAME);
            if (string3 == null || !string3.equals(string2)) continue;
            String string4 = JsonUtil.getJsonString(jSONObject2, DEVICE_TYPE_NEW);
            if (string4 == null || string4.isEmpty()) {
                string4 = JsonUtil.getJsonString(jSONObject2, DEVICE_TYPE);
            }
            if (string4 == null || string4.isEmpty()) break;
            hapInfo.deviceType = JSONArray.parseArray((String)string4.replace(DEFAULT, PHONE), String.class);
            break;
        }
    }

    static ProfileInfo parseProfileInfo(String string, byte[] byArray, String string2, String string3) throws BundleException {
        Object object;
        ProfileInfo profileInfo = new ProfileInfo();
        JSONObject jSONObject = JSONObject.parseObject((String)string);
        if (!(jSONObject != null && jSONObject.containsKey((Object)APP) && jSONObject.containsKey((Object)"deviceConfig") && jSONObject.containsKey((Object)MODULE))) {
            LOG.error("Uncompress::parseProfileInfo exception: app, deviceConfig or module is null.");
            throw new BundleException("Parse profile info failed, app, deviceConfig or module is null.");
        }
        if (jSONObject.containsKey((Object)APP)) {
            object = jSONObject.getJSONObject(APP);
            profileInfo.appInfo = JsonUtil.parseAppInfo((JSONObject)object, byArray);
        }
        if (jSONObject.containsKey((Object)MODULE)) {
            object = jSONObject.getJSONObject(MODULE);
            profileInfo.hapInfo = JsonUtil.parseHapInfo((JSONObject)object, byArray);
        }
        JsonUtil.parseDeviceTypeToHapInfo(string2, profileInfo.hapInfo, string3);
        if (jSONObject.containsKey((Object)"deviceConfig")) {
            object = jSONObject.getJSONObject("deviceConfig");
            profileInfo.deviceConfig = JsonUtil.parseDeviceConfigInfo((JSONObject)object, profileInfo.hapInfo.deviceType);
        }
        if (!JsonUtil.parseShellVersionInfoToAppInfo(string2, profileInfo.appInfo)) {
            profileInfo.appInfo.setDefaultShellVersion();
        }
        if (!profileInfo.appInfo.appName.isEmpty()) {
            return profileInfo;
        }
        if (profileInfo.hapInfo.abilities.size() == 1) {
            profileInfo.appInfo.appName = profileInfo.hapInfo.abilities.get((int)0).label;
            profileInfo.appInfo.appNameEN = profileInfo.hapInfo.abilities.get((int)0).label;
        } else {
            for (AbilityInfo abilityInfo : profileInfo.hapInfo.abilities) {
                boolean bl = false;
                for (SkillInfo skillInfo : abilityInfo.skills) {
                    if (!skillInfo.actions.contains(ACTION_SYSTEM_HOME) || !skillInfo.entities.contains(ENTITY_SYSTEM_HOME)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                profileInfo.appInfo.appName = abilityInfo.label;
                profileInfo.appInfo.appNameEN = abilityInfo.label;
                break;
            }
        }
        return profileInfo;
    }

    static AppInfo parseAppInfo(JSONObject jSONObject, byte[] byArray) throws BundleException {
        Object object;
        AppInfo appInfo = new AppInfo();
        if (jSONObject == null) {
            LOG.error("Uncompress::parseAppInfo exception: appJson is null.");
            throw new BundleException("Parse app info failed, appJson is null.");
        }
        appInfo.bundleName = JsonUtil.getJsonString(jSONObject, "bundleName");
        appInfo.setBundleType(JsonUtil.getJsonString(jSONObject, BUNDLE_TYPE, APP));
        appInfo.vendor = JsonUtil.getJsonString(jSONObject, VENDOR);
        appInfo.relatedBundleName = JsonUtil.getJsonString(jSONObject, "relatedBundleName");
        if (jSONObject.containsKey((Object)VERSION)) {
            object = jSONObject.getJSONObject(VERSION);
            appInfo.versionName = JsonUtil.getJsonString((JSONObject)object, NAME);
            appInfo.versionCode = JsonUtil.getJsonString((JSONObject)object, "code");
        }
        if (jSONObject.containsKey((Object)"apiVersion")) {
            object = jSONObject.getJSONObject("apiVersion");
            appInfo.compatibleApiVersion = object.getIntValue("compatible");
            appInfo.targetApiVersion = object.getIntValue("target");
            appInfo.releaseType = JsonUtil.getJsonString((JSONObject)object, "releaseType");
            appInfo.setCompileSdkType(JsonUtil.getJsonString((JSONObject)object, COMPILE_SDK_TYPE));
            appInfo.setCompileSdkVersion(JsonUtil.getJsonString((JSONObject)object, COMPILE_SDK_VERSION));
        }
        object = EMPTY;
        if (jSONObject.containsKey((Object)LABEL_ID)) {
            int n = jSONObject.getIntValue(LABEL_ID);
            object = ResourcesParser.getBaseResourceById(n, byArray);
        }
        if (object != null && !((String)object).isEmpty()) {
            appInfo.appName = object;
            appInfo.appNameEN = object;
        } else if (jSONObject.containsKey((Object)LABEL)) {
            appInfo.appName = JsonUtil.getJsonString(jSONObject, LABEL);
            appInfo.appNameEN = JsonUtil.getJsonString(jSONObject, LABEL);
        }
        appInfo.setMultiFrameworkBundle(jSONObject.getBooleanValue(MULTI_FRAMEWORK_BUNDLE));
        if (jSONObject.containsKey((Object)COMPILE_SDK_TYPE)) {
            appInfo.setCompileSdkType(jSONObject.getString(COMPILE_SDK_TYPE));
        }
        if (jSONObject.containsKey((Object)COMPILE_SDK_VERSION)) {
            appInfo.setCompileSdkVersion(jSONObject.getString(COMPILE_SDK_VERSION));
        }
        return appInfo;
    }

    static ModuleAppInfo parseModuleAppInfo(JSONObject jSONObject, byte[] byArray) throws BundleException {
        ModuleAppInfo moduleAppInfo = new ModuleAppInfo();
        if (jSONObject == null) {
            LOG.error("Uncompress::parseModuleAppInfo exception: appJson is null.");
            throw new BundleException("Parse module app info failed, appJson is null.");
        }
        moduleAppInfo.bundleName = JsonUtil.getJsonString(jSONObject, "bundleName");
        moduleAppInfo.debug = JsonUtil.getJsonBooleanValue(jSONObject, DEBUG, false);
        moduleAppInfo.icon = JsonUtil.parseIconById(jSONObject, byArray);
        moduleAppInfo.label = JsonUtil.parseResourceByKey(jSONObject, byArray, LABEL, LABEL_ID);
        moduleAppInfo.setLabels(JsonUtil.parseResourceMapByKey(jSONObject, byArray, LABEL_ID));
        moduleAppInfo.description = JsonUtil.parseResourceByKey(jSONObject, byArray, DESCRIPTION, DESCRIPTION_ID);
        moduleAppInfo.setDescriptions(JsonUtil.parseResourceMapByKey(jSONObject, byArray, DESCRIPTION_ID));
        moduleAppInfo.vendor = JsonUtil.getJsonString(jSONObject, VENDOR);
        moduleAppInfo.versionCode = JsonUtil.getJsonIntValue(jSONObject, "versionCode", -1);
        moduleAppInfo.versionName = JsonUtil.getJsonString(jSONObject, "versionName");
        moduleAppInfo.minCompatibleVersionCode = jSONObject.containsKey((Object)MIN_COMPATIBLE_VERSION_CODE) ? JsonUtil.getJsonIntValue(jSONObject, MIN_COMPATIBLE_VERSION_CODE, -1) : JsonUtil.getJsonIntValue(jSONObject, "versionCode", -1);
        moduleAppInfo.minAPIVersion = JsonUtil.getJsonIntValue(jSONObject, MIN_API_VERSION, -1);
        moduleAppInfo.targetAPIVersion = JsonUtil.getJsonIntValue(jSONObject, TARGET_API_VERSION, -1);
        moduleAppInfo.apiReleaseType = JsonUtil.getJsonString(jSONObject, API_RELEASE_TYPE);
        moduleAppInfo.distributedNotificationEnabled = JsonUtil.getJsonBooleanValue(jSONObject, DISTRIBUTED_NOTIFICATION_ENABLED, false);
        moduleAppInfo.entityType = JsonUtil.getJsonString(jSONObject, ENTITY_TYPE, UNSPECIFIED);
        moduleAppInfo.setBundleType(JsonUtil.getJsonString(jSONObject, BUNDLE_TYPE, APP));
        moduleAppInfo.setCompileSdkType(JsonUtil.getJsonString(jSONObject, COMPILE_SDK_TYPE, EMPTY));
        moduleAppInfo.setCompileSdkVersion(JsonUtil.getJsonString(jSONObject, COMPILE_SDK_VERSION, EMPTY));
        JsonUtil.parseSpecifiedDeviceType(jSONObject, moduleAppInfo);
        return moduleAppInfo;
    }

    static void parseSpecifiedDeviceType(JSONObject jSONObject, ModuleAppInfo moduleAppInfo) throws BundleException {
        if (jSONObject == null) {
            LOG.error("JsonUtil::parseSpecifiedDeviceType exception: appJson is null.");
            throw new BundleException("Parse app info failed, appJson is null.");
        }
        JsonUtil.parseDeviceType(jSONObject, moduleAppInfo, PHONE);
        JsonUtil.parseDeviceType(jSONObject, moduleAppInfo, TABLET);
        JsonUtil.parseDeviceType(jSONObject, moduleAppInfo, TV);
        JsonUtil.parseDeviceType(jSONObject, moduleAppInfo, WEARABLE);
        JsonUtil.parseDeviceType(jSONObject, moduleAppInfo, AR);
        JsonUtil.parseDeviceType(jSONObject, moduleAppInfo, VR);
        JsonUtil.parseDeviceType(jSONObject, moduleAppInfo, CAR);
        JsonUtil.parseDeviceType(jSONObject, moduleAppInfo, EARPHONES);
        JsonUtil.parseDeviceType(jSONObject, moduleAppInfo, SPEAKER);
        JsonUtil.parseDeviceType(jSONObject, moduleAppInfo, LINK_IOT);
        JsonUtil.parseDeviceType(jSONObject, moduleAppInfo, ROUTER);
        JsonUtil.parseDeviceType(jSONObject, moduleAppInfo, TWO_IN_ONE);
    }

    static ModuleDeviceType parseDeviceType(JSONObject jSONObject, ModuleAppInfo moduleAppInfo, String string) throws BundleException {
        if (jSONObject == null) {
            LOG.error("JsonUtil::parseDeviceType exception: appJson is null.");
            throw new BundleException("Parse app info failed, appJson is null.");
        }
        ModuleDeviceType moduleDeviceType = new ModuleDeviceType();
        if (jSONObject.containsKey((Object)string)) {
            JSONObject jSONObject2 = jSONObject.getJSONObject(string);
            moduleDeviceType.minAPIVersion = jSONObject2.containsKey((Object)MIN_API_VERSION) ? jSONObject2.getIntValue(MIN_API_VERSION) : moduleAppInfo.minAPIVersion;
            moduleDeviceType.distributedNotificationEnabled = jSONObject2.containsKey((Object)DISTRIBUTED_NOTIFICATION_ENABLED) ? jSONObject2.getBoolean(DISTRIBUTED_NOTIFICATION_ENABLED) : moduleAppInfo.distributedNotificationEnabled;
            moduleAppInfo.deviceTypes.put(string, moduleDeviceType);
        }
        return moduleDeviceType;
    }

    static Map<String, DeviceConfig> parseDeviceConfigInfo(JSONObject jSONObject, List<String> list) throws BundleException {
        HashMap<String, DeviceConfig> hashMap = new HashMap<String, DeviceConfig>();
        if (jSONObject == null) {
            return hashMap;
        }
        DeviceConfig deviceConfig = new DeviceConfig();
        if (jSONObject.containsKey((Object)DEFAULT)) {
            deviceConfig = JsonUtil.parseDeviceConfig(jSONObject.getJSONObject(DEFAULT), new DeviceConfig());
        }
        for (String string : list) {
            JsonUtil.getTargetDeviceConfig(hashMap, jSONObject, deviceConfig, string);
        }
        if (hashMap.isEmpty()) {
            hashMap.put(PHONE, deviceConfig);
        }
        return hashMap;
    }

    static void getTargetDeviceConfig(Map<String, DeviceConfig> map, JSONObject jSONObject, DeviceConfig deviceConfig, String string) throws BundleException {
        if (jSONObject.containsKey((Object)string)) {
            DeviceConfig deviceConfig2 = JsonUtil.parseDeviceConfig(jSONObject.getJSONObject(string), deviceConfig);
            map.put(string, deviceConfig2);
        } else {
            map.put(string, deviceConfig);
        }
    }

    static DeviceConfig parseDeviceConfig(JSONObject jSONObject, DeviceConfig deviceConfig) throws BundleException {
        JSONObject jSONObject2;
        DeviceConfig deviceConfig2 = new DeviceConfig();
        if (jSONObject == null || deviceConfig == null) {
            LOG.error("Uncompress::parseDeviceConfigInfo exception: deviceConfigJson or defaultConfig is null.");
            throw new BundleException("Parse device config info failed, deviceConfigJson or defaultConfig is null.");
        }
        deviceConfig2.jointUserid = JsonUtil.getJsonString(jSONObject, "jointUserid", deviceConfig.jointUserid);
        deviceConfig2.process = JsonUtil.getJsonString(jSONObject, PROCESS, deviceConfig.process);
        if (jSONObject.containsKey((Object)"reqSdk")) {
            jSONObject2 = jSONObject.getJSONObject("reqSdk");
            deviceConfig2.compatibleReqSdk = JsonUtil.getJsonString(jSONObject2, "compatible", deviceConfig.compatibleReqSdk);
            deviceConfig2.targetReqSdk = JsonUtil.getJsonString(jSONObject2, "target", deviceConfig.targetReqSdk);
        }
        if (jSONObject.containsKey((Object)"ark")) {
            jSONObject2 = jSONObject.getJSONObject("ark");
            deviceConfig2.arkFlag = JsonUtil.getJsonString(jSONObject2, "flag", deviceConfig.arkFlag);
            if (jSONObject2.containsKey((Object)"reqVersion")) {
                JSONObject jSONObject3 = jSONObject2.getJSONObject("reqVersion");
                deviceConfig2.targetArkVersion = JsonUtil.getJsonString(jSONObject3, "target", deviceConfig.targetArkVersion);
                deviceConfig2.compatibleArkVersion = JsonUtil.getJsonString(jSONObject3, "compatible", deviceConfig.compatibleArkVersion);
            }
        }
        deviceConfig2.directLaunch = jSONObject.containsKey((Object)"directLaunch") ? jSONObject.getBoolean("directLaunch") : deviceConfig.directLaunch;
        return deviceConfig2;
    }

    static HapInfo parseHapInfo(JSONObject jSONObject, byte[] byArray) throws BundleException {
        Object object;
        HapInfo hapInfo = new HapInfo();
        if (jSONObject == null) {
            LOG.error("Uncompress::parseHapInfo exception: hapJson is null.");
            throw new BundleException("Parse hap info failed, hapJson is null.");
        }
        hapInfo.packageStr = JsonUtil.getJsonString(jSONObject, "package");
        hapInfo.name = JsonUtil.getJsonString(jSONObject, NAME);
        hapInfo.description = JsonUtil.parseResourceByKey(jSONObject, byArray, DESCRIPTION, DESCRIPTION_ID);
        hapInfo.setDescriptions(JsonUtil.parseResourceMapByKey(jSONObject, byArray, DESCRIPTION_ID));
        if (jSONObject.containsKey((Object)MAIN_ABILITY)) {
            hapInfo.mainElement = JsonUtil.getJsonString(jSONObject, MAIN_ABILITY);
        }
        if (jSONObject.containsKey((Object)"supportedModes")) {
            hapInfo.supportedModes = JSONObject.parseArray((String)JsonUtil.getJsonString(jSONObject, "supportedModes"), String.class);
        }
        if (jSONObject.containsKey((Object)"defPermissions")) {
            hapInfo.defPermissions = JsonUtil.parseDefPermissions(jSONObject, byArray);
        }
        if (jSONObject.containsKey((Object)DEFINE_PERMISSIONS)) {
            hapInfo.definePermissions = JsonUtil.parseDefinePermissions(jSONObject, byArray);
        }
        if (jSONObject.containsKey((Object)"defPermissiongroups")) {
            hapInfo.defPermissionsGroups = JSONArray.parseArray((String)JsonUtil.getJsonString(jSONObject, "defPermissiongroups"), DefPermissionGroup.class);
        }
        if (jSONObject.containsKey((Object)"distro")) {
            JsonUtil.getDistro(jSONObject, hapInfo);
        }
        if (jSONObject.containsKey((Object)"reqCapabilities")) {
            hapInfo.reqCapabilities = JSONArray.parseArray((String)JsonUtil.getJsonString(jSONObject, "reqCapabilities"), String.class);
        }
        if (jSONObject.containsKey((Object)DEVICE_TYPE_NEW)) {
            hapInfo.deviceType = JSONArray.parseArray((String)JsonUtil.getJsonString(jSONObject, DEVICE_TYPE_NEW).replace(DEFAULT, PHONE), String.class);
        }
        if (jSONObject.containsKey((Object)"metaData")) {
            object = jSONObject.getJSONObject("metaData");
            hapInfo.metaData = JsonUtil.parseMetaData((JSONObject)object);
        }
        if (jSONObject.containsKey((Object)"js") && (object = JSONObject.parseArray((String)JsonUtil.getJsonString(jSONObject, "js"), JsInfo.class)) != null && object.size() > 0) {
            hapInfo.isJs = true;
        }
        if (jSONObject.containsKey((Object)REQ_PERMISSIONS)) {
            hapInfo.reqPermissions = JsonUtil.parseFAReqPermission(jSONObject, byArray);
        }
        if (jSONObject.containsKey((Object)"commonEvents")) {
            hapInfo.commonEvents = JSONObject.parseArray((String)JsonUtil.getJsonString(jSONObject, "commonEvents"), CommonEvent.class);
        }
        if (jSONObject.containsKey((Object)"shortcuts")) {
            hapInfo.shortcuts = JsonUtil.parseShoruCuts(jSONObject, byArray);
        }
        if (jSONObject.containsKey((Object)ABILITIES)) {
            object = jSONObject.getJSONArray(ABILITIES);
            ArrayList<AbilityInfo> arrayList = new ArrayList<AbilityInfo>();
            int n = object.size();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject2 = object.getJSONObject(i);
                arrayList.add(JsonUtil.parseAbility(jSONObject2, byArray));
            }
            hapInfo.abilities = arrayList;
            JsonUtil.adaptAbilityName(hapInfo.abilities, hapInfo.packageStr);
            JsonUtil.setFAProviderAbility(jSONObject, hapInfo, hapInfo.abilities);
        }
        if (jSONObject.containsKey((Object)DISTRO_FILTER)) {
            hapInfo.distroFilter = (DistroFilter)JSONObject.parseObject((String)JsonUtil.getJsonString(jSONObject, DISTRO_FILTER), DistroFilter.class);
        }
        return hapInfo;
    }

    static List<ReqPermission> parseFAReqPermission(JSONObject jSONObject, byte[] byArray) throws BundleException {
        ArrayList<ReqPermission> arrayList = new ArrayList<ReqPermission>();
        if (!jSONObject.containsKey((Object)REQ_PERMISSIONS)) {
            return arrayList;
        }
        JSONArray jSONArray = jSONObject.getJSONArray(REQ_PERMISSIONS);
        for (int i = 0; i < jSONArray.size(); ++i) {
            ReqPermission reqPermission = new ReqPermission();
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            reqPermission.name = JsonUtil.getJsonString(jSONObject2, NAME);
            reqPermission.reason = JsonUtil.parseResourceByKey(jSONObject2, byArray, REASON, REASON_ID);
            if (jSONObject2.containsKey((Object)REASON_ID)) {
                reqPermission.setReasons(JsonUtil.parseResourceMapByKey(jSONObject2, byArray, REASON_ID));
            }
            if (jSONObject2.containsKey((Object)USED_SCENE)) {
                reqPermission.usedScene = JsonUtil.parseModuleUsedScene(jSONObject2.getJSONObject(USED_SCENE));
            }
            arrayList.add(reqPermission);
        }
        return arrayList;
    }

    private static void getDistro(JSONObject jSONObject, HapInfo hapInfo) {
        boolean bl;
        JSONObject jSONObject2 = jSONObject.getJSONObject("distro");
        Distro distro = new Distro();
        distro.moduleName = JsonUtil.getJsonString(jSONObject2, "moduleName");
        distro.moduleType = JsonUtil.getJsonString(jSONObject2, MODULE_TYPE_NEW);
        distro.deliveryWithInstall = jSONObject2.getBoolean("deliveryWithInstall");
        distro.installationFree = jSONObject2.containsKey((Object)INSTALLATION_FREE) ? ((bl = jSONObject2.getBoolean(INSTALLATION_FREE).booleanValue()) ? 1 : 0) : 2;
        distro.virtualMachine = jSONObject2.containsKey((Object)VIRTUAL_MACHINE) ? JsonUtil.getJsonString(jSONObject2, VIRTUAL_MACHINE) : DEFAULT;
        hapInfo.distro = distro;
    }

    private static MetaData parseMetaData(JSONObject jSONObject) {
        MetaData metaData = new MetaData();
        if (jSONObject == null) {
            LOG.error("Uncompress::parseMetaData : metaDataJson is null");
            return metaData;
        }
        if (jSONObject.containsKey((Object)"parameters")) {
            metaData.parameters = JSONObject.parseArray((String)JsonUtil.getJsonString(jSONObject, "parameters"), MetaDataInfo.class);
        }
        if (jSONObject.containsKey((Object)"results")) {
            metaData.results = JSONObject.parseArray((String)JsonUtil.getJsonString(jSONObject, "results"), MetaDataInfo.class);
        }
        if (jSONObject.containsKey((Object)"customizeData")) {
            metaData.customizeDatas = JSONObject.parseArray((String)JsonUtil.getJsonString(jSONObject, "customizeData"), CustomizeData.class);
        }
        return metaData;
    }

    static AbilityInfo parseAbility(JSONObject jSONObject, byte[] byArray) throws BundleException {
        int n;
        Object object;
        if (jSONObject == null) {
            LOG.error("Uncompress::parseAbility exception: abilityJson is null.");
            throw new BundleException("Parse ability failed, abilityJson is null.");
        }
        AbilityInfo abilityInfo = new AbilityInfo();
        abilityInfo.name = JsonUtil.getJsonString(jSONObject, NAME);
        if (jSONObject.containsKey((Object)"iconId") && (object = ResourcesParser.getResourceById(n = jSONObject.getIntValue("iconId"), byArray)) != null && !((String)object).isEmpty()) {
            abilityInfo.iconPath = ASSETS_DIR_NAME + (String)object;
        }
        String string = abilityInfo.icon = abilityInfo.iconPath != null && !abilityInfo.iconPath.isEmpty() ? abilityInfo.iconPath : JsonUtil.getJsonString(jSONObject, "icon");
        if (jSONObject.containsKey((Object)DESCRIPTION_ID)) {
            n = jSONObject.getIntValue(DESCRIPTION_ID);
            abilityInfo.descriptionRes = ResourcesParser.getBaseResourceById(n, byArray);
        }
        abilityInfo.description = abilityInfo.descriptionRes != null && !abilityInfo.descriptionRes.isEmpty() ? abilityInfo.descriptionRes : JsonUtil.getJsonString(jSONObject, DESCRIPTION);
        abilityInfo.setDescriptions(JsonUtil.parseResourceMapByKey(jSONObject, byArray, DESCRIPTION_ID));
        if (jSONObject.containsKey((Object)LABEL_ID)) {
            n = jSONObject.getIntValue(LABEL_ID);
            abilityInfo.labelRes = ResourcesParser.getBaseResourceById(n, byArray);
        }
        abilityInfo.label = abilityInfo.labelRes != null && !abilityInfo.labelRes.isEmpty() ? abilityInfo.labelRes : (!JsonUtil.getJsonString(jSONObject, LABEL).isEmpty() ? JsonUtil.getJsonString(jSONObject, LABEL) : abilityInfo.name);
        abilityInfo.setLabels(JsonUtil.parseResourceMapByKey(jSONObject, byArray, LABEL_ID));
        abilityInfo.type = JsonUtil.getJsonString(jSONObject, TYPE);
        abilityInfo.launchType = JsonUtil.getJsonString(jSONObject, LAUNCH_TYPE);
        abilityInfo.orientation = JsonUtil.getJsonString(jSONObject, "orientation");
        abilityInfo.uri = JsonUtil.getJsonString(jSONObject, URI);
        if (jSONObject.containsKey((Object)"formsEnabled")) {
            abilityInfo.formsEnabled = jSONObject.getBoolean("formsEnabled");
        }
        if (jSONObject.containsKey((Object)"metaData")) {
            JSONObject jSONObject2 = jSONObject.getJSONObject("metaData");
            abilityInfo.metaData = JsonUtil.parseMetaData(jSONObject2);
        }
        if (jSONObject.containsKey((Object)SKILLS)) {
            abilityInfo.skills = JSONObject.parseArray((String)JsonUtil.getJsonString(jSONObject, SKILLS), SkillInfo.class);
        }
        if (jSONObject.containsKey((Object)BACKGROUND_MODES)) {
            abilityInfo.backgroundModes = JSONObject.parseArray((String)JsonUtil.getJsonString(jSONObject, BACKGROUND_MODES), String.class);
        }
        if (jSONObject.containsKey((Object)VISIBLE)) {
            abilityInfo.visible = jSONObject.getBoolean(VISIBLE);
        }
        if (jSONObject.containsKey((Object)"configChanges")) {
            abilityInfo.configChanges = JSONObject.parseArray((String)JsonUtil.getJsonString(jSONObject, "configChanges"), String.class);
        }
        if (jSONObject.containsKey((Object)"srcLanguage")) {
            abilityInfo.srcLanguage = JsonUtil.getJsonString(jSONObject, "srcLanguage");
        }
        if (jSONObject.containsKey((Object)"srcPath")) {
            abilityInfo.srcPath = JsonUtil.getJsonString(jSONObject, "srcPath");
        }
        JsonUtil.parseAbilityPermissions(jSONObject, abilityInfo);
        if (jSONObject.containsKey((Object)FORMS)) {
            JSONArray jSONArray = jSONObject.getJSONArray(FORMS);
            object = new ArrayList();
            int n2 = jSONArray.size();
            for (int i = 0; i < n2; ++i) {
                JSONObject jSONObject3 = jSONArray.getJSONObject(i);
                object.add(JsonUtil.parseAbilityFormInfo(jSONObject3, byArray));
            }
            abilityInfo.formInfos = object;
        }
        return abilityInfo;
    }

    private static void adaptAbilityName(List<AbilityInfo> list, String string) {
        if (list == null) {
            return;
        }
        for (AbilityInfo abilityInfo : list) {
            if (!abilityInfo.name.startsWith(DOT)) continue;
            abilityInfo.name = string + abilityInfo.name;
        }
    }

    static void parseAbilityPermissions(JSONObject jSONObject, AbilityInfo abilityInfo) throws BundleException {
        JSONObject jSONObject2;
        if (jSONObject == null || abilityInfo == null) {
            LOG.error("Uncompress::parseAbilityPermissions exception: abilityJson or ability is null.");
            throw new BundleException("Parse ability permissions failed, abilityJson or ability is null.");
        }
        if (jSONObject.containsKey((Object)PERMISSIONS)) {
            abilityInfo.permissions = JSONObject.parseArray((String)JsonUtil.getJsonString(jSONObject, PERMISSIONS), String.class);
        }
        if (jSONObject.containsKey((Object)"grantPermission")) {
            abilityInfo.grantPermission = jSONObject.getBoolean("grantPermission");
        }
        abilityInfo.readPermission = JsonUtil.getJsonString(jSONObject, READ_PERMISSION);
        abilityInfo.writePermission = JsonUtil.getJsonString(jSONObject, WRITE_PERMISSION);
        if (jSONObject.containsKey((Object)"uriPermission")) {
            jSONObject2 = jSONObject.getJSONObject("uriPermission");
            abilityInfo.uriPermissionMode = JsonUtil.getJsonString(jSONObject2, "mode");
            abilityInfo.uriPermissionPath = JsonUtil.getJsonString(jSONObject2, "path");
        }
        abilityInfo.mission = JsonUtil.getJsonString(jSONObject, "mission");
        abilityInfo.targetAbility = JsonUtil.getJsonString(jSONObject, "targetAbility");
        if (jSONObject.containsKey((Object)"directLaunch")) {
            abilityInfo.directLaunch = jSONObject.getBoolean("directLaunch");
        }
        if (jSONObject.containsKey((Object)"multiUserShared")) {
            abilityInfo.multiUserShared = jSONObject.getBoolean("multiUserShared");
        }
        if (jSONObject.containsKey((Object)"supportPipMode")) {
            abilityInfo.supportPipMode = jSONObject.getBoolean("supportPipMode");
        }
        if (jSONObject.containsKey((Object)FORM)) {
            jSONObject2 = jSONObject.getJSONObject(FORM);
            FormInfo formInfo = new FormInfo();
            if (jSONObject2.containsKey((Object)"formEntity")) {
                formInfo.formEntity = JSONObject.parseArray((String)JsonUtil.getJsonString(jSONObject2, "formEntity"), String.class);
            }
            formInfo.minWidth = JsonUtil.getJsonString(jSONObject2, "minWidth");
            formInfo.defaultWidth = JsonUtil.getJsonString(jSONObject2, "defaultWidth");
            formInfo.minHeight = JsonUtil.getJsonString(jSONObject2, "minHeight");
            formInfo.defaultHeight = JsonUtil.getJsonString(jSONObject2, "defaultHeight");
            abilityInfo.formInfo = formInfo;
        }
    }

    static AbilityFormInfo parseAbilityFormInfo(JSONObject jSONObject, byte[] byArray) throws BundleException {
        AbilityFormInfo abilityFormInfo = new AbilityFormInfo();
        if (jSONObject == null) {
            LOG.error("Uncompress::parseAbilityFormInfo : abilityFormJson is null");
            return abilityFormInfo;
        }
        abilityFormInfo.name = JsonUtil.getJsonString(jSONObject, NAME);
        abilityFormInfo.type = JsonUtil.getJsonString(jSONObject, TYPE);
        abilityFormInfo.description = JsonUtil.parseResourceByKey(jSONObject, byArray, DESCRIPTION, DESCRIPTION_ID);
        abilityFormInfo.setDescriptions(JsonUtil.parseResourceMapByKey(jSONObject, byArray, DESCRIPTION_ID));
        if (jSONObject.containsKey((Object)IS_DEFAULT)) {
            abilityFormInfo.isDefault = jSONObject.getBoolean(IS_DEFAULT);
        }
        if (jSONObject.containsKey((Object)COLOR_MODE)) {
            abilityFormInfo.colorMode = JsonUtil.getJsonString(jSONObject, COLOR_MODE);
        }
        if (jSONObject.containsKey((Object)FROM_CONFIG_ABILITY)) {
            abilityFormInfo.formConfigAbility = JsonUtil.getJsonString(jSONObject, FROM_CONFIG_ABILITY);
        }
        if (jSONObject.containsKey((Object)UPDATE_ENABLED)) {
            abilityFormInfo.updateEnabled = jSONObject.getBoolean(UPDATE_ENABLED);
        }
        abilityFormInfo.scheduledUpdateTime = JsonUtil.getJsonString(jSONObject, SCHEDULE_UPDATE_TIME);
        if (jSONObject.containsKey((Object)UPDATE_DURATION)) {
            abilityFormInfo.updateDuration = jSONObject.getIntValue(UPDATE_DURATION);
        }
        if (jSONObject.containsKey((Object)SUPPORT_DIMENSIONS)) {
            abilityFormInfo.supportDimensions = JSONObject.parseArray((String)JsonUtil.getJsonString(jSONObject, SUPPORT_DIMENSIONS), String.class);
        }
        abilityFormInfo.defaultDimension = JsonUtil.getJsonString(jSONObject, DEFAULT_DIMENSION);
        if (jSONObject.containsKey((Object)"metaData")) {
            JSONObject jSONObject2 = jSONObject.getJSONObject("metaData");
            abilityFormInfo.metaData = JsonUtil.parseMetaData(jSONObject2);
        }
        return abilityFormInfo;
    }

    static ModuleProfileInfo parseModuleProfileInfo(String string, byte[] byArray, String string2, String string3, HashMap<String, String> hashMap) throws BundleException {
        ModuleProfileInfo moduleProfileInfo = new ModuleProfileInfo();
        JSONObject jSONObject = JSONObject.parseObject((String)string);
        if (jSONObject == null || !jSONObject.containsKey((Object)APP) || !jSONObject.containsKey((Object)MODULE)) {
            LOG.error("JsonUtil::parseModuleProfileInfo exception: app or module is null.");
            throw new BundleException("Parse module profile info failed, app or module is null.");
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject(APP);
        moduleProfileInfo.moduleAppInfo = JsonUtil.parseModuleAppInfo(jSONObject2, byArray);
        JSONObject jSONObject3 = jSONObject.getJSONObject(MODULE);
        moduleProfileInfo.moduleInfo = JsonUtil.parseModuleHapInfo(jSONObject3, byArray, moduleProfileInfo.moduleAppInfo.bundleName, hashMap);
        moduleProfileInfo.moduleInfo.appModel = AppModel.STAGE;
        moduleProfileInfo.moduleInfo.dependenies.addAll(JsonUtil.parseDenpendencies(jSONObject2, jSONObject3));
        block0: for (ModuleAbilityInfo moduleAbilityInfo : moduleProfileInfo.moduleInfo.abilities) {
            for (SkillInfo skillInfo : moduleAbilityInfo.skills) {
                if (!skillInfo.actions.contains(ACTION_SYSTEM_HOME) || !skillInfo.entities.contains(ENTITY_SYSTEM_HOME)) continue;
                moduleProfileInfo.moduleAppInfo.appName = moduleAbilityInfo.label;
                moduleProfileInfo.moduleAppInfo.appNameEN = moduleAbilityInfo.label;
                continue block0;
            }
        }
        return moduleProfileInfo;
    }

    static ModuleInfo parseModuleHapInfo(JSONObject jSONObject, byte[] byArray, String string, HashMap<String, String> hashMap) throws BundleException {
        ModuleInfo moduleInfo = new ModuleInfo();
        if (jSONObject == null) {
            LOG.error("JsonUtil::parseModuleHapInfo exception: moduleJson is null.");
            throw new BundleException("Parse module hap info failed, moduleJson is null.");
        }
        moduleInfo.name = JsonUtil.getJsonString(jSONObject, NAME);
        moduleInfo.type = JsonUtil.getJsonString(jSONObject, TYPE);
        moduleInfo.srcEntrance = jSONObject.containsKey((Object)SRC_ENTRY) ? JsonUtil.getJsonString(jSONObject, SRC_ENTRY) : JsonUtil.getJsonString(jSONObject, SRC_ENTRANCE);
        moduleInfo.description = JsonUtil.parseResourceByKey(jSONObject, byArray, DESCRIPTION, DESCRIPTION_ID);
        moduleInfo.setDescriptions(JsonUtil.parseResourceMapByKey(jSONObject, byArray, DESCRIPTION_ID));
        moduleInfo.process = jSONObject.containsKey((Object)PROCESS) ? JsonUtil.getJsonString(jSONObject, PROCESS) : string;
        moduleInfo.mainElement = JsonUtil.getJsonString(jSONObject, MAIN_ELEMENT);
        if (jSONObject.containsKey((Object)DEVICE_TYPES)) {
            moduleInfo.deviceTypes = JSONObject.parseArray((String)JsonUtil.getJsonString(jSONObject, DEVICE_TYPES), String.class);
        }
        moduleInfo.deliveryWithInstall = JsonUtil.getJsonBooleanValue(jSONObject, "deliveryWithInstall", true);
        JsonUtil.parseInstallationFree(jSONObject, moduleInfo);
        moduleInfo.virtualMachine = JsonUtil.getJsonString(jSONObject, VIRTUAL_MACHINE, DEFAULT);
        moduleInfo.uiSyntax = JsonUtil.getJsonString(jSONObject, UI_SYNTAX, HML);
        moduleInfo.pages = JsonUtil.parseModulePages(jSONObject, hashMap);
        moduleInfo.moduleMetadataInfos = JsonUtil.parseModuleMetadataInfos(jSONObject, byArray, hashMap);
        if (!moduleInfo.moduleMetadataInfos.isEmpty()) {
            moduleInfo.moduleShortcuts = JsonUtil.parseModuleShortcut(moduleInfo.moduleMetadataInfos, byArray);
            moduleInfo.distroFilter = JsonUtil.parseModuleDistrofilterFromMetadata(moduleInfo.moduleMetadataInfos);
        }
        JsonUtil.parseModuleAbilityAndAddShortcut(jSONObject, moduleInfo, byArray, hashMap);
        JsonUtil.parseStageExtensionAbility(jSONObject, moduleInfo, byArray, hashMap);
        moduleInfo.requestPermissions = JsonUtil.parseReqPermission(jSONObject, byArray);
        moduleInfo.definePermissions = JsonUtil.parseDefinePermissions(jSONObject, byArray);
        moduleInfo.moduleAtomicService = JsonUtil.parseModuleAtomicService(jSONObject);
        return moduleInfo;
    }

    private static List<DependencyItem> parseDenpendencies(JSONObject jSONObject, JSONObject jSONObject2) throws BundleException {
        if (jSONObject == null || jSONObject2 == null) {
            LOG.error("JsonUtil::parseModuleHapInfo exception: moduleJson or appJson is null.");
            throw new BundleException("Parse module hap info failed, moduleJson or appJson is null.");
        }
        String string = JsonUtil.getJsonString(jSONObject, "bundleName");
        ArrayList<DependencyItem> arrayList = new ArrayList<DependencyItem>();
        if (!jSONObject2.containsKey((Object)DEPENDENCIES)) {
            return arrayList;
        }
        JSONArray jSONArray = jSONObject2.getJSONArray(DEPENDENCIES);
        for (int i = 0; i < jSONArray.size(); ++i) {
            JSONObject jSONObject3 = jSONArray.getJSONObject(i);
            DependencyItem dependencyItem = new DependencyItem();
            if (jSONObject3.containsKey((Object)"bundleName")) {
                dependencyItem.setBundleName(jSONObject3.getString("bundleName"));
            } else {
                dependencyItem.setBundleName(string);
            }
            if (jSONObject3.containsKey((Object)"moduleName")) {
                dependencyItem.setModuleName(jSONObject3.getString("moduleName"));
            }
            if (jSONObject3.containsKey((Object)"versionCode")) {
                dependencyItem.setVersionCode(jSONObject3.getIntValue("versionCode"));
            }
            arrayList.add(dependencyItem);
        }
        return arrayList;
    }

    private static void parseInstallationFree(JSONObject jSONObject, ModuleInfo moduleInfo) {
        boolean bl;
        moduleInfo.installationFree = jSONObject.containsKey((Object)INSTALLATION_FREE) ? ((bl = jSONObject.getBoolean(INSTALLATION_FREE).booleanValue()) ? 1 : 0) : 2;
    }

    static List<String> parseModulePages(JSONObject jSONObject, HashMap<String, String> hashMap) throws BundleException {
        JSONObject jSONObject2;
        List<String> list = new ArrayList<String>();
        String string = JsonUtil.getJsonString(jSONObject, PAGES);
        if (string.isEmpty()) {
            return list;
        }
        string = string.replace(PROFILE, EMPTY);
        String string2 = hashMap.get(string = string + JSON_SUFFIX);
        if (string2 != null && (jSONObject2 = JSONObject.parseObject((String)string2)) != null) {
            list = JSONObject.parseArray((String)JsonUtil.getJsonString(jSONObject2, SRC), String.class);
        }
        return list;
    }

    static DistroFilter parseModuleDistrofilterFromMetadata(List<ModuleMetadataInfo> list) {
        for (ModuleMetadataInfo moduleMetadataInfo : list) {
            String string = moduleMetadataInfo.resource;
            if (string.isEmpty()) continue;
            JSONObject jSONObject = JSONObject.parseObject((String)string);
            if (jSONObject.containsKey((Object)DISTRIBUTION_FILTER)) {
                return (DistroFilter)JSONObject.parseObject((String)JsonUtil.getJsonString(jSONObject, DISTRIBUTION_FILTER), DistroFilter.class);
            }
            if (!jSONObject.containsKey((Object)DISTRO_FILTER)) continue;
            return (DistroFilter)JSONObject.parseObject((String)JsonUtil.getJsonString(jSONObject, DISTRO_FILTER), DistroFilter.class);
        }
        return null;
    }

    static List<ExtensionAbilityInfo> parseModuleExtensionAbilities(JSONObject jSONObject, byte[] byArray, HashMap<String, String> hashMap) throws BundleException {
        ArrayList<ExtensionAbilityInfo> arrayList = new ArrayList<ExtensionAbilityInfo>();
        JSONArray jSONArray = jSONObject.getJSONArray(EXTENSION_ABILITIES);
        int n = jSONArray.size();
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            arrayList.add(JsonUtil.parseModuleExtensionAbility(jSONObject2, byArray, hashMap));
        }
        return arrayList;
    }

    private static void parseStageExtensionAbility(JSONObject jSONObject, ModuleInfo moduleInfo, byte[] byArray, HashMap<String, String> hashMap) throws BundleException {
        if (!jSONObject.containsKey((Object)EXTENSION_ABILITIES)) {
            return;
        }
        String string = JsonUtil.parseStageServiceProvider(jSONObject, moduleInfo.abilities);
        moduleInfo.extensionAbilityInfos = JsonUtil.parseModuleExtensionAbilities(jSONObject, byArray, hashMap);
        moduleInfo.abilityFormInfos = JsonUtil.parseModuleAbilityforms(moduleInfo.extensionAbilityInfos, byArray, string);
        moduleInfo.commonEvents = JsonUtil.parseModuleCommonEvents(moduleInfo.extensionAbilityInfos);
    }

    static ExtensionAbilityInfo parseModuleExtensionAbility(JSONObject jSONObject, byte[] byArray, HashMap<String, String> hashMap) throws BundleException {
        if (jSONObject == null) {
            LOG.error("JsonUtil::parseModuleExtensionAbility exception: extensionAbilityJson is null.");
            throw new BundleException("Parse ability failed, abilityJson is null.");
        }
        ExtensionAbilityInfo extensionAbilityInfo = new ExtensionAbilityInfo();
        extensionAbilityInfo.name = JsonUtil.getJsonString(jSONObject, NAME);
        extensionAbilityInfo.srcEntrance = jSONObject.containsKey((Object)SRC_ENTRY) ? JsonUtil.getJsonString(jSONObject, SRC_ENTRY) : JsonUtil.getJsonString(jSONObject, SRC_ENTRANCE);
        extensionAbilityInfo.icon = JsonUtil.parseIconById(jSONObject, byArray);
        extensionAbilityInfo.label = JsonUtil.parseResourceByKey(jSONObject, byArray, LABEL, LABEL_ID);
        extensionAbilityInfo.setLabels(JsonUtil.parseResourceMapByKey(jSONObject, byArray, LABEL_ID));
        extensionAbilityInfo.description = JsonUtil.parseResourceByKey(jSONObject, byArray, DESCRIPTION, DESCRIPTION_ID);
        extensionAbilityInfo.setDescriptions(JsonUtil.parseResourceMapByKey(jSONObject, byArray, DESCRIPTION_ID));
        extensionAbilityInfo.type = JsonUtil.getJsonString(jSONObject, TYPE);
        if (jSONObject.containsKey((Object)PERMISSIONS)) {
            extensionAbilityInfo.permissions = JSONObject.parseArray((String)JsonUtil.getJsonString(jSONObject, PERMISSIONS), String.class);
        }
        extensionAbilityInfo.uri = JsonUtil.getJsonString(jSONObject, URI);
        extensionAbilityInfo.readPermission = JsonUtil.getJsonString(jSONObject, READ_PERMISSION);
        extensionAbilityInfo.writePermission = JsonUtil.getJsonString(jSONObject, WRITE_PERMISSION);
        if (jSONObject.containsKey((Object)SKILLS)) {
            extensionAbilityInfo.skills = JSONObject.parseArray((String)JsonUtil.getJsonString(jSONObject, SKILLS), SkillInfo.class);
        }
        if (jSONObject.containsKey((Object)META_DATA)) {
            extensionAbilityInfo.metadataInfos = JsonUtil.parseModuleMetadataInfos(jSONObject, byArray, hashMap);
            ModuleAdaption moduleAdaption = new ModuleAdaption();
            extensionAbilityInfo.metadata = moduleAdaption.convertToMetadata(extensionAbilityInfo.metadataInfos);
        }
        extensionAbilityInfo.visible = jSONObject.containsKey((Object)EXPORTED) ? JsonUtil.getJsonBooleanValue(jSONObject, EXPORTED, false) : JsonUtil.getJsonBooleanValue(jSONObject, VISIBLE, false);
        return extensionAbilityInfo;
    }

    static List<ModuleAbilityInfo> parseModuleAbilities(JSONObject jSONObject, byte[] byArray, HashMap<String, String> hashMap) throws BundleException {
        ArrayList<ModuleAbilityInfo> arrayList = new ArrayList<ModuleAbilityInfo>();
        if (!jSONObject.containsKey((Object)ABILITIES)) {
            return arrayList;
        }
        JSONArray jSONArray = jSONObject.getJSONArray(ABILITIES);
        int n = jSONArray.size();
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            arrayList.add(JsonUtil.parseModuleAbility(jSONObject2, byArray, hashMap));
        }
        return arrayList;
    }

    private static void parseModuleAbilityAndAddShortcut(JSONObject jSONObject, ModuleInfo moduleInfo, byte[] byArray, HashMap<String, String> hashMap) throws BundleException {
        moduleInfo.abilities = JsonUtil.parseModuleAbilities(jSONObject, byArray, hashMap);
        for (ModuleAbilityInfo moduleAbilityInfo : moduleInfo.abilities) {
            moduleInfo.moduleShortcuts.addAll(JsonUtil.parseModuleShortcut(moduleAbilityInfo.metadata, byArray));
        }
    }

    static ModuleAbilityInfo parseModuleAbility(JSONObject jSONObject, byte[] byArray, HashMap<String, String> hashMap) throws BundleException {
        if (jSONObject == null) {
            LOG.error("Uncompress::parseModuleAbility exception: abilityJson is null.");
            throw new BundleException("Parse ability failed, abilityJson is null.");
        }
        ModuleAbilityInfo moduleAbilityInfo = new ModuleAbilityInfo();
        moduleAbilityInfo.name = JsonUtil.getJsonString(jSONObject, NAME);
        moduleAbilityInfo.srcEntrance = jSONObject.containsKey((Object)SRC_ENTRY) ? JsonUtil.getJsonString(jSONObject, SRC_ENTRY) : JsonUtil.getJsonString(jSONObject, SRC_ENTRANCE);
        moduleAbilityInfo.launchType = JsonUtil.getJsonString(jSONObject, LAUNCH_TYPE, STANDARD);
        moduleAbilityInfo.description = JsonUtil.parseResourceByKey(jSONObject, byArray, DESCRIPTION, DESCRIPTION_ID);
        moduleAbilityInfo.setDescriptions(JsonUtil.parseResourceMapByKey(jSONObject, byArray, DESCRIPTION_ID));
        moduleAbilityInfo.icon = JsonUtil.parseIconById(jSONObject, byArray);
        moduleAbilityInfo.label = JsonUtil.parseResourceByKey(jSONObject, byArray, LABEL, LABEL_ID);
        moduleAbilityInfo.setLabels(JsonUtil.parseResourceMapByKey(jSONObject, byArray, LABEL_ID));
        if (jSONObject.containsKey((Object)PERMISSIONS)) {
            moduleAbilityInfo.permissions = JSONObject.parseArray((String)JsonUtil.getJsonString(jSONObject, PERMISSIONS), String.class);
        }
        moduleAbilityInfo.metadata = JsonUtil.parseModuleMetadataInfos(jSONObject, byArray, hashMap);
        moduleAbilityInfo.visible = jSONObject.containsKey((Object)EXPORTED) ? JsonUtil.getJsonBooleanValue(jSONObject, EXPORTED, false) : JsonUtil.getJsonBooleanValue(jSONObject, VISIBLE, false);
        moduleAbilityInfo.continuable = JsonUtil.getJsonBooleanValue(jSONObject, CONTINUABLE, false);
        if (jSONObject.containsKey((Object)SKILLS)) {
            moduleAbilityInfo.skills = JSON.parseArray((String)JsonUtil.getJsonString(jSONObject, SKILLS), SkillInfo.class);
        }
        if (jSONObject.containsKey((Object)BACKGROUND_MODES)) {
            moduleAbilityInfo.backgroundModes = JSONArray.parseArray((String)JsonUtil.getJsonString(jSONObject, BACKGROUND_MODES), String.class);
        }
        return moduleAbilityInfo;
    }

    static List<ModuleMetadataInfo> parseModuleMetadataInfos(JSONObject jSONObject, byte[] byArray, HashMap<String, String> hashMap) throws BundleException {
        ArrayList<ModuleMetadataInfo> arrayList = new ArrayList<ModuleMetadataInfo>();
        if (!jSONObject.containsKey((Object)META_DATA)) {
            return arrayList;
        }
        try {
            JSONArray jSONArray = jSONObject.getJSONArray(META_DATA);
            for (int i = 0; i < jSONArray.size(); ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                arrayList.add(JsonUtil.parseModuleMetadata(jSONObject2, byArray, hashMap));
            }
        }
        catch (JSONException | NullPointerException throwable) {
            LOG.warning("JsonUtil::parseModuleMetadataInfos err: " + throwable.getMessage());
        }
        return arrayList;
    }

    static ModuleMetadataInfo parseModuleMetadata(JSONObject jSONObject, byte[] byArray, HashMap<String, String> hashMap) throws BundleException {
        if (jSONObject == null) {
            LOG.error("JsonUtil::parseModuleMetadata exception: jsonObject is null.");
            throw new BundleException("Parse ModuleMetadataInfo failed, jsonObject is null.");
        }
        ModuleMetadataInfo moduleMetadataInfo = new ModuleMetadataInfo();
        moduleMetadataInfo.name = JsonUtil.getJsonString(jSONObject, NAME);
        moduleMetadataInfo.value = JsonUtil.getJsonString(jSONObject, VALUE);
        if (jSONObject.containsKey((Object)RESOURCE)) {
            String string = moduleMetadataInfo.resource = JsonUtil.getJsonString(jSONObject, RESOURCE);
            string = string.replace(PROFILE, EMPTY);
            String string2 = hashMap.get(string = string + JSON_SUFFIX);
            if (string2 == null) {
                LOG.warning("JsonUtil::parseModuleMetadata : metadata.resource value is null");
                moduleMetadataInfo.resource = EMPTY;
            } else {
                moduleMetadataInfo.resource = hashMap.get(string);
            }
        }
        return moduleMetadataInfo;
    }

    static List<AbilityFormInfo> parseModuleAbilityforms(List<ExtensionAbilityInfo> list, byte[] byArray, String string) throws BundleException {
        ArrayList<AbilityFormInfo> arrayList = new ArrayList<AbilityFormInfo>();
        if (list.isEmpty()) {
            return arrayList;
        }
        for (ExtensionAbilityInfo extensionAbilityInfo : list) {
            List<AbilityFormInfo> list2 = JsonUtil.parseModuleFormInfoInMetadata(byArray, extensionAbilityInfo.metadataInfos);
            if (FORM.equals(extensionAbilityInfo.type)) {
                for (AbilityFormInfo abilityFormInfo : list2) {
                    abilityFormInfo.providerAbility = string;
                    abilityFormInfo.setFormExtensionAbilityName(extensionAbilityInfo.name);
                }
            }
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    static List<CommonEvent> parseModuleCommonEvents(List<ExtensionAbilityInfo> list) {
        ArrayList<CommonEvent> arrayList = new ArrayList<CommonEvent>();
        if (list.isEmpty()) {
            return arrayList;
        }
        for (ExtensionAbilityInfo extensionAbilityInfo : list) {
            List<CommonEvent> list2 = JsonUtil.parseCommoneventsInMetadata(extensionAbilityInfo.metadataInfos);
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    static List<CommonEvent> parseCommoneventsInMetadata(List<ModuleMetadataInfo> list) {
        ArrayList<CommonEvent> arrayList = new ArrayList<CommonEvent>();
        for (ModuleMetadataInfo moduleMetadataInfo : list) {
            String string = moduleMetadataInfo.resource;
            JSONObject jSONObject = JSONObject.parseObject((String)string);
            if (jSONObject == null || !jSONObject.containsKey((Object)"commonEvents")) continue;
            arrayList.addAll(JsonUtil.parseModuleCommonEvents(jSONObject));
        }
        return arrayList;
    }

    static List<CommonEvent> parseModuleCommonEvents(JSONObject jSONObject) {
        ArrayList<CommonEvent> arrayList = new ArrayList<CommonEvent>();
        try {
            JSONArray jSONArray = jSONObject.getJSONArray("commonEvents");
            for (int i = 0; i < jSONArray.size(); ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                CommonEvent commonEvent = new CommonEvent();
                if (jSONObject2.containsKey((Object)NAME)) {
                    commonEvent.name = JsonUtil.getJsonString(jSONObject2, NAME);
                }
                if (jSONObject2.containsKey((Object)"permission")) {
                    commonEvent.permission = JsonUtil.getJsonString(jSONObject2, "permission");
                }
                if (jSONObject2.containsKey((Object)"types")) {
                    commonEvent.type = JSON.parseArray((String)JsonUtil.getJsonString(jSONObject2, "types"), String.class);
                }
                if (jSONObject2.containsKey((Object)"events")) {
                    commonEvent.events = JSON.parseArray((String)JsonUtil.getJsonString(jSONObject2, "events"), String.class);
                }
                arrayList.add(commonEvent);
            }
        }
        catch (JSONException | NullPointerException throwable) {
            LOG.warning("JsonUtil::parseModuleCommonEvents err: " + throwable.getMessage());
        }
        return arrayList;
    }

    static List<ModuleShortcut> parseModuleShortcut(List<ModuleMetadataInfo> list, byte[] byArray) throws BundleException {
        ArrayList<ModuleShortcut> arrayList = new ArrayList<ModuleShortcut>();
        for (ModuleMetadataInfo moduleMetadataInfo : list) {
            String string = moduleMetadataInfo.resource;
            if (string == null || string.isEmpty()) continue;
            try {
                JSONObject jSONObject = JSON.parseObject((String)string);
                if (!jSONObject.containsKey((Object)"shortcuts")) continue;
                JSONArray jSONArray = jSONObject.getJSONArray("shortcuts");
                for (int i = 0; i < jSONArray.size(); ++i) {
                    arrayList.add(JsonUtil.parseModuleShortcutObj(jSONArray.getJSONObject(i), byArray));
                }
            }
            catch (JSONException jSONException) {
                LOG.warning("ignored metadata: " + moduleMetadataInfo.name);
            }
        }
        return arrayList;
    }

    static ModuleShortcut parseModuleShortcutObj(JSONObject jSONObject, byte[] byArray) throws BundleException {
        if (jSONObject == null) {
            LOG.error("JsonUtil::parseModuleShortcutObj failed");
            throw new BundleException("JsonUtil::parseModuleShortcutObj failed");
        }
        ModuleShortcut moduleShortcut = new ModuleShortcut();
        if (jSONObject.containsKey((Object)"shortcutId")) {
            moduleShortcut.setShortcutId(jSONObject.getString("shortcutId"));
        }
        if (jSONObject.containsKey((Object)LABEL)) {
            moduleShortcut.setLabel(JsonUtil.parseResourceByStringID(byArray, JsonUtil.getJsonString(jSONObject, LABEL)));
        }
        moduleShortcut.setLabels(JsonUtil.parseResourceMapByKey(jSONObject, byArray, LABEL_ID));
        if (jSONObject.containsKey((Object)"icon")) {
            String string = JsonUtil.parseResourceByStringID(byArray, JsonUtil.getJsonString(jSONObject, "icon"));
            moduleShortcut.setIcon(string.substring(string.indexOf("resources")));
        }
        if (jSONObject.containsKey((Object)"wants")) {
            moduleShortcut.setWants(JSON.parseArray((String)JsonUtil.getJsonString(jSONObject, "wants"), Want.class));
        }
        return moduleShortcut;
    }

    static List<Shortcut> parseShoruCuts(JSONObject jSONObject, byte[] byArray) throws BundleException {
        ArrayList<Shortcut> arrayList = new ArrayList<Shortcut>();
        if (jSONObject.containsKey((Object)"shortcuts")) {
            JSONArray jSONArray = jSONObject.getJSONArray("shortcuts");
            for (int i = 0; i < jSONArray.size(); ++i) {
                arrayList.add(JsonUtil.parseShortObj(jSONArray.getJSONObject(i), byArray));
            }
        }
        return arrayList;
    }

    static Shortcut parseShortObj(JSONObject jSONObject, byte[] byArray) throws BundleException {
        if (jSONObject == null) {
            LOG.error("JsonUtil::parseModuleShortcutObj failed");
            throw new BundleException("JsonUtil::parseModuleShortcutObj failed");
        }
        Shortcut shortcut = new Shortcut();
        if (jSONObject.containsKey((Object)"shortcutId")) {
            shortcut.shortcutId = jSONObject.getString("shortcutId");
        }
        if (jSONObject.containsKey((Object)LABEL)) {
            shortcut.label = JsonUtil.parseResourceByKey(jSONObject, byArray, LABEL, LABEL_ID);
        }
        shortcut.setLabels(JsonUtil.parseResourceMapByKey(jSONObject, byArray, LABEL_ID));
        if (jSONObject.containsKey((Object)"icon")) {
            shortcut.icon = JsonUtil.parseIconById(jSONObject, byArray);
        }
        if (jSONObject.containsKey((Object)"intents")) {
            shortcut.intents = JSON.parseArray((String)JsonUtil.getJsonString(jSONObject, "intents"), IntentInfo.class);
        }
        return shortcut;
    }

    static List<AbilityFormInfo> parseModuleFormInfoInMetadata(byte[] byArray, List<ModuleMetadataInfo> list) throws BundleException {
        ArrayList<AbilityFormInfo> arrayList = new ArrayList<AbilityFormInfo>();
        if (list.isEmpty()) {
            return arrayList;
        }
        for (ModuleMetadataInfo moduleMetadataInfo : list) {
            String string = moduleMetadataInfo.resource;
            JSONObject jSONObject = JSONObject.parseObject((String)string);
            if (jSONObject == null || !jSONObject.containsKey((Object)FORMS)) continue;
            JSONArray jSONArray = JSONObject.parseArray((String)JsonUtil.getJsonString(jSONObject, FORMS));
            int n = jSONArray.size();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                arrayList.add(JsonUtil.parseModuleForm(jSONObject2, byArray));
            }
        }
        return arrayList;
    }

    static AbilityFormInfo parseModuleForm(JSONObject jSONObject, byte[] byArray) throws BundleException {
        if (jSONObject == null) {
            LOG.error("JsonUtil::parseModuleForm exception: formObj is null.");
            throw new BundleException("Parse parseModuleForm failed, formObj is null.");
        }
        AbilityFormInfo abilityFormInfo = new AbilityFormInfo();
        abilityFormInfo.name = JsonUtil.getJsonString(jSONObject, NAME);
        abilityFormInfo.description = JsonUtil.parseFormDescription(jSONObject, byArray);
        abilityFormInfo.setDescriptions(JsonUtil.parseFormDescriptions(jSONObject, byArray));
        abilityFormInfo.src = JsonUtil.getJsonString(jSONObject, SRC);
        if (jSONObject.containsKey((Object)WINDOW)) {
            abilityFormInfo.windowInfo = (AbilityFormInfo.ModuleWindowInfo)JSON.parseObject((String)JsonUtil.getJsonString(jSONObject, WINDOW), AbilityFormInfo.ModuleWindowInfo.class);
        }
        abilityFormInfo.isDefault = JsonUtil.getJsonBooleanValue(jSONObject, IS_DEFAULT, false);
        abilityFormInfo.colorMode = JsonUtil.getJsonString(jSONObject, COLOR_MODE, AUTO);
        if (jSONObject.containsKey((Object)SUPPORT_DIMENSIONS)) {
            abilityFormInfo.supportDimensions = JSONObject.parseArray((String)JsonUtil.getJsonString(jSONObject, SUPPORT_DIMENSIONS), String.class);
        }
        abilityFormInfo.defaultDimension = JsonUtil.getJsonString(jSONObject, DEFAULT_DIMENSION);
        abilityFormInfo.updateEnabled = JsonUtil.getJsonBooleanValue(jSONObject, UPDATE_ENABLED, false);
        abilityFormInfo.scheduledUpdateTime = JsonUtil.getJsonString(jSONObject, SCHEDULE_UPDATE_TIME);
        abilityFormInfo.updateDuration = JsonUtil.getJsonIntValue(jSONObject, UPDATE_DURATION, 1);
        abilityFormInfo.formConfigAbility = JsonUtil.getJsonString(jSONObject, FROM_CONFIG_ABILITY);
        abilityFormInfo.formVisibleNotify = JsonUtil.getJsonBooleanValue(jSONObject, FORM_VISIBLE_NOTIFY, false);
        return abilityFormInfo;
    }

    private static String parseFormDescription(JSONObject jSONObject, byte[] byArray) throws BundleException {
        if (jSONObject.containsKey((Object)DESCRIPTION)) {
            String string = JsonUtil.getJsonString(jSONObject, DESCRIPTION);
            if (string.contains(STRING_RESOURCE)) {
                return JsonUtil.parseResourceByStringID(byArray, string);
            }
            return string;
        }
        return EMPTY;
    }

    private static HashMap<String, String> parseFormDescriptions(JSONObject jSONObject, byte[] byArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!jSONObject.containsKey((Object)DESCRIPTION)) {
            return hashMap;
        }
        String string = JsonUtil.getJsonString(jSONObject, DESCRIPTION);
        if (string.contains(STRING_RESOURCE)) {
            int n = STRING_RESOURCE.length();
            String string2 = string.substring(n);
            try {
                int n2 = Integer.parseInt(string2);
                hashMap = ResourcesParser.getResourceMapById(n2, byArray);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.error("parseFormDescriptions failed: invalid descriptionId: " + string2);
            }
            return hashMap;
        }
        return hashMap;
    }

    static List<DefinePermission> parseDefinePermissions(JSONObject jSONObject, byte[] byArray) throws BundleException {
        ArrayList<DefinePermission> arrayList = new ArrayList<DefinePermission>();
        if (!jSONObject.containsKey((Object)DEFINE_PERMISSIONS)) {
            return arrayList;
        }
        try {
            JSONArray jSONArray = jSONObject.getJSONArray(DEFINE_PERMISSIONS);
            for (int i = 0; i < jSONArray.size(); ++i) {
                arrayList.add(JsonUtil.parseDefinePermission(jSONArray.getJSONObject(i), byArray));
            }
        }
        catch (JSONException | NullPointerException throwable) {
            LOG.warning("JsonUtil::parseDefinePermissions err: " + throwable.getMessage());
        }
        return arrayList;
    }

    static ModuleAtomicService parseModuleAtomicService(JSONObject jSONObject) {
        ModuleAtomicService moduleAtomicService = new ModuleAtomicService();
        try {
            JSONObject jSONObject2 = null;
            if (!jSONObject.containsKey((Object)ATOMIC_SERVICE)) {
                return moduleAtomicService;
            }
            jSONObject2 = jSONObject.getJSONObject(ATOMIC_SERVICE);
            JSONArray jSONArray = jSONObject2.getJSONArray(PRELOADS);
            ArrayList<PreloadItem> arrayList = new ArrayList<PreloadItem>();
            for (int i = 0; i < jSONArray.size(); ++i) {
                PreloadItem preloadItem = new PreloadItem();
                JSONObject jSONObject3 = jSONArray.getJSONObject(i);
                if (jSONObject3.containsKey((Object)"moduleName")) {
                    preloadItem.setModuleName(JsonUtil.getJsonString(jSONObject3, "moduleName"));
                }
                arrayList.add(preloadItem);
            }
            moduleAtomicService.setPreloadItems(arrayList);
        }
        catch (JSONException | NullPointerException throwable) {
            LOG.warning("JsonUtil::parseModuleAtomicService err: " + throwable.getMessage());
        }
        return moduleAtomicService;
    }

    static DefinePermission parseDefinePermission(JSONObject jSONObject, byte[] byArray) throws BundleException {
        DefinePermission definePermission = new DefinePermission();
        definePermission.name = JsonUtil.getJsonString(jSONObject, NAME, definePermission.name);
        definePermission.grantMode = JsonUtil.getJsonString(jSONObject, "grantMode", definePermission.grantMode);
        definePermission.availableLevel = JsonUtil.getJsonString(jSONObject, "availableLevel", definePermission.availableLevel);
        if (jSONObject.containsKey((Object)"provisionEnable")) {
            definePermission.provisionEnable = jSONObject.getBoolean("provisionEnable");
        }
        if (jSONObject.containsKey((Object)"distributedSceneEnable")) {
            definePermission.distributedSceneEnable = jSONObject.getBoolean("distributedSceneEnable");
        }
        definePermission.label = JsonUtil.parseResourceByKey(jSONObject, byArray, LABEL, LABEL_ID);
        definePermission.setLabels(JsonUtil.parseResourceMapByKey(jSONObject, byArray, LABEL_ID));
        definePermission.description = JsonUtil.parseResourceByKey(jSONObject, byArray, DESCRIPTION, DESCRIPTION_ID);
        definePermission.setDescriptions(JsonUtil.parseResourceMapByKey(jSONObject, byArray, DESCRIPTION_ID));
        return definePermission;
    }

    static List<DefPermission> parseDefPermissions(JSONObject jSONObject, byte[] byArray) throws BundleException {
        ArrayList<DefPermission> arrayList = new ArrayList<DefPermission>();
        if (jSONObject.containsKey((Object)"defPermissions")) {
            JSONArray jSONArray = jSONObject.getJSONArray("defPermissions");
            for (int i = 0; i < jSONArray.size(); ++i) {
                arrayList.add(JsonUtil.parseDefPermission(jSONArray.getJSONObject(i), byArray));
            }
        }
        return arrayList;
    }

    static DefPermission parseDefPermission(JSONObject jSONObject, byte[] byArray) throws BundleException {
        DefPermission defPermission = new DefPermission();
        if (jSONObject.containsKey((Object)NAME)) {
            defPermission.name = JsonUtil.getJsonString(jSONObject, NAME);
        }
        if (jSONObject.containsKey((Object)"grantMode")) {
            defPermission.grantMode = JsonUtil.getJsonString(jSONObject, "grantMode");
        }
        if (jSONObject.containsKey((Object)"availableScope")) {
            defPermission.availableScope = JSONObject.parseArray((String)JsonUtil.getJsonString(jSONObject, "availableScope"), String.class);
        }
        defPermission.label = JsonUtil.parseResourceByKey(jSONObject, byArray, LABEL, LABEL_ID);
        defPermission.setLabels(JsonUtil.parseResourceMapByKey(jSONObject, byArray, LABEL_ID));
        defPermission.description = JsonUtil.parseResourceByKey(jSONObject, byArray, DESCRIPTION, DESCRIPTION_ID);
        defPermission.setDescriptions(JsonUtil.parseResourceMapByKey(jSONObject, byArray, DESCRIPTION_ID));
        if (jSONObject.containsKey((Object)"group")) {
            defPermission.group = JsonUtil.getJsonString(jSONObject, "group");
        }
        return defPermission;
    }

    static String parseResourceByStringID(byte[] byArray, String string) throws BundleException {
        String string2 = EMPTY;
        int n = 0;
        while (string.charAt(n) < '0' || string.charAt(n) > '9') {
            ++n;
        }
        try {
            int n2 = Integer.parseInt(string.substring(n));
            string2 = ResourcesParser.getResourceStringById(n2, byArray);
        }
        catch (NumberFormatException numberFormatException) {
            LOG.error("parseResourceByStringID failed: input invalid of " + string + DOT);
        }
        return string2;
    }

    static String parseResourceByKey(JSONObject jSONObject, byte[] byArray, String string, String string2) {
        String string3 = EMPTY;
        if (jSONObject.containsKey((Object)string2)) {
            int n = jSONObject.getIntValue(string2);
            string3 = ResourcesParser.getResourceStringById(n, byArray);
        }
        if (string3 != null && !string3.isEmpty()) {
            return string3;
        }
        if (jSONObject.containsKey((Object)string)) {
            return JsonUtil.getJsonString(jSONObject, string);
        }
        return EMPTY;
    }

    static HashMap<String, String> parseResourceMapByKey(JSONObject jSONObject, byte[] byArray, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (jSONObject.containsKey((Object)string)) {
            int n = jSONObject.getIntValue(string);
            hashMap = ResourcesParser.getResourceMapById(n, byArray);
        }
        return hashMap;
    }

    static String parseIconById(JSONObject jSONObject, byte[] byArray) throws BundleException {
        String string = EMPTY;
        if (jSONObject.containsKey((Object)"iconId")) {
            int n = jSONObject.getIntValue("iconId");
            string = ResourcesParser.getBaseResourceById(n, byArray);
            if (string.isEmpty()) {
                string = ResourcesParser.getResourceById(n, byArray);
            }
            if (string.contains("resources")) {
                string = string.substring(string.indexOf("resources"));
            } else {
                LOG.warning("JsonUtil::parseIconById not found: " + n);
            }
        }
        if (!string.isEmpty()) {
            return string;
        }
        if (jSONObject.containsKey((Object)"icon")) {
            return JsonUtil.getJsonString(jSONObject, "icon");
        }
        return EMPTY;
    }

    static List<ReqPermission> parseReqPermission(JSONObject jSONObject, byte[] byArray) throws BundleException {
        ArrayList<ReqPermission> arrayList = new ArrayList<ReqPermission>();
        if (!jSONObject.containsKey((Object)REQUEST_PERMISSIONS)) {
            return arrayList;
        }
        JSONArray jSONArray = jSONObject.getJSONArray(REQUEST_PERMISSIONS);
        for (int i = 0; i < jSONArray.size(); ++i) {
            ReqPermission reqPermission = new ReqPermission();
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            reqPermission.name = JsonUtil.getJsonString(jSONObject2, NAME);
            reqPermission.reason = JsonUtil.parseResourceByKey(jSONObject2, byArray, REASON, REASON_ID);
            if (jSONObject2.containsKey((Object)REASON_ID)) {
                reqPermission.setReasons(JsonUtil.parseResourceMapByKey(jSONObject2, byArray, REASON_ID));
            }
            if (jSONObject2.containsKey((Object)USED_SCENE)) {
                reqPermission.usedScene = JsonUtil.parseModuleUsedScene(jSONObject2.getJSONObject(USED_SCENE));
            }
            arrayList.add(reqPermission);
        }
        return arrayList;
    }

    private static UsedScene parseModuleUsedScene(JSONObject jSONObject) {
        UsedScene usedScene = new UsedScene();
        if (jSONObject.containsKey((Object)ABILITIES)) {
            usedScene.ability = JSON.parseArray((String)JsonUtil.getJsonString(jSONObject, ABILITIES), String.class);
        }
        if (jSONObject.containsKey((Object)WHEN)) {
            usedScene.when = JsonUtil.getJsonString(jSONObject, WHEN);
        }
        return usedScene;
    }

    private static String getJsonString(JSONObject jSONObject, String string) {
        String string2 = EMPTY;
        if (jSONObject != null && jSONObject.containsKey((Object)string) && jSONObject.get((Object)string) != null) {
            string2 = jSONObject.get((Object)string).toString();
        }
        return string2;
    }

    private static String getJsonString(JSONObject jSONObject, String string, String string2) {
        String string3 = string2;
        if (jSONObject != null && jSONObject.containsKey((Object)string) && jSONObject.get((Object)string) != null) {
            string3 = jSONObject.get((Object)string).toString();
        }
        return string3;
    }

    private static int getJsonIntValue(JSONObject jSONObject, String string, int n) {
        int n2 = n;
        if (jSONObject != null && jSONObject.containsKey((Object)string)) {
            n2 = jSONObject.getIntValue(string);
        }
        return n2;
    }

    private static boolean getJsonBooleanValue(JSONObject jSONObject, String string, boolean bl) {
        boolean bl2 = bl;
        if (jSONObject != null && jSONObject.containsKey((Object)string)) {
            bl2 = jSONObject.getBooleanValue(string);
        }
        return bl2;
    }

    private static void setFAProviderAbility(JSONObject jSONObject, HapInfo hapInfo, List<AbilityInfo> list) throws BundleException {
        if (list.isEmpty()) {
            throw new BundleException("JsonUtil::setProviderAbility abilityInfo is empty.");
        }
        String string = JsonUtil.parseFAServiceProviderAbility(jSONObject, list);
        for (AbilityInfo abilityInfo : list) {
            if (abilityInfo.formInfos.isEmpty()) continue;
            if (SERVICE.equals(abilityInfo.type)) {
                JsonUtil.setProviderAbilityForForm(abilityInfo.formInfos, string);
            }
            if (PAGE.equals(abilityInfo.type)) {
                JsonUtil.setProviderAbilityForForm(abilityInfo.formInfos, abilityInfo.name);
            }
            hapInfo.formInfos.addAll(abilityInfo.formInfos);
        }
    }

    private static void setProviderAbilityForForm(List<AbilityFormInfo> list, String string) {
        for (AbilityFormInfo abilityFormInfo : list) {
            abilityFormInfo.providerAbility = string;
        }
    }

    private static String parseStageServiceProvider(JSONObject jSONObject, List<ModuleAbilityInfo> list) throws BundleException {
        if (jSONObject.containsKey((Object)MAIN_ELEMENT)) {
            return JsonUtil.getJsonString(jSONObject, MAIN_ELEMENT);
        }
        if (!list.isEmpty()) {
            for (ModuleAbilityInfo moduleAbilityInfo : list) {
                if (!JsonUtil.isSystemHomeAbility(moduleAbilityInfo.skills)) continue;
                return moduleAbilityInfo.name;
            }
            return list.get((int)0).name;
        }
        return EMPTY;
    }

    private static String parseFAServiceProviderAbility(JSONObject jSONObject, List<AbilityInfo> list) throws BundleException {
        if (list.isEmpty()) {
            throw new BundleException("JsonUtil::parseServiceProviderAbility abilityInfos is empty.");
        }
        if (jSONObject.containsKey((Object)MAIN_ABILITY)) {
            return JsonUtil.getJsonString(jSONObject, MAIN_ABILITY);
        }
        for (AbilityInfo abilityInfo : list) {
            if (!JsonUtil.isSystemHomeAbility(abilityInfo.skills)) continue;
            return abilityInfo.name;
        }
        for (AbilityInfo abilityInfo : list) {
            if (!abilityInfo.type.equals(PAGE)) continue;
            return abilityInfo.name;
        }
        return EMPTY;
    }

    private static boolean isSystemHomeAbility(List<SkillInfo> list) {
        for (SkillInfo skillInfo : list) {
            if (!skillInfo.entities.contains(ENTITY_SYSTEM_HOME) || !skillInfo.actions.contains(ACTION_SYSTEM_HOME)) continue;
            return true;
        }
        return false;
    }

    static HQFInfo parsePatch(String string) throws BundleException {
        JSONObject jSONObject;
        HQFInfo hQFInfo = new HQFInfo();
        JSONObject jSONObject2 = JSON.parseObject((String)string);
        JSONObject jSONObject3 = jSONObject2.getJSONObject(APP);
        if (jSONObject3 == null) {
            LOG.error("parsePatch failed, input patch.json is invalid, patch.json has no app.");
            throw new BundleException("parsePatch failed, input patch.json is invalid.");
        }
        if (jSONObject3.containsKey((Object)"bundleName")) {
            hQFInfo.setBundleName(jSONObject3.getString("bundleName"));
        }
        if (jSONObject3.containsKey((Object)"versionCode")) {
            hQFInfo.setVersionCode(jSONObject3.getIntValue("versionCode"));
        }
        if (jSONObject3.containsKey((Object)"versionName")) {
            hQFInfo.setVersionName(jSONObject3.getString("versionName"));
        }
        if (jSONObject3.containsKey((Object)PATCH_VERSION_CODE)) {
            hQFInfo.setPatchVersionCode(jSONObject3.getIntValue(PATCH_VERSION_CODE));
        }
        if (jSONObject3.containsKey((Object)PATCH_VERSION_NAME)) {
            hQFInfo.setPatchVersionName(jSONObject3.getString(PATCH_VERSION_NAME));
        }
        if ((jSONObject = jSONObject2.getJSONObject(MODULE)) == null) {
            LOG.error("parse failed, input patch.json is invalid, patch.json has no module.");
            throw new BundleException("parse failed, input patch.json is invalid, patch.json has no module.");
        }
        if (jSONObject.containsKey((Object)NAME)) {
            hQFInfo.setModuleName(jSONObject.getString(NAME));
        }
        if (jSONObject.containsKey((Object)TYPE)) {
            hQFInfo.setType(jSONObject.getString(TYPE));
        }
        if (jSONObject.containsKey((Object)DEVICE_TYPES)) {
            hQFInfo.setDeviceTypes(JSONObject.parseArray((String)JsonUtil.getJsonString(jSONObject, DEVICE_TYPES), String.class));
        }
        if (jSONObject.containsKey((Object)ORIGINAL_MODULE_HASH)) {
            hQFInfo.setOriginalModuleHash(jSONObject.getString(ORIGINAL_MODULE_HASH));
        }
        return hQFInfo;
    }
}

