/*
 * Decompiled with CFR 0.152.
 */
package ohos;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ohos.AbilityInfo;
import ohos.AppInfo;
import ohos.CustomizeData;
import ohos.DeviceConfig;
import ohos.Distro;
import ohos.HapInfo;
import ohos.IntentInfo;
import ohos.Log;
import ohos.MetaData;
import ohos.ModuleAbilityInfo;
import ohos.ModuleAppInfo;
import ohos.ModuleDeviceType;
import ohos.ModuleInfo;
import ohos.ModuleMetadataInfo;
import ohos.ModuleProfileInfo;
import ohos.ModuleResult;
import ohos.ModuleShortcut;
import ohos.ProfileInfo;
import ohos.Shortcut;
import ohos.UncompressResult;
import ohos.Want;

class ModuleAdaption {
    private static final Log LOG = new Log(ModuleAdaption.class.toString());

    ModuleAdaption() {
    }

    UncompressResult convertToUncompressResult(ModuleResult moduleResult) {
        UncompressResult uncompressResult = new UncompressResult();
        uncompressResult.setResult(moduleResult.getResult());
        uncompressResult.setMessage(moduleResult.getMessage());
        for (String object : moduleResult.moduleProfileStr) {
            uncompressResult.addProfileInfoStr(object);
        }
        uncompressResult.setPackInfos(moduleResult.packInfos);
        for (int i = 0; i < moduleResult.moduleProfileInfos.size(); ++i) {
            ModuleProfileInfo moduleProfileInfo = moduleResult.moduleProfileInfos.get(i);
            ProfileInfo profileInfo = new ProfileInfo();
            profileInfo.hapName = moduleProfileInfo.hapName;
            profileInfo.appInfo = this.convertToAppInfo(moduleProfileInfo.moduleAppInfo);
            profileInfo.deviceConfig = this.convertToDeviceConfig(moduleProfileInfo.moduleAppInfo);
            profileInfo.hapInfo = this.convertToHapInfo(moduleProfileInfo.moduleInfo);
            uncompressResult.addProfileInfo(profileInfo);
        }
        for (ModuleProfileInfo moduleProfileInfo : moduleResult.moduleProfileInfos) {
            if (moduleProfileInfo.moduleAppInfo == null) continue;
            uncompressResult.setLabel(moduleProfileInfo.moduleAppInfo.label);
            uncompressResult.setIcon(moduleProfileInfo.moduleAppInfo.icon);
        }
        return uncompressResult;
    }

    AppInfo convertToAppInfo(ModuleAppInfo moduleAppInfo) {
        AppInfo appInfo = new AppInfo();
        if (moduleAppInfo == null) {
            LOG.error("convertToAppInfo failed: moduleAppInfo is null");
            return appInfo;
        }
        appInfo.bundleName = moduleAppInfo.bundleName;
        appInfo.debug = moduleAppInfo.debug;
        appInfo.icon = moduleAppInfo.icon;
        appInfo.label = moduleAppInfo.label;
        appInfo.setLabels(moduleAppInfo.getLabels());
        appInfo.description = moduleAppInfo.description;
        appInfo.setDescriptions(moduleAppInfo.getDescriptions());
        appInfo.vendor = moduleAppInfo.vendor;
        appInfo.versionCode = String.valueOf(moduleAppInfo.versionCode);
        appInfo.versionName = moduleAppInfo.versionName;
        appInfo.minCompatibleVersionCode = moduleAppInfo.minCompatibleVersionCode;
        appInfo.compatibleApiVersion = moduleAppInfo.minAPIVersion;
        appInfo.targetApiVersion = moduleAppInfo.targetAPIVersion;
        appInfo.releaseType = moduleAppInfo.apiReleaseType;
        appInfo.distributedNotificationEnabled = moduleAppInfo.distributedNotificationEnabled;
        appInfo.appName = moduleAppInfo.appName;
        appInfo.appNameEN = moduleAppInfo.appNameEN;
        appInfo.setBundleType(moduleAppInfo.getBundleType());
        appInfo.setCompileSdkType(moduleAppInfo.getCompileSdkType());
        appInfo.setCompileSdkVersion(moduleAppInfo.getCompileSdkVersion());
        return appInfo;
    }

    Map<String, DeviceConfig> convertToDeviceConfig(ModuleAppInfo moduleAppInfo) {
        HashMap<String, DeviceConfig> hashMap = new HashMap<String, DeviceConfig>();
        if (moduleAppInfo == null) {
            return hashMap;
        }
        for (Map.Entry<String, ModuleDeviceType> entry : moduleAppInfo.deviceTypes.entrySet()) {
            DeviceConfig deviceConfig = new DeviceConfig();
            deviceConfig.distributedNotificationEnabled = entry.getValue().distributedNotificationEnabled;
            hashMap.put(entry.getKey(), deviceConfig);
        }
        return hashMap;
    }

    HapInfo convertToHapInfo(ModuleInfo moduleInfo) {
        HapInfo hapInfo = new HapInfo();
        if (moduleInfo == null) {
            LOG.error("convertToHapInfo failed: moduleInfo is null");
            return hapInfo;
        }
        hapInfo.name = moduleInfo.name;
        hapInfo.distro = new Distro();
        hapInfo.distro.moduleName = moduleInfo.name;
        hapInfo.distro.moduleType = moduleInfo.type;
        hapInfo.distro.installationFree = moduleInfo.installationFree;
        hapInfo.distro.virtualMachine = moduleInfo.virtualMachine;
        hapInfo.distro.deliveryWithInstall = moduleInfo.deliveryWithInstall;
        hapInfo.srcEntrance = moduleInfo.srcEntrance;
        hapInfo.description = moduleInfo.description;
        hapInfo.setDescriptions(moduleInfo.getDescriptions());
        hapInfo.process = moduleInfo.process;
        hapInfo.mainElement = moduleInfo.mainElement;
        hapInfo.deviceType = moduleInfo.deviceTypes;
        hapInfo.uiSyntax = moduleInfo.uiSyntax;
        hapInfo.pages = moduleInfo.pages;
        hapInfo.shortcuts = this.convertToShortcut(moduleInfo.moduleShortcuts);
        hapInfo.metaData = this.convertToMetadata(moduleInfo.moduleMetadataInfos);
        hapInfo.abilities = this.convertToAbilityInfo(moduleInfo.abilities);
        hapInfo.extensionAbilityInfos = moduleInfo.extensionAbilityInfos;
        hapInfo.reqPermissions = moduleInfo.requestPermissions;
        hapInfo.distroFilter = moduleInfo.distroFilter;
        hapInfo.formInfos = moduleInfo.abilityFormInfos;
        hapInfo.commonEvents = moduleInfo.commonEvents;
        hapInfo.definePermissions = moduleInfo.definePermissions;
        hapInfo.moduleAtomicService = moduleInfo.moduleAtomicService;
        hapInfo.appModel = moduleInfo.appModel;
        hapInfo.dependencies = moduleInfo.dependenies;
        return hapInfo;
    }

    List<Shortcut> convertToShortcut(List<ModuleShortcut> list) {
        ArrayList<Shortcut> arrayList = new ArrayList<Shortcut>();
        for (ModuleShortcut moduleShortcut : list) {
            Shortcut shortcut = new Shortcut();
            shortcut.shortcutId = moduleShortcut.getShortcutId();
            shortcut.label = moduleShortcut.getLabel();
            shortcut.icon = moduleShortcut.getIcon();
            shortcut.intents = new ArrayList<IntentInfo>();
            for (int i = 0; i < moduleShortcut.getWants().size(); ++i) {
                Want want = moduleShortcut.getWants().get(i);
                IntentInfo intentInfo = new IntentInfo();
                intentInfo.targetBundle = want.bundleName;
                intentInfo.targetClass = want.abilityName;
                shortcut.intents.add(intentInfo);
            }
            arrayList.add(shortcut);
        }
        return arrayList;
    }

    MetaData convertToMetadata(List<ModuleMetadataInfo> list) {
        MetaData metaData = new MetaData();
        ArrayList<CustomizeData> arrayList = new ArrayList<CustomizeData>();
        for (ModuleMetadataInfo moduleMetadataInfo : list) {
            CustomizeData customizeData = new CustomizeData();
            customizeData.name = moduleMetadataInfo.name;
            customizeData.value = moduleMetadataInfo.value;
            customizeData.extra = moduleMetadataInfo.resource;
            arrayList.add(customizeData);
        }
        metaData.customizeDatas = arrayList;
        return metaData;
    }

    List<AbilityInfo> convertToAbilityInfo(List<ModuleAbilityInfo> list) {
        ArrayList<AbilityInfo> arrayList = new ArrayList<AbilityInfo>();
        for (ModuleAbilityInfo moduleAbilityInfo : list) {
            AbilityInfo abilityInfo = new AbilityInfo();
            abilityInfo.type = "page";
            abilityInfo.name = moduleAbilityInfo.name;
            abilityInfo.srcEntrance = moduleAbilityInfo.srcEntrance;
            abilityInfo.description = moduleAbilityInfo.description;
            abilityInfo.setDescriptions(moduleAbilityInfo.getDescriptions());
            abilityInfo.launchType = moduleAbilityInfo.launchType;
            abilityInfo.icon = moduleAbilityInfo.icon;
            abilityInfo.iconPath = moduleAbilityInfo.icon;
            abilityInfo.label = moduleAbilityInfo.label;
            abilityInfo.setLabels(moduleAbilityInfo.getLabels());
            abilityInfo.labelRes = moduleAbilityInfo.label;
            abilityInfo.permissions = moduleAbilityInfo.permissions;
            abilityInfo.visible = moduleAbilityInfo.visible;
            abilityInfo.continuable = moduleAbilityInfo.continuable;
            abilityInfo.metaData = this.convertToMetadata(moduleAbilityInfo.metadata);
            abilityInfo.skills = moduleAbilityInfo.skills;
            abilityInfo.backgroundModes = moduleAbilityInfo.backgroundModes;
            arrayList.add(abilityInfo);
        }
        return arrayList;
    }
}

