/*
 * Decompiled with CFR 0.152.
 */
package ohos;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import ohos.BundleException;
import ohos.Log;
import ohos.ResourceIndexResult;

public class ResourcesParser {
    public static final int RESOURCE_DEFAULT_ID = -1;
    private static final int VERSION_BYTE_LENGTH = 128;
    private static final int TAG_BYTE_LENGTH = 4;
    private static final String LEFT_BRACKET = "<";
    private static final String RIGHT_BRACKET = ">";
    private static final String VERTICAL = "vertical";
    private static final String HORIZONTAL = "horizontal";
    private static final String DARK = "dark";
    private static final String LIGHT = "light";
    private static final String MCC = "mcc";
    private static final String MNC = "mnc";
    private static final String CONFIG_CONJUNCTION = "-";
    private static final String MCC_CONJUNCTION = "_";
    private static final String BASE = "base";
    private static final int CHAR_LENGTH = 1;
    private static final String EMPTY_STRING = "";
    private static final Log LOG = new Log(ResourcesParser.class.toString());

    static String getResourceById(int n, byte[] byArray) throws BundleException {
        String string = EMPTY_STRING;
        if (byArray == null || byArray.length <= 0 || n == -1) {
            LOG.error("ResourcesParser::getIconPath data byte or ResourceId is null");
            return string;
        }
        List<String> list = ResourcesParser.getResource(n, byArray);
        if (list != null && list.size() > 0 && list.get(0) != null && !EMPTY_STRING.equals(list.get(0))) {
            string = list.get(0).substring(0, list.get(0).length() - 1);
        }
        return string;
    }

    static String getBaseResourceById(int n, byte[] byArray) throws BundleException {
        String string = EMPTY_STRING;
        if (byArray == null || byArray.length <= 0 || n == -1) {
            LOG.error("ResourcesParser::getBaseResourceById data byte or ResourceId is null");
            return string;
        }
        string = ResourcesParser.getBaseResource(n, byArray);
        if (string != null && !EMPTY_STRING.equals(string)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    static String getBaseResource(int n, byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byte[] byArray2 = new byte[128];
        byteBuffer.get(byArray2);
        byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        Optional<ConfigIndex> optional = ResourcesParser.loadBaseConfig(byteBuffer, n2);
        if (!optional.isPresent()) {
            LOG.error("ResourcesParser::getBaseResource configIndex is null");
            return EMPTY_STRING;
        }
        return ResourcesParser.readBaseItem(n, optional.get(), byteBuffer);
    }

    static Optional<ConfigIndex> loadBaseConfig(ByteBuffer byteBuffer, int n) {
        for (int i = 0; i < n; ++i) {
            ConfigIndex configIndex = new ConfigIndex();
            byte[] byArray = new byte[4];
            byteBuffer.get(byArray);
            configIndex.tag = new String(byArray, StandardCharsets.UTF_8);
            configIndex.offset = byteBuffer.getInt();
            configIndex.keyCount = byteBuffer.getInt();
            configIndex.params = new KeyParam[configIndex.keyCount];
            for (int j = 0; j < configIndex.keyCount; ++j) {
                configIndex.params[j] = new KeyParam();
                configIndex.params[j].keyType = byteBuffer.getInt();
                configIndex.params[j].value = byteBuffer.getInt();
            }
            if (configIndex.keyCount != 0) continue;
            return Optional.of(configIndex);
        }
        return Optional.empty();
    }

    static String readBaseItem(int n, ConfigIndex configIndex, ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        byteBuffer.position(configIndex.offset);
        byte[] byArray = new byte[4];
        byteBuffer.get(byArray);
        int n2 = byteBuffer.getInt();
        for (int i = 0; i < n2; ++i) {
            int n3 = byteBuffer.getInt();
            int n4 = byteBuffer.getInt();
            if (n3 != n) continue;
            byteBuffer.rewind();
            byteBuffer.position(n4);
            DataItem dataItem = ResourcesParser.readItem(byteBuffer);
            return dataItem.value;
        }
        return EMPTY_STRING;
    }

    static List<String> getResource(int n, byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byte[] byArray2 = new byte[128];
        byteBuffer.get(byArray2);
        byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        List<ConfigIndex> list = ResourcesParser.loadConfig(byteBuffer, n2);
        return ResourcesParser.readAllItem(n, list, byteBuffer);
    }

    static List<ConfigIndex> loadConfig(ByteBuffer byteBuffer, int n) {
        ArrayList<ConfigIndex> arrayList = new ArrayList<ConfigIndex>(n);
        for (int i = 0; i < n; ++i) {
            ConfigIndex configIndex = new ConfigIndex();
            byte[] byArray = new byte[4];
            byteBuffer.get(byArray);
            configIndex.tag = new String(byArray, StandardCharsets.UTF_8);
            configIndex.offset = byteBuffer.getInt();
            configIndex.keyCount = byteBuffer.getInt();
            configIndex.params = new KeyParam[configIndex.keyCount];
            for (int j = 0; j < configIndex.keyCount; ++j) {
                configIndex.params[j] = new KeyParam();
                configIndex.params[j].keyType = byteBuffer.getInt();
                configIndex.params[j].value = byteBuffer.getInt();
            }
            arrayList.add(configIndex);
        }
        return arrayList;
    }

    static List<String> readAllItem(int n, List<ConfigIndex> list, ByteBuffer byteBuffer) {
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (ConfigIndex configIndex : list) {
            byteBuffer.rewind();
            byteBuffer.position(configIndex.offset);
            byte[] byArray = new byte[4];
            byteBuffer.get(byArray);
            int n2 = byteBuffer.getInt();
            for (int i = 0; i < n2; ++i) {
                int n3 = byteBuffer.getInt();
                int n4 = byteBuffer.getInt();
                if (n3 != n) continue;
                byteBuffer.rewind();
                byteBuffer.position(n4);
                DataItem dataItem = ResourcesParser.readItem(byteBuffer);
                arrayList.add(dataItem.value);
                continue block0;
            }
        }
        return arrayList;
    }

    static DataItem readItem(ByteBuffer byteBuffer) {
        DataItem dataItem = new DataItem();
        dataItem.size = byteBuffer.getInt();
        dataItem.type = byteBuffer.getInt();
        dataItem.id = byteBuffer.getInt();
        int n = byteBuffer.getShort() & 0xFFFF;
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        dataItem.value = new String(byArray, StandardCharsets.UTF_8);
        n = byteBuffer.getShort() & 0xFFFF;
        byte[] byArray2 = new byte[n];
        byteBuffer.get(byArray2);
        dataItem.name = new String(byArray2, StandardCharsets.UTF_8);
        return dataItem;
    }

    static List<ResourceIndexResult> getAllDataItem(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byte[] byArray2 = new byte[128];
        byteBuffer.get(byArray2);
        byteBuffer.getInt();
        int n = byteBuffer.getInt();
        List<ConfigIndex> list = ResourcesParser.loadConfig(byteBuffer, n);
        return ResourcesParser.readDataAllItem(list, byteBuffer);
    }

    static HashMap<String, String> getResourceMapById(int n, byte[] byArray) {
        List<ResourceIndexResult> list = ResourcesParser.getAllDataItem(byArray);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (ResourceIndexResult resourceIndexResult : list) {
            if (resourceIndexResult.id != n) continue;
            hashMap.put(resourceIndexResult.configClass, resourceIndexResult.value);
        }
        return hashMap;
    }

    static String getResourceStringById(int n, byte[] byArray) {
        List<ResourceIndexResult> list = ResourcesParser.getAllDataItem(byArray);
        for (ResourceIndexResult resourceIndexResult : list) {
            if (resourceIndexResult.id != n) continue;
            return resourceIndexResult.value;
        }
        return EMPTY_STRING;
    }

    static List<ResourceIndexResult> readDataAllItem(List<ConfigIndex> list, ByteBuffer byteBuffer) {
        ArrayList<ResourceIndexResult> arrayList = new ArrayList<ResourceIndexResult>();
        for (ConfigIndex configIndex : list) {
            String string = ResourcesParser.convertConfigIndexToString(configIndex);
            byteBuffer.rewind();
            byteBuffer.position(configIndex.offset);
            byte[] byArray = new byte[4];
            byteBuffer.get(byArray);
            int n = byteBuffer.getInt();
            int n2 = byteBuffer.position();
            for (int i = 0; i < n; ++i) {
                byteBuffer.position(n2);
                byteBuffer.getInt();
                int n3 = byteBuffer.getInt();
                n2 = byteBuffer.position();
                byteBuffer.rewind();
                byteBuffer.position(n3);
                DataItem dataItem = ResourcesParser.readItem(byteBuffer);
                arrayList.add(ResourcesParser.parseDataItems(dataItem, string));
            }
        }
        return arrayList;
    }

    static ResourceIndexResult parseDataItems(DataItem dataItem, String string) {
        ResourceIndexResult resourceIndexResult = new ResourceIndexResult();
        resourceIndexResult.configClass = string;
        if (dataItem != null) {
            resourceIndexResult.type = ResType.getType(dataItem.type);
            resourceIndexResult.id = dataItem.id;
            resourceIndexResult.name = dataItem.name.substring(0, dataItem.name.length() - 1);
            if (dataItem.type == ResType.StrArray.getIndex() || dataItem.type == ResType.IntArray.getIndex() || dataItem.type == ResType.Theme.getIndex() || dataItem.type == ResType.Plurals.getIndex() || dataItem.type == ResType.Pattern.getIndex()) {
                byte[] byArray = dataItem.value.substring(0, dataItem.value.length() - 1).getBytes(StandardCharsets.UTF_8);
                resourceIndexResult.value = ResourcesParser.convertBytesToString(byArray);
            } else {
                resourceIndexResult.value = dataItem.value.substring(0, dataItem.value.length() - 1);
            }
        }
        return resourceIndexResult;
    }

    static String convertBytesToString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        while (byteBuffer.hasRemaining()) {
            stringBuilder.append(LEFT_BRACKET);
            short s = byteBuffer.getShort();
            if (s <= 0) {
                LOG.info("len less than 0, dismiss");
                stringBuilder.append(RIGHT_BRACKET);
                break;
            }
            byte[] byArray2 = new byte[s + 1];
            byteBuffer.get(byArray2);
            String string = new String(byArray2, StandardCharsets.UTF_8);
            stringBuilder.append(string, 0, string.length() - 1);
            stringBuilder.append(RIGHT_BRACKET);
        }
        return stringBuilder.toString();
    }

    static String convertConfigIndexToString(ConfigIndex configIndex) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = -1;
        for (int i = 0; i < configIndex.keyCount; ++i) {
            KeyParam keyParam = configIndex.params[i];
            if (keyParam.keyType == ConfigType.Language.ordinal() || keyParam.keyType == ConfigType.Region.ordinal() || keyParam.keyType == ConfigType.Script.ordinal()) {
                if (EMPTY_STRING.equals(stringBuilder.toString())) {
                    stringBuilder.append(ResourcesParser.parseAscii(keyParam.value));
                } else if (n == ConfigType.Language.ordinal() || n == ConfigType.Region.ordinal() || n == ConfigType.Script.ordinal()) {
                    stringBuilder.append(MCC_CONJUNCTION).append(ResourcesParser.parseAscii(keyParam.value));
                } else {
                    stringBuilder.append(CONFIG_CONJUNCTION).append(ResourcesParser.parseAscii(keyParam.value));
                }
                n = keyParam.keyType;
                continue;
            }
            if (keyParam.keyType == ConfigType.Resolution.ordinal()) {
                if (EMPTY_STRING.equals(stringBuilder.toString())) {
                    stringBuilder.append(Resolution.getType(keyParam.value));
                    continue;
                }
                stringBuilder.append(CONFIG_CONJUNCTION).append(Resolution.getType(keyParam.value));
                continue;
            }
            if (keyParam.keyType == ConfigType.Direction.ordinal()) {
                if (EMPTY_STRING.equals(stringBuilder.toString())) {
                    stringBuilder.append(keyParam.value == 0 ? VERTICAL : HORIZONTAL);
                    continue;
                }
                stringBuilder.append(CONFIG_CONJUNCTION).append(keyParam.value == 0 ? VERTICAL : HORIZONTAL);
                continue;
            }
            if (keyParam.keyType == ConfigType.DeviceType.ordinal()) {
                if (EMPTY_STRING.equals(stringBuilder.toString())) {
                    stringBuilder.append(DeviceType.getType(keyParam.value));
                    continue;
                }
                stringBuilder.append(CONFIG_CONJUNCTION).append(DeviceType.getType(keyParam.value));
                continue;
            }
            if (keyParam.keyType == ConfigType.LightMode.ordinal()) {
                if (EMPTY_STRING.equals(stringBuilder.toString())) {
                    stringBuilder.append(keyParam.value == 0 ? DARK : LIGHT);
                    continue;
                }
                stringBuilder.append(CONFIG_CONJUNCTION).append(keyParam.value == 0 ? DARK : LIGHT);
                continue;
            }
            if (keyParam.keyType == ConfigType.MCC.ordinal()) {
                if (EMPTY_STRING.equals(stringBuilder.toString())) {
                    stringBuilder.append(MCC).append(String.valueOf(keyParam.value));
                    continue;
                }
                stringBuilder.append(MCC_CONJUNCTION).append(MCC).append(String.valueOf(keyParam.value));
                continue;
            }
            if (keyParam.keyType != ConfigType.MNC.ordinal()) continue;
            if (EMPTY_STRING.equals(stringBuilder.toString())) {
                stringBuilder.append(MNC).append(ResourcesParser.fillUpZero(String.valueOf(keyParam.value), 3));
                continue;
            }
            stringBuilder.append(MCC_CONJUNCTION).append(MNC).append(ResourcesParser.fillUpZero(String.valueOf(keyParam.value), 3));
        }
        if (EMPTY_STRING.equals(stringBuilder.toString())) {
            stringBuilder = new StringBuilder(BASE);
        }
        return stringBuilder.toString();
    }

    private static String parseAscii(Integer n) {
        StringBuilder stringBuilder = new StringBuilder();
        while (n > 0) {
            stringBuilder.insert(0, (char)(n & 0xFF));
            n = n >> 8;
        }
        return stringBuilder.toString();
    }

    private static String fillUpZero(String string, int n) {
        if (string.length() >= n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (stringBuilder.length() < n - string.length()) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    static class ConfigIndex {
        String tag;
        int offset;
        int keyCount;
        KeyParam[] params;

        ConfigIndex() {
        }
    }

    static class KeyParam {
        int keyType;
        int value;

        KeyParam() {
        }
    }

    static class DataItem {
        int size;
        int type;
        int id;
        String value;
        String name;

        DataItem() {
        }
    }

    private static enum ResType {
        Values(0, "Values"),
        Animator(1, "Animator"),
        Drawable(2, "Drawable"),
        Layout(3, "Layout"),
        Menu(4, "Menu"),
        Mipmap(5, "Mipmap"),
        Raw(6, "Raw"),
        Xml(7, "Xml"),
        Integer(8, "Integer"),
        String(9, "String"),
        StrArray(10, "StrArray"),
        IntArray(11, "IntArray"),
        Boolean(12, "Boolean"),
        Dimen(13, "Dimen"),
        Color(14, "Color"),
        Id(15, "Id"),
        Theme(16, "Theme"),
        Plurals(17, "Plurals"),
        Float(18, "Float"),
        Media(19, "Media"),
        Prof(20, "Prof"),
        Svg(21, "Svg"),
        Pattern(22, "Pattern");

        private final int index;
        private final String type;

        private ResType(int n2, String string2) {
            this.index = n2;
            this.type = string2;
        }

        public static String getType(int n) {
            for (ResType resType : ResType.values()) {
                if (resType.getIndex() != n) continue;
                return resType.type;
            }
            return ResourcesParser.EMPTY_STRING;
        }

        public int getIndex() {
            return this.index;
        }

        public String getType() {
            return this.type;
        }
    }

    private static enum ConfigType {
        Language,
        Region,
        Resolution,
        Direction,
        DeviceType,
        Script,
        LightMode,
        MCC,
        MNC;

    }

    private static enum Resolution {
        Nodpi(-2, "nodpi"),
        Anydpi(-1, "anydpi"),
        Sdpi(120, "sdpi"),
        Mdpi(160, "mdpi"),
        Tvdpi(213, "tvdpi"),
        Ldpi(240, "ldpi"),
        Xldpi(320, "xldpi"),
        Xxldpi(480, "xxldpi"),
        Xxxldpi(640, "xxxldpi");

        private final int index;
        private final String type;

        private Resolution(int n2, String string2) {
            this.index = n2;
            this.type = string2;
        }

        public static String getType(int n) {
            for (Resolution resolution : Resolution.values()) {
                if (resolution.getIndex() != n) continue;
                return resolution.type;
            }
            return ResourcesParser.EMPTY_STRING;
        }

        public int getIndex() {
            return this.index;
        }

        public String getType() {
            return this.type;
        }
    }

    private static enum DeviceType {
        Phone(0, "phone"),
        Tablet(1, "tablet"),
        Car(2, "car"),
        Pc(3, "pc"),
        Tv(4, "tv"),
        Speaker(5, "speaker"),
        Wearable(6, "wearable"),
        Glasses(7, "glasses"),
        Headset(8, "headset");

        private final int index;
        private final String type;

        private DeviceType(int n2, String string2) {
            this.index = n2;
            this.type = string2;
        }

        public static String getType(int n) {
            for (DeviceType deviceType : DeviceType.values()) {
                if (deviceType.getIndex() != n) continue;
                return deviceType.type;
            }
            return ResourcesParser.EMPTY_STRING;
        }

        public int getIndex() {
            return this.index;
        }

        public String getType() {
            return this.type;
        }
    }
}

