/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.api;

import com.ohos.hapsigntool.adapter.LocalizationAdapter;
import com.ohos.hapsigntool.api.ServiceApi;
import com.ohos.hapsigntool.cert.CertBuilder;
import com.ohos.hapsigntool.cert.CertLevel;
import com.ohos.hapsigntool.error.CustomException;
import com.ohos.hapsigntool.error.ERROR;
import com.ohos.hapsigntool.utils.CertUtils;
import java.io.IOException;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;

public final class CertTools {
    private static final int TEN_YEAR_DAY = 3650;
    private static final int THREE_YEAR_DAY = 1095;
    private static final byte[] NO_CSR = new byte[0];
    private static final Logger LOGGER = LogManager.getLogger(ServiceApi.class);

    private CertTools() {
    }

    public static X509Certificate generateRootCaCert(KeyPair keyPair, byte[] csr, LocalizationAdapter adapter) {
        try {
            return new CertBuilder(keyPair, adapter.getIssuer(), csr, adapter.getOptions().getInt("validity", 3650)).withAuthorityKeyIdentifier(CertLevel.ROOT_CA).withBasicConstraints(CertLevel.ROOT_CA, true, true, adapter.getBasicConstraintsPathLen()).withKeyUsages(new KeyUsage(6), true).withExtKeyUsages(null, false).build(adapter.getSignAlg());
        }
        catch (IOException exception) {
            LOGGER.debug(exception.getMessage(), (Throwable)exception);
            CustomException.throwException(ERROR.IO_CERT_ERROR, exception.getMessage());
            return null;
        }
    }

    public static X509Certificate generateSubCert(KeyPair keyPair, byte[] csr, LocalizationAdapter adapter) {
        try {
            return new CertBuilder(keyPair, adapter.getIssuer(), csr, adapter.getOptions().getInt("validity", 3650)).withAuthorityKeyIdentifier(CertLevel.SUB_CA).withBasicConstraints(CertLevel.SUB_CA, true, true, adapter.getBasicConstraintsPathLen()).withKeyUsages(new KeyUsage(6), true).build(adapter.getSignAlg());
        }
        catch (IOException exception) {
            LOGGER.debug(exception.getMessage(), (Throwable)exception);
            CustomException.throwException(ERROR.IO_CERT_ERROR, exception.getMessage());
            return null;
        }
    }

    public static X509Certificate generateCert(KeyPair keyPair, byte[] csr, LocalizationAdapter adapter) {
        try {
            return new CertBuilder(keyPair, adapter.getIssuer(), csr, adapter.getOptions().getInt("validity", 1095)).withAuthorityKeyIdentifier(CertLevel.ROOT_CA).withBasicConstraints(CertLevel.ROOT_CA, adapter.isBasicConstraintsCritical(), adapter.isBasicConstraintsCa(), adapter.getBasicConstraintsPathLen()).withKeyUsages(adapter.getKeyUsage(), adapter.isKeyUsageCritical()).withExtKeyUsages(adapter.getExtKeyUsage(), adapter.isExtKeyUsageCritical()).build(adapter.getSignAlg());
        }
        catch (IOException exception) {
            LOGGER.debug(exception.getMessage(), (Throwable)exception);
            CustomException.throwException(ERROR.IO_CERT_ERROR, exception.getMessage());
            return null;
        }
    }

    public static X509Certificate generateEndCert(KeyPair keyPair, byte[] csr, LocalizationAdapter adapter, byte[] signingCapabiltyBytes) {
        try {
            return new CertBuilder(keyPair, adapter.getIssuer(), csr, adapter.getOptions().getInt("validity", 1095)).withBasicConstraints(CertLevel.END_ENTITY, false, false, null).withKeyUsages(new KeyUsage(128), true).withExtKeyUsages(new KeyPurposeId[]{KeyPurposeId.id_kp_codeSigning}, false).withSigningCapabilty(signingCapabiltyBytes).build(adapter.getSignAlg());
        }
        catch (IOException exception) {
            LOGGER.debug(exception.getMessage(), (Throwable)exception);
            CustomException.throwException(ERROR.IO_CERT_ERROR, exception.getMessage());
            return null;
        }
    }

    public static byte[] generateCsr(KeyPair keyPair, String signAlgorithm, X500Name subject) {
        JcaPKCS10CertificationRequestBuilder csrBuilder = new JcaPKCS10CertificationRequestBuilder(subject, keyPair.getPublic());
        PKCS10CertificationRequest csr = csrBuilder.build(CertUtils.createFixedContentSigner(keyPair.getPrivate(), signAlgorithm));
        try {
            return csr.getEncoded();
        }
        catch (IOException exception) {
            LOGGER.debug(exception.getMessage(), (Throwable)exception);
            CustomException.throwException(ERROR.IO_CSR_ERROR, "Not support " + subject);
            return NO_CSR;
        }
    }
}

