/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.datastructure;

import com.ohos.hapsigntool.codesigning.exception.VerifyCodeSignException;
import com.ohos.hapsigntool.codesigning.fsverity.FsVerityGenerator;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Locale;

public class FsVerityInfoSegment {
    public static final int FS_VERITY_INFO_SEGMENT_SIZE = 64;
    private static final int MAGIC = 506999211;
    private static final int RESERVED_BYTE_ARRAY_LENGTH = 57;
    private int magic = 506999211;
    private byte hashAlgorithm;
    private byte version;
    private byte log2BlockSize;
    private byte[] reserved = new byte[57];

    public FsVerityInfoSegment() {
    }

    public FsVerityInfoSegment(byte version, byte hashAlgorithm, byte log2BlockSize) {
        this(506999211, version, hashAlgorithm, log2BlockSize, new byte[57]);
    }

    public FsVerityInfoSegment(int magic, byte version, byte hashAlgorithm, byte log2BlockSize, byte[] reserved) {
        this.magic = magic;
        this.version = version;
        this.hashAlgorithm = hashAlgorithm;
        this.log2BlockSize = log2BlockSize;
        this.reserved = reserved;
    }

    public int size() {
        return 64;
    }

    public byte[] toByteArray() {
        ByteBuffer bf = ByteBuffer.allocate(64).order(ByteOrder.LITTLE_ENDIAN);
        bf.putInt(this.magic);
        bf.put(this.version);
        bf.put(this.hashAlgorithm);
        bf.put(this.log2BlockSize);
        bf.put(this.reserved);
        return bf.array();
    }

    public static FsVerityInfoSegment fromByteArray(byte[] bytes) throws VerifyCodeSignException {
        if (bytes.length != 64) {
            throw new VerifyCodeSignException("Invalid size of FsVerityInfoSegment");
        }
        ByteBuffer bf = ByteBuffer.allocate(bytes.length).order(ByteOrder.LITTLE_ENDIAN);
        bf.put(bytes);
        bf.rewind();
        int inMagic = bf.getInt();
        if (inMagic != 506999211) {
            throw new VerifyCodeSignException("Invalid magic number of FsVerityInfoSegment");
        }
        byte inVersion = bf.get();
        if (inVersion != 1) {
            throw new VerifyCodeSignException("Invalid version of FsVerityInfoSegment");
        }
        byte inHashAlgorithm = bf.get();
        if (inHashAlgorithm != FsVerityGenerator.getFsVerityHashAlgorithm()) {
            throw new VerifyCodeSignException("Invalid hashAlgorithm of FsVerityInfoSegment");
        }
        byte inLog2BlockSize = bf.get();
        if (inLog2BlockSize != FsVerityGenerator.getLog2BlockSize()) {
            throw new VerifyCodeSignException("Invalid log2BlockSize of FsVerityInfoSegment");
        }
        byte[] inReservedBytes = new byte[57];
        bf.get(inReservedBytes);
        return new FsVerityInfoSegment(inMagic, inVersion, inHashAlgorithm, inLog2BlockSize, inReservedBytes);
    }

    public String toString() {
        return String.format(Locale.ROOT, "FsVerityInfoSeg: magic[%d], version[%d], hashAlg[%d], log2BlockSize[%d]", this.magic, this.version, this.hashAlgorithm, this.log2BlockSize);
    }
}

