/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.datastructure;

import com.ohos.hapsigntool.codesigning.datastructure.Extension;
import com.ohos.hapsigntool.codesigning.exception.VerifyCodeSignException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Locale;

public class MerkleTreeExtension
extends Extension {
    public static final int MERKLE_TREE_INLINED = 1;
    public static final int MERKLE_TREE_EXTENSION_DATA_SIZE = 80;
    private static final int ROOT_HASH_SIZE = 64;
    private final long merkleTreeSize;
    private long merkleTreeOffset;
    private byte[] rootHash;

    public MerkleTreeExtension(long merkleTreeSize, long merkleTreeOffset, byte[] rootHash) {
        super(1, 80);
        this.merkleTreeSize = merkleTreeSize;
        this.merkleTreeOffset = merkleTreeOffset;
        this.rootHash = rootHash == null ? new byte[64] : Arrays.copyOf(rootHash, 64);
    }

    @Override
    public int size() {
        return 88;
    }

    public long getMerkleTreeSize() {
        return this.merkleTreeSize;
    }

    public long getMerkleTreeOffset() {
        return this.merkleTreeOffset;
    }

    public void setMerkleTreeOffset(long offset) {
        this.merkleTreeOffset = offset;
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer bf = ByteBuffer.allocate(88).order(ByteOrder.LITTLE_ENDIAN);
        bf.put(super.toByteArray());
        bf.putLong(this.merkleTreeSize);
        bf.putLong(this.merkleTreeOffset);
        bf.put(this.rootHash);
        return bf.array();
    }

    public static MerkleTreeExtension fromByteArray(byte[] bytes) throws VerifyCodeSignException {
        ByteBuffer bf = ByteBuffer.allocate(bytes.length).order(ByteOrder.LITTLE_ENDIAN);
        bf.put(bytes);
        bf.rewind();
        long inMerkleTreeSize = bf.getLong();
        if (inMerkleTreeSize % 4096L != 0L) {
            throw new VerifyCodeSignException("merkleTreeSize is not a multiple of 4096");
        }
        long inMerkleTreeOffset = bf.getLong();
        if (inMerkleTreeOffset % 4096L != 0L) {
            throw new VerifyCodeSignException("merkleTreeOffset is not a aligned to 4096");
        }
        byte[] inRootHash = new byte[64];
        bf.get(inRootHash);
        return new MerkleTreeExtension(inMerkleTreeSize, inMerkleTreeOffset, inRootHash);
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "MerkleTreeExtension: merkleTreeSize[%d], merkleTreeOffset[%d], rootHash[%s]", this.merkleTreeSize, this.merkleTreeOffset, Arrays.toString(this.rootHash));
    }
}

