/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.fsverity;

import com.ohos.hapsigntool.codesigning.exception.FsVerityDigestException;
import com.ohos.hapsigntool.codesigning.exception.VerifyCodeSignException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class FsVerityDescriptor {
    public static final byte VERSION = 1;
    public static final int PAGE_SIZE_4K = 4096;
    public static final int FLAG_STORE_MERKLE_TREE_OFFSET = 1;
    public static final int FS_VERITY_DESCRIPTOR_TYPE = 1;
    public static final byte CODE_SIGN_VERSION = 1;
    public static final int DESCRIPTOR_SIZE = 256;
    public static final int ROOT_HASH_FILED_SIZE = 64;
    public static final int SALT_SIZE = 32;
    public static final int RESERVED_SIZE_AFTER_FLAGS = 4;
    public static final int RESERVED_SIZE_AFTER_TREE_OFFSET = 127;
    private byte version;
    private long fileSize;
    private byte hashAlgorithm;
    private byte log2BlockSize;
    private byte saltSize;
    private int signSize;
    private byte[] salt;
    private byte[] rawRootHash;
    private int flags;
    private long merkleTreeOffset;
    private byte csVersion;

    private FsVerityDescriptor(Builder builder) {
        this.version = builder.version;
        this.fileSize = builder.fileSize;
        this.hashAlgorithm = builder.hashAlgorithm;
        this.log2BlockSize = builder.log2BlockSize;
        this.saltSize = builder.saltSize;
        this.signSize = builder.signSize;
        this.salt = builder.salt;
        this.rawRootHash = builder.rawRootHash;
        this.flags = builder.flags;
        this.merkleTreeOffset = builder.merkleTreeOffset;
        this.csVersion = builder.csVersion;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getMerkleTreeOffset() {
        return this.merkleTreeOffset;
    }

    public int getSignSize() {
        return this.signSize;
    }

    public static FsVerityDescriptor fromByteArray(byte[] bytes) throws VerifyCodeSignException {
        ByteBuffer bf = ByteBuffer.allocate(bytes.length).order(ByteOrder.LITTLE_ENDIAN);
        bf.put(bytes);
        bf.rewind();
        Builder builder = new Builder();
        byte inFsVersion = bf.get();
        if (1 != inFsVersion) {
            throw new VerifyCodeSignException("Invalid fs-verify descriptor version of ElfSignBlock");
        }
        byte inFsHashAlgorithm = bf.get();
        byte inLog2BlockSize = bf.get();
        builder.setVersion(inFsVersion).setHashAlgorithm(inFsHashAlgorithm).setLog2BlockSize(inLog2BlockSize);
        byte inSaltSize = bf.get();
        int inSignSize = bf.getInt();
        long inDataSize = bf.getLong();
        byte[] inRootHash = new byte[64];
        bf.get(inRootHash);
        builder.setSaltSize(inSaltSize).setSignSize(inSignSize).setFileSize(inDataSize).setRawRootHash(inRootHash);
        byte[] inSalt = new byte[32];
        bf.get(inSalt);
        int inFlags = bf.getInt();
        bf.getInt();
        long inTreeOffset = bf.getLong();
        if (inTreeOffset % 4096L != 0L) {
            throw new VerifyCodeSignException("Invalid merkle tree offset of ElfSignBlock");
        }
        bf.get(new byte[127]);
        byte inCsVersion = bf.get();
        builder.setSalt(inSalt).setFlags(inFlags).setMerkleTreeOffset(inTreeOffset).setCsVersion(inCsVersion);
        return builder.build();
    }

    public byte[] toByteArray() throws FsVerityDigestException {
        ByteBuffer buffer = ByteBuffer.allocate(256).order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)1);
        buffer.put(this.hashAlgorithm);
        buffer.put(this.log2BlockSize);
        if (this.saltSize > 32) {
            throw new FsVerityDigestException("Salt is too long");
        }
        buffer.put(this.saltSize);
        buffer.putInt(this.signSize);
        buffer.putLong(this.fileSize);
        this.writeBytesWithSize(buffer, this.rawRootHash, 64);
        this.writeBytesWithSize(buffer, this.salt, 32);
        buffer.putInt(this.flags);
        this.writeBytesWithSize(buffer, null, 4);
        buffer.putLong(this.merkleTreeOffset);
        this.writeBytesWithSize(buffer, null, 127);
        buffer.put(this.csVersion);
        return buffer.array();
    }

    public byte[] getByteForGenerateDigest() throws FsVerityDigestException {
        ByteBuffer buffer = ByteBuffer.allocate(256).order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)1);
        buffer.put(this.hashAlgorithm);
        buffer.put(this.log2BlockSize);
        if (this.saltSize > 32) {
            throw new FsVerityDigestException("Salt is too long");
        }
        buffer.put(this.saltSize);
        buffer.putInt(0);
        buffer.putLong(this.fileSize);
        this.writeBytesWithSize(buffer, this.rawRootHash, 64);
        this.writeBytesWithSize(buffer, this.salt, 32);
        buffer.putInt(this.flags);
        this.writeBytesWithSize(buffer, null, 4);
        buffer.putLong(this.merkleTreeOffset);
        return buffer.array();
    }

    private void writeBytesWithSize(ByteBuffer buffer, byte[] src, int size) {
        int pos = buffer.position();
        if (src != null) {
            if (src.length > size) {
                buffer.put(src, 0, size);
            } else {
                buffer.put(src);
            }
        }
        buffer.position(pos + size);
    }

    public static class Builder {
        private byte version = 1;
        private long fileSize;
        private byte hashAlgorithm;
        private byte log2BlockSize;
        private byte saltSize;
        private int signSize;
        private byte[] salt;
        private byte[] rawRootHash;
        private int flags;
        private long merkleTreeOffset;
        private byte csVersion;

        public Builder setVersion(byte version) {
            this.version = version;
            return this;
        }

        public Builder setFileSize(long fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        public Builder setHashAlgorithm(byte hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
            return this;
        }

        public Builder setLog2BlockSize(byte log2BlockSize) {
            this.log2BlockSize = log2BlockSize;
            return this;
        }

        public Builder setSignSize(int signSize) {
            this.signSize = signSize;
            return this;
        }

        public Builder setSaltSize(byte saltSize) {
            this.saltSize = saltSize;
            return this;
        }

        public Builder setSalt(byte[] salt) {
            this.salt = salt;
            return this;
        }

        public Builder setRawRootHash(byte[] rawRootHash) {
            this.rawRootHash = rawRootHash;
            return this;
        }

        public Builder setFlags(int flags) {
            this.flags = flags;
            return this;
        }

        public Builder setMerkleTreeOffset(long merkleTreeOffset) {
            this.merkleTreeOffset = merkleTreeOffset;
            return this;
        }

        public Builder setCsVersion(byte csVersion) {
            this.csVersion = csVersion;
            return this;
        }

        public FsVerityDescriptor build() {
            return new FsVerityDescriptor(this);
        }
    }
}

