/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.fsverity;

import com.ohos.hapsigntool.codesigning.exception.FsVerityDigestException;
import com.ohos.hapsigntool.codesigning.fsverity.FsVerityDescriptor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class FsVerityDescriptorWithSign {
    private int type = 1;
    private int length;
    private FsVerityDescriptor fsVerityDescriptor;
    private byte[] signature = new byte[0];

    public FsVerityDescriptorWithSign(FsVerityDescriptor fsVerityDescriptor, byte[] signature) {
        this.fsVerityDescriptor = fsVerityDescriptor;
        if (signature != null) {
            this.signature = signature;
        }
        this.length = 256 + this.signature.length;
    }

    public FsVerityDescriptorWithSign(int type, int length, FsVerityDescriptor fsVerityDescriptor, byte[] signature) {
        this.type = type;
        this.length = length;
        this.fsVerityDescriptor = fsVerityDescriptor;
        this.signature = signature;
    }

    public int size() {
        return 264 + this.signature.length;
    }

    public byte[] toByteArray() throws FsVerityDigestException {
        ByteBuffer buffer = ByteBuffer.allocate(this.size()).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(this.type);
        buffer.putInt(this.length);
        buffer.put(this.fsVerityDescriptor.toByteArray());
        buffer.put(this.signature);
        return buffer.array();
    }

    public FsVerityDescriptor getFsVerityDescriptor() {
        return this.fsVerityDescriptor;
    }

    public byte[] getSignature() {
        return this.signature;
    }
}

