/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.sign;

import com.ohos.hapsigntool.codesigning.exception.CodeSignException;
import com.ohos.hapsigntool.codesigning.sign.SignedDataGenerator;
import com.ohos.hapsigntool.codesigning.utils.CmsUtils;
import com.ohos.hapsigntool.codesigning.utils.DigestUtils;
import com.ohos.hapsigntool.entity.ContentDigestAlgorithm;
import com.ohos.hapsigntool.entity.Pair;
import com.ohos.hapsigntool.entity.SignatureAlgorithm;
import com.ohos.hapsigntool.hap.config.SignerConfig;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.pkcs.SignerInfo;
import org.bouncycastle.cert.jcajce.JcaX509CRLHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;

public class BcSignedDataGenerator
implements SignedDataGenerator {
    public static final String SIGNER_OID = "1.3.6.1.4.1.2011.2.376.1.4.1";
    private static final Logger LOGGER = LogManager.getLogger(BcSignedDataGenerator.class);
    private static final SignatureAlgorithmIdentifierFinder SIGN_ALG_ID_FINDER = new DefaultSignatureAlgorithmIdentifierFinder();
    private static final DigestAlgorithmIdentifierFinder DIGEST_ALG_ID_FINDER = new DefaultDigestAlgorithmIdentifierFinder();
    private String ownerID;

    public void setOwnerID(String ownerID) {
        this.ownerID = ownerID;
    }

    @Override
    public byte[] generateSignedData(byte[] content, SignerConfig signConfig) throws CodeSignException {
        if (content == null) {
            throw new CodeSignException("Verity digest is null");
        }
        Pair<DERSet, DERSet> pairDigestAndSignInfo = this.getSignInfo(content, signConfig);
        SignedData signedData = new SignedData(new ASN1Integer(1L), pairDigestAndSignInfo.getFirst(), new ContentInfo(PKCSObjectIdentifiers.data, null), this.createBerSetFromLst(signConfig.getCertificates()), this.createBerSetFromLst(null), pairDigestAndSignInfo.getSecond());
        return this.encodingUnsignedData(content, signedData);
    }

    private Pair<DERSet, DERSet> getSignInfo(byte[] content, SignerConfig signConfig) throws CodeSignException {
        ASN1EncodableVector signInfoVector = new ASN1EncodableVector();
        ASN1EncodableVector digestVector = new ASN1EncodableVector();
        for (SignatureAlgorithm signAlgorithm : signConfig.getSignatureAlgorithms()) {
            SignerInfo signInfo = this.createSignInfo(signAlgorithm, content, signConfig);
            signInfoVector.add(signInfo);
            digestVector.add(signInfo.getDigestAlgorithm());
            LOGGER.info("Create a sign info successfully.");
        }
        return Pair.create(new DERSet(digestVector), new DERSet(signInfoVector));
    }

    private SignerInfo createSignInfo(SignatureAlgorithm signAlgorithm, byte[] unsignedDataDigest, SignerConfig signConfig) throws CodeSignException {
        ContentDigestAlgorithm hashAlgorithm = signAlgorithm.getContentDigestAlgorithm();
        byte[] digest = this.computeDigest(unsignedDataDigest, hashAlgorithm.name());
        ASN1Set authed = this.getPKCS9Attributes(digest);
        byte[] codeAuthed = this.getEncoded(authed);
        Pair<String, ? extends AlgorithmParameterSpec> signPair = signAlgorithm.getSignatureAlgAndParams();
        byte[] signBytes = signConfig.getSigner().getSignature(codeAuthed, signPair.getFirst(), signPair.getSecond());
        if (signBytes == null) {
            throw new CodeSignException("get signature failed");
        }
        if (signConfig.getCertificates().isEmpty()) {
            throw new CodeSignException("No certificates configured for sign");
        }
        X509Certificate cert = signConfig.getCertificates().get(0);
        if (!this.verifySignFromServer(cert.getPublicKey(), signBytes, signPair, codeAuthed)) {
            throw new CodeSignException("verifySignatureFromServer failed");
        }
        JcaX509CertificateHolder certificateHolder = this.getJcaX509CertificateHolder(cert);
        return new SignerInfo(new ASN1Integer(1L), new IssuerAndSerialNumber(certificateHolder.getIssuer(), certificateHolder.getSerialNumber()), DIGEST_ALG_ID_FINDER.find(hashAlgorithm.getDigestAlgorithm()), authed, SIGN_ALG_ID_FINDER.find(signPair.getFirst()), new DEROctetString(signBytes), null);
    }

    private byte[] computeDigest(byte[] unsignedDataDigest, String algorithm) throws CodeSignException {
        byte[] digest;
        try {
            digest = DigestUtils.computeDigest(unsignedDataDigest, algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CodeSignException("Invalid algorithm" + e.getMessage(), e);
        }
        return digest;
    }

    private byte[] getEncoded(ASN1Set authed) throws CodeSignException {
        byte[] codeAuthed;
        try {
            codeAuthed = authed.getEncoded();
        }
        catch (IOException e) {
            throw new CodeSignException("cannot encode authed", e);
        }
        return codeAuthed;
    }

    private JcaX509CRLHolder getJcaX509CRLHolder(X509CRL crl) throws CodeSignException {
        JcaX509CRLHolder crlHolder;
        try {
            crlHolder = new JcaX509CRLHolder(crl);
        }
        catch (CRLException e) {
            throw new CodeSignException("Create crl failed", e);
        }
        return crlHolder;
    }

    private JcaX509CertificateHolder getJcaX509CertificateHolder(X509Certificate cert) throws CodeSignException {
        JcaX509CertificateHolder certificateHolder;
        try {
            certificateHolder = new JcaX509CertificateHolder(cert);
        }
        catch (CertificateEncodingException e) {
            throw new CodeSignException("Create sign info failed", e);
        }
        return certificateHolder;
    }

    private ASN1Set getPKCS9Attributes(byte[] digest) {
        ASN1EncodableVector table = new ASN1EncodableVector();
        Attribute signingTimeAttr = new Attribute(PKCSObjectIdentifiers.pkcs_9_at_signingTime, new DERSet(new Time(new Date())));
        Attribute contentTypeAttr = new Attribute(PKCSObjectIdentifiers.pkcs_9_at_contentType, new DERSet(PKCSObjectIdentifiers.data));
        Attribute messageDigestAttr = new Attribute(PKCSObjectIdentifiers.pkcs_9_at_messageDigest, new DERSet(new DEROctetString(digest)));
        table.add(signingTimeAttr);
        table.add(contentTypeAttr);
        table.add(messageDigestAttr);
        if (this.ownerID != null) {
            Attribute ownerIDAttr = new Attribute(new ASN1ObjectIdentifier(SIGNER_OID), new DERSet(new DERUTF8String(this.ownerID)));
            table.add(ownerIDAttr);
        }
        return new DERSet(table);
    }

    private boolean verifySignFromServer(PublicKey publicKey, byte[] signBytes, Pair<String, ? extends AlgorithmParameterSpec> signPair, byte[] authed) throws CodeSignException {
        try {
            Signature signature = Signature.getInstance(signPair.getFirst());
            signature.initVerify(publicKey);
            if (signPair.getSecond() != null) {
                signature.setParameter(signPair.getSecond());
            }
            signature.update(authed);
            if (!signature.verify(signBytes)) {
                throw new CodeSignException("Signature verify failed");
            }
            return true;
        }
        catch (InvalidKeyException | SignatureException e) {
            LOGGER.error("The generated signature could not be verified  using the public key in the certificate", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("The generated signature " + signPair.getFirst() + " could not be verified using the public key in the certificate", (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            LOGGER.error("The generated signature " + signPair.getSecond() + " could not be verified using the public key in the certificate", (Throwable)e);
        }
        return false;
    }

    private ASN1Set createBerSetFromLst(List<?> lists) throws CodeSignException {
        if (lists == null || lists.size() == 0) {
            return null;
        }
        ASN1EncodableVector vector = new ASN1EncodableVector();
        for (Object obj : lists) {
            if (obj instanceof X509CRL) {
                vector.add(this.getJcaX509CRLHolder((X509CRL)obj).toASN1Structure());
                continue;
            }
            if (!(obj instanceof X509Certificate)) continue;
            vector.add(this.getJcaX509CertificateHolder((X509Certificate)obj).toASN1Structure());
        }
        return new BERSet(vector);
    }

    private byte[] encodingUnsignedData(byte[] unsignedDataDigest, SignedData signedData) throws CodeSignException {
        byte[] signResult;
        try {
            ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, signedData);
            signResult = contentInfo.getEncoded("DER");
        }
        catch (IOException e) {
            throw new CodeSignException("failed to encode unsigned data!", e);
        }
        this.verifySignResult(unsignedDataDigest, signResult);
        return signResult;
    }

    private void verifySignResult(byte[] unsignedDataDigest, byte[] signResult) throws CodeSignException {
        boolean result = false;
        try {
            result = CmsUtils.verifySignDataWithUnsignedDataDigest(unsignedDataDigest, signResult);
        }
        catch (CMSException e) {
            throw new CodeSignException("failed to verify signed data and unsigned data digest", e);
        }
        if (!result) {
            throw new CodeSignException("PKCS cms data did not verify");
        }
    }
}

