/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.sign;

import com.ohos.hapsigntool.codesigning.datastructure.CodeSignBlock;
import com.ohos.hapsigntool.codesigning.datastructure.ElfSignBlock;
import com.ohos.hapsigntool.codesigning.datastructure.FsVerityInfoSegment;
import com.ohos.hapsigntool.codesigning.datastructure.MerkleTreeExtension;
import com.ohos.hapsigntool.codesigning.datastructure.SignInfo;
import com.ohos.hapsigntool.codesigning.exception.CodeSignException;
import com.ohos.hapsigntool.codesigning.exception.FsVerityDigestException;
import com.ohos.hapsigntool.codesigning.fsverity.FsVerityDescriptor;
import com.ohos.hapsigntool.codesigning.fsverity.FsVerityDescriptorWithSign;
import com.ohos.hapsigntool.codesigning.fsverity.FsVerityGenerator;
import com.ohos.hapsigntool.codesigning.sign.BcSignedDataGenerator;
import com.ohos.hapsigntool.codesigning.utils.HapUtils;
import com.ohos.hapsigntool.entity.Pair;
import com.ohos.hapsigntool.error.HapFormatException;
import com.ohos.hapsigntool.error.ProfileException;
import com.ohos.hapsigntool.hap.config.SignerConfig;
import com.ohos.hapsigntool.signer.LocalSigner;
import com.ohos.hapsigntool.utils.FileUtils;
import com.ohos.hapsigntool.utils.StringUtils;
import com.ohos.hapsigntool.zip.Zip;
import com.ohos.hapsigntool.zip.ZipEntry;
import com.ohos.hapsigntool.zip.ZipEntryHeader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CodeSigning {
    public static final String[] SUPPORT_FILE_FORM = new String[]{"hap", "hsp", "hqf"};
    public static final String SUPPORT_BIN_FILE_FORM = "elf";
    public static final String HAP_SIGNATURE_ENTRY_NAME = "Hap";
    private static final Logger LOGGER = LogManager.getLogger(CodeSigning.class);
    private static final String NATIVE_LIB_AN_SUFFIX = ".an";
    private static final String NATIVE_LIB_SO_SUFFIX = ".so";
    private final SignerConfig signConfig;
    private CodeSignBlock codeSignBlock;

    public CodeSigning(SignerConfig signConfig) {
        this.signConfig = signConfig;
    }

    public byte[] getElfCodeSignBlock(File input, long offset, String inForm, String profileContent) throws CodeSignException, FsVerityDigestException, IOException, ProfileException {
        LOGGER.info("Start to sign code.");
        if (!SUPPORT_BIN_FILE_FORM.equalsIgnoreCase(inForm)) {
            throw new CodeSignException("file's format is unsupported");
        }
        long fileSize = input.length();
        int paddingSize = ElfSignBlock.computeMerkleTreePaddingLength(offset);
        long fsvTreeOffset = offset + 8L + (long)paddingSize;
        try (FileInputStream inputStream = new FileInputStream(input);){
            FsVerityGenerator fsVerityGenerator = new FsVerityGenerator();
            fsVerityGenerator.generateFsVerityDigest(inputStream, fileSize, fsvTreeOffset);
            byte[] fsVerityDigest = fsVerityGenerator.getFsVerityDigest();
            String ownerID = profileContent == null ? "DEBUG_LIB_ID" : HapUtils.getAppIdentifier(profileContent);
            byte[] signature = this.generateSignature(fsVerityDigest, ownerID);
            FsVerityDescriptor.Builder fsdbuilder = new FsVerityDescriptor.Builder().setFileSize(fileSize).setHashAlgorithm(FsVerityGenerator.getFsVerityHashAlgorithm()).setLog2BlockSize(FsVerityGenerator.getLog2BlockSize()).setSaltSize((byte)fsVerityGenerator.getSaltSize()).setSignSize(signature.length).setFileSize(fileSize).setSalt(fsVerityGenerator.getSalt()).setRawRootHash(fsVerityGenerator.getRootHash()).setFlags(1).setMerkleTreeOffset(fsvTreeOffset).setCsVersion((byte)1);
            FsVerityDescriptorWithSign fsVerityDescriptorWithSign = new FsVerityDescriptorWithSign(fsdbuilder.build(), signature);
            byte[] treeBytes = fsVerityGenerator.getTreeBytes();
            ElfSignBlock signBlock = new ElfSignBlock(paddingSize, treeBytes, fsVerityDescriptorWithSign);
            LOGGER.info("Sign elf successfully.");
            byte[] byArray = signBlock.toByteArray();
            return byArray;
        }
    }

    public byte[] getCodeSignBlock(File input, long offset, String inForm, String profileContent, Zip zip) throws CodeSignException, IOException, HapFormatException, FsVerityDigestException, ProfileException {
        LOGGER.info("Start to sign code.");
        if (!StringUtils.containsIgnoreCase(SUPPORT_FILE_FORM, inForm)) {
            throw new CodeSignException("file's format is unsupported");
        }
        long dataSize = this.computeDataSize(zip);
        this.codeSignBlock = new CodeSignBlock();
        long fsvTreeOffset = this.codeSignBlock.computeMerkleTreeOffset(offset);
        FsVerityInfoSegment fsVerityInfoSegment = new FsVerityInfoSegment(1, FsVerityGenerator.getFsVerityHashAlgorithm(), FsVerityGenerator.getLog2BlockSize());
        this.codeSignBlock.setFsVerityInfoSegment(fsVerityInfoSegment);
        LOGGER.debug("Sign hap.");
        String ownerID = HapUtils.getAppIdentifier(profileContent);
        try (FileInputStream inputStream = new FileInputStream(input);){
            Pair<SignInfo, byte[]> hapSignInfoAndMerkleTreeBytesPair = this.signFile(inputStream, dataSize, true, fsvTreeOffset, ownerID);
            this.codeSignBlock.getHapInfoSegment().setSignInfo(hapSignInfoAndMerkleTreeBytesPair.getFirst());
            this.codeSignBlock.addOneMerkleTree(HAP_SIGNATURE_ENTRY_NAME, hapSignInfoAndMerkleTreeBytesPair.getSecond());
        }
        ArrayList<Pair<String, SignInfo>> nativeLibInfoList = new ArrayList<Pair<String, SignInfo>>();
        nativeLibInfoList.addAll(this.signNativeLibs(input, ownerID));
        nativeLibInfoList.addAll(this.signNativeHnps(input, profileContent, ownerID));
        this.codeSignBlock.getSoInfoSegment().setSoInfoList(nativeLibInfoList);
        this.updateCodeSignBlock(this.codeSignBlock);
        byte[] generated = this.codeSignBlock.generateCodeSignBlockByte(fsvTreeOffset);
        LOGGER.info("Sign successfully.");
        return generated;
    }

    private long computeDataSize(Zip zip) throws HapFormatException {
        long dataSize = 0L;
        for (ZipEntry entry : zip.getZipEntries()) {
            ZipEntryHeader zipEntryHeader = entry.getZipEntryData().getZipEntryHeader();
            if (FileUtils.isRunnableFile(zipEntryHeader.getFileName()) && zipEntryHeader.getMethod() == 0) continue;
            if (entry.getCentralDirectory().getOffset() == 0L) break;
            dataSize = entry.getCentralDirectory().getOffset() + 30L + (long)zipEntryHeader.getFileNameLength() + (long)zipEntryHeader.getExtraLength();
            break;
        }
        if (dataSize % 4096L != 0L) {
            throw new HapFormatException(String.format(Locale.ROOT, "Invalid dataSize(%d), not a multiple of 4096", dataSize));
        }
        return dataSize;
    }

    private List<Pair<String, SignInfo>> signNativeLibs(File input, String ownerID) throws IOException, FsVerityDigestException, CodeSignException {
        try (JarFile inputJar = new JarFile(input, false);){
            List<String> entryNames = this.getNativeEntriesFromHap(inputJar);
            if (entryNames.isEmpty()) {
                LOGGER.info("No native libs.");
                ArrayList<Pair<String, SignInfo>> arrayList = new ArrayList<Pair<String, SignInfo>>();
                return arrayList;
            }
            List<Pair<String, SignInfo>> list = this.signFilesFromJar(entryNames, inputJar, ownerID);
            return list;
        }
    }

    private List<Pair<String, SignInfo>> signNativeHnps(File input, String profileContent, String ownerID) throws IOException, CodeSignException, ProfileException {
        ArrayList<Pair<String, SignInfo>> nativeLibInfoList = new ArrayList<Pair<String, SignInfo>>();
        try (JarFile inputJar = new JarFile(input, false);){
            Map<String, String> hnpTypeMap = HapUtils.getHnpsFromJson(inputJar);
            Enumeration<JarEntry> e = inputJar.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                String entryName = entry.getName();
                if (entry.isDirectory() || !entryName.startsWith("hnp/") || !entryName.toLowerCase(Locale.ROOT).endsWith(".hnp")) continue;
                String hnpFileName = HapUtils.parseHnpPath(entryName);
                if (!hnpTypeMap.containsKey(hnpFileName)) {
                    throw new CodeSignException("hnp should be described in module.json");
                }
                LOGGER.debug("Sign hnp name = {}", (Object)entryName);
                String type = hnpTypeMap.get(hnpFileName);
                String hnpOwnerId = ownerID;
                if ("public".equals(type)) {
                    hnpOwnerId = HapUtils.getPublicHnpOwnerId(profileContent);
                }
                nativeLibInfoList.addAll(this.signHnpLibs(inputJar, entry, hnpOwnerId));
            }
        }
        return nativeLibInfoList;
    }

    private List<Pair<String, SignInfo>> signHnpLibs(JarFile inputJar, JarEntry hnpEntry, String ownerID) throws IOException, CodeSignException {
        Map<String, Long> elfEntries = this.getElfEntriesFromHnp(inputJar, hnpEntry);
        List<Pair<String, SignInfo>> nativeLibInfoList = ((Stream)elfEntries.entrySet().stream().parallel()).map(elf -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }).collect(Collectors.toList());
        if (nativeLibInfoList.contains(null)) {
            throw new CodeSignException("Sign hnp lib error");
        }
        return nativeLibInfoList;
    }

    public Pair<String, SignInfo> signHnpElf(ZipInputStream hnpInputStream, String hnpElfPath, String ownerID, Map.Entry<String, Long> elf) throws IOException, FsVerityDigestException, CodeSignException {
        java.util.zip.ZipEntry libEntry = null;
        while ((libEntry = hnpInputStream.getNextEntry()) != null) {
            if (!elf.getKey().equals(libEntry.getName())) continue;
            long fileSize = elf.getValue();
            Pair<SignInfo, byte[]> pairSignInfoAndMerkleTreeBytes = this.signFile(hnpInputStream, fileSize, false, 0L, ownerID);
            return Pair.create(hnpElfPath, pairSignInfoAndMerkleTreeBytes.getFirst());
        }
        return null;
    }

    private Map<String, Long> getElfEntriesFromHnp(JarFile inputJar, JarEntry hnpEntry) throws IOException {
        HashMap<String, Long> elfEntries = new HashMap<String, Long>();
        try (InputStream inputStream = inputJar.getInputStream(hnpEntry);
             ZipInputStream hnpInputStream = new ZipInputStream(inputStream);){
            java.util.zip.ZipEntry libEntry = null;
            while ((libEntry = hnpInputStream.getNextEntry()) != null) {
                int readLen;
                byte[] bytes = new byte[4];
                hnpInputStream.read(bytes, 0, 4);
                if (!this.isElfFile(bytes)) {
                    hnpInputStream.closeEntry();
                    continue;
                }
                byte[] tmp = new byte[4096];
                while ((readLen = hnpInputStream.read(tmp, 0, 4096)) > 0) {
                }
                elfEntries.put(libEntry.getName(), libEntry.getSize());
                hnpInputStream.closeEntry();
            }
        }
        return elfEntries;
    }

    private List<String> getNativeEntriesFromHap(JarFile hap) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<JarEntry> e = hap.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (entry.isDirectory() || !this.isNativeFile(entry.getName())) continue;
            result.add(entry.getName());
        }
        return result;
    }

    private boolean isNativeFile(String entryName) {
        if (StringUtils.isEmpty(entryName)) {
            return false;
        }
        if (entryName.endsWith(NATIVE_LIB_AN_SUFFIX)) {
            return true;
        }
        return entryName.startsWith("libs/");
    }

    private boolean isElfFile(byte[] bytes) {
        if (bytes == null || bytes.length != 4) {
            return false;
        }
        return bytes[0] == 127 && bytes[1] == 69 && bytes[2] == 76 && bytes[3] == 70;
    }

    private List<Pair<String, SignInfo>> signFilesFromJar(List<String> entryNames, JarFile hap, String ownerID) throws CodeSignException {
        List<Pair<String, SignInfo>> nativeLibInfoList = ((Stream)entryNames.stream().parallel()).map(name -> {
            LOGGER.debug("Sign entry name = {}", name);
            JarEntry inEntry = hap.getJarEntry((String)name);
            try (InputStream inputStream = hap.getInputStream(inEntry);){
                long fileSize = inEntry.getSize();
                Pair<SignInfo, byte[]> pairSignInfoAndMerkleTreeBytes = this.signFile(inputStream, fileSize, false, 0L, ownerID);
                Pair<String, SignInfo> pair = Pair.create(name, pairSignInfoAndMerkleTreeBytes.getFirst());
                return pair;
            }
            catch (CodeSignException | FsVerityDigestException | IOException e) {
                LOGGER.error("Sign lib error, entry name = {}, msg : {}", name, (Object)e.getMessage());
                return null;
            }
        }).collect(Collectors.toList());
        if (nativeLibInfoList.contains(null)) {
            throw new CodeSignException("Sign lib error");
        }
        return nativeLibInfoList;
    }

    public Pair<SignInfo, byte[]> signFile(InputStream inputStream, long fileSize, boolean storeTree, long fsvTreeOffset, String ownerID) throws FsVerityDigestException, CodeSignException {
        FsVerityGenerator fsVerityGenerator = new FsVerityGenerator();
        fsVerityGenerator.generateFsVerityDigest(inputStream, fileSize, fsvTreeOffset);
        byte[] fsVerityDigest = fsVerityGenerator.getFsVerityDigest();
        byte[] signature = this.generateSignature(fsVerityDigest, ownerID);
        int flags = 0;
        if (storeTree) {
            flags = 1;
        }
        SignInfo signInfo = new SignInfo(fsVerityGenerator.getSaltSize(), flags, fileSize, fsVerityGenerator.getSalt(), signature);
        if (storeTree) {
            int merkleTreeSize = fsVerityGenerator.getTreeBytes() == null ? 0 : fsVerityGenerator.getTreeBytes().length;
            MerkleTreeExtension merkleTreeExtension = new MerkleTreeExtension(merkleTreeSize, fsvTreeOffset, fsVerityGenerator.getRootHash());
            signInfo.addExtension(merkleTreeExtension);
        }
        return Pair.create(signInfo, fsVerityGenerator.getTreeBytes());
    }

    private byte[] generateSignature(byte[] signedData, String ownerID) throws CodeSignException {
        SignerConfig copiedConfig = this.signConfig;
        if (copiedConfig.getSigner() instanceof LocalSigner) {
            if (copiedConfig.getCertificates().isEmpty()) {
                throw new CodeSignException("No certificates configured for sign");
            }
            BcSignedDataGenerator bcSignedDataGenerator = new BcSignedDataGenerator();
            bcSignedDataGenerator.setOwnerID(ownerID);
            return bcSignedDataGenerator.generateSignedData(signedData, copiedConfig);
        }
        copiedConfig = this.signConfig.copy();
        BcSignedDataGenerator bcSignedDataGenerator = new BcSignedDataGenerator();
        bcSignedDataGenerator.setOwnerID(ownerID);
        return bcSignedDataGenerator.generateSignedData(signedData, copiedConfig);
    }

    private void updateCodeSignBlock(CodeSignBlock codeSignBlock) {
        codeSignBlock.setSegmentHeaders();
        codeSignBlock.setSegmentNum();
        codeSignBlock.setCodeSignBlockFlag();
        codeSignBlock.computeSegmentOffset();
    }
}

