/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.utils;

import java.security.Security;
import java.security.cert.CertificateException;
import java.util.Collection;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorCreationException;

public class CmsUtils {
    private CmsUtils() {
    }

    private static void isCollectionValid(Collection<X509CertificateHolder> collection) throws OperatorCreationException {
        if (collection == null) {
            throw new OperatorCreationException("No matched cert: " + collection);
        }
        if (collection.size() != 1) {
            throw new OperatorCreationException("More than one matched certs, matched certs size: " + collection.size());
        }
    }

    private static boolean verifyCmsSignedData(CMSSignedData cmsSignedData) throws CMSException {
        return cmsSignedData.verifySignatures(signId -> {
            Collection<X509CertificateHolder> collection = cmsSignedData.getCertificates().getMatches(signId);
            CmsUtils.isCollectionValid(collection);
            X509CertificateHolder cert = collection.iterator().next();
            try {
                return new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(cert);
            }
            catch (CertificateException e) {
                throw new OperatorCreationException("Verify BC signatures failed: " + e.getMessage(), e);
            }
        });
    }

    public static boolean verifySignDataWithUnsignedDataDigest(byte[] unsignedDataDigest, byte[] signedData) throws CMSException {
        CMSSignedData cmsSignedData = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(unsignedDataDigest), signedData);
        return CmsUtils.verifyCmsSignedData(cmsSignedData);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }
}

