/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.ohos.hapsigntool.codesigning.utils.InputStreamUtils;
import com.ohos.hapsigntool.entity.Pair;
import com.ohos.hapsigntool.error.ProfileException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HapUtils {
    public static final String HAP_DEBUG_OWNER_ID = "DEBUG_LIB_ID";
    public static final String HAP_SHARED_OWNER_ID = "SHARED_LIB_ID";
    private static final Logger LOGGER = LogManager.getLogger(HapUtils.class);
    private static final String COMPRESS_NATIVE_LIBS_OPTION = "compressNativeLibs";
    private static final List<String> HAP_CONFIG_FILES = new ArrayList<String>();
    private static final String HAP_FA_CONFIG_JSON_FILE = "config.json";
    private static final String HAP_STAGE_MODULE_JSON_FILE = "module.json";
    private static final int MAX_APP_ID_LEN = 32;

    private HapUtils() {
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean checkCompressNativeLibs(File hapFile) throws IOException {
        Throwable throwable = null;
        try (JarFile inputJar = new JarFile(hapFile, false);){
            for (String configFile : HAP_CONFIG_FILES) {
                JarEntry entry = inputJar.getJarEntry(configFile);
                if (entry == null) continue;
                try (InputStream data = inputJar.getInputStream(entry);){
                    String jsonString = new String(InputStreamUtils.toByteArray(data, (int)entry.getSize()), StandardCharsets.UTF_8);
                    boolean bl = HapUtils.checkCompressNativeLibs(jsonString);
                    return bl;
                }
                {
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                        return true;
                    }
                }
            }
        }
    }

    public static boolean checkCompressNativeLibs(String jsonString) {
        JsonObject jsonObject = JsonParser.parseString(jsonString).getAsJsonObject();
        LinkedList<JsonObject> queue = new LinkedList<JsonObject>();
        queue.offer(jsonObject);
        while (queue.size() > 0) {
            JsonObject curJsonObject = (JsonObject)queue.poll();
            JsonElement jsonElement = curJsonObject.get(COMPRESS_NATIVE_LIBS_OPTION);
            if (jsonElement != null) {
                return jsonElement.getAsBoolean();
            }
            for (Map.Entry<String, JsonElement> entry : curJsonObject.entrySet()) {
                if (!entry.getValue().isJsonObject()) continue;
                queue.offer(entry.getValue().getAsJsonObject());
            }
        }
        return true;
    }

    public static String getAppIdentifier(String profileContent) throws ProfileException {
        Pair<String, String> resultPair = HapUtils.parseAppIdentifier(profileContent);
        String ownerID = resultPair.getFirst();
        String profileType = resultPair.getSecond();
        if ("debug".equals(profileType)) {
            return HAP_DEBUG_OWNER_ID;
        }
        if ("release".equals(profileType)) {
            return ownerID;
        }
        throw new ProfileException("unsupported profile type");
    }

    public static Pair<String, String> parseAppIdentifier(String profileContent) throws ProfileException {
        String ownerID = null;
        String profileType = null;
        try {
            JsonElement parser = JsonParser.parseString(profileContent);
            JsonObject profileJson = parser.getAsJsonObject();
            String profileTypeKey = "type";
            if (!profileJson.has(profileTypeKey)) {
                throw new ProfileException("profile has no type key");
            }
            profileType = profileJson.get(profileTypeKey).getAsString();
            if (profileType == null || profileType.length() == 0) {
                throw new ProfileException("Get profile type error");
            }
            String appIdentifier = "app-identifier";
            String buildInfoMember = "bundle-info";
            JsonObject buildInfoObject = profileJson.getAsJsonObject(buildInfoMember);
            if (buildInfoObject == null) {
                throw new ProfileException("can not find bundle-info");
            }
            if (buildInfoObject.has(appIdentifier)) {
                JsonElement ownerIDElement = buildInfoObject.get(appIdentifier);
                if (!ownerIDElement.getAsJsonPrimitive().isString()) {
                    throw new ProfileException("value of app-identifier is not string");
                }
                ownerID = ownerIDElement.getAsString();
                if (ownerID.isEmpty() || ownerID.length() > 32) {
                    throw new ProfileException("app-id length in profile is invalid");
                }
            }
        }
        catch (JsonSyntaxException | UnsupportedOperationException e) {
            LOGGER.error(e.getMessage());
            throw new ProfileException("profile json is invalid");
        }
        LOGGER.info("profile type is: {}", (Object)profileType);
        return Pair.create(ownerID, profileType);
    }

    public static String getPublicHnpOwnerId(String profileContent) {
        String profileTypeKey;
        String publicOwnerID = "";
        JsonElement parser = JsonParser.parseString(profileContent);
        JsonObject profileJson = parser.getAsJsonObject();
        JsonPrimitive profileType = profileJson.getAsJsonPrimitive(profileTypeKey = "type");
        if (profileType != null) {
            if ("debug".equals(profileType.getAsString())) {
                publicOwnerID = HAP_DEBUG_OWNER_ID;
            } else if ("release".equals(profileType.getAsString())) {
                publicOwnerID = HAP_SHARED_OWNER_ID;
            }
        }
        return publicOwnerID;
    }

    public static String parseHnpPath(String path) {
        if (path == null || path.isEmpty()) {
            return "";
        }
        CharSequence[] strings = path.split("/");
        if (strings.length < 3) {
            return "";
        }
        strings = Arrays.copyOfRange(strings, 2, strings.length);
        return String.join((CharSequence)"/", strings);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getHnpsFromJson(JarFile inputJar) throws IOException, ProfileException {
        HashMap<String, String> hnpNameMap = new HashMap<String, String>();
        JarEntry moduleEntry = inputJar.getJarEntry(HAP_STAGE_MODULE_JSON_FILE);
        if (moduleEntry == null) {
            return hnpNameMap;
        }
        try (JsonReader reader = new JsonReader(new InputStreamReader(inputJar.getInputStream(moduleEntry), StandardCharsets.UTF_8));){
            JsonElement jsonElement = JsonParser.parseReader(reader);
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            JsonObject moduleObject = jsonObject.getAsJsonObject("module");
            JsonArray hnpPackageArr = moduleObject.getAsJsonArray("hnpPackages");
            if (hnpPackageArr == null || hnpPackageArr.isEmpty()) {
                LOGGER.debug("profile has no hnpPackages key or hnpPackages value is empty");
                HashMap<String, String> hashMap = hnpNameMap;
                return hashMap;
            }
            hnpPackageArr.iterator().forEachRemaining(element -> {
                JsonObject hnpPackage = element.getAsJsonObject();
                JsonPrimitive hnpName = hnpPackage.getAsJsonPrimitive("package");
                if (hnpName == null || hnpName.getAsString().isEmpty()) {
                    return;
                }
                hnpNameMap.put(hnpName.getAsString(), "private");
                JsonPrimitive type = hnpPackage.getAsJsonPrimitive("type");
                if (type != null && !type.getAsString().isEmpty()) {
                    hnpNameMap.put(hnpName.getAsString(), type.getAsString());
                }
            });
            return hnpNameMap;
        }
        catch (JsonParseException e) {
            LOGGER.error(e.getMessage());
            throw new ProfileException("profile json is invalid");
        }
    }

    static {
        HAP_CONFIG_FILES.add(HAP_FA_CONFIG_JSON_FILE);
        HAP_CONFIG_FILES.add(HAP_STAGE_MODULE_JSON_FILE);
    }
}

