/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.hap.entity;

import com.ohos.hapsigntool.utils.ByteArrayUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class HwSignHead {
    public static final int SIGN_HEAD_LEN = 32;
    public static final char[] MAGIC = "hw signed app   ".toCharArray();
    public static final char[] ELF_MAGIC = "elf sign block  ".toCharArray();
    public static final char[] VERSION = "1000".toCharArray();
    private static final int NUM_OF_BLOCK = 2;
    private static final int RESERVE_LENGTH = 4;
    private char[] reserve = new char[4];

    public byte[] getSignHead(int subBlockSize) {
        int size = subBlockSize;
        byte[] signHead = new byte[32];
        int start = 0;
        try {
            start = ByteArrayUtils.insertCharToByteArray(signHead, start, MAGIC);
            if (start < 0) {
                throw new IOException();
            }
            if ((start = ByteArrayUtils.insertCharToByteArray(signHead, start, VERSION)) < 0) {
                throw new IOException();
            }
            if ((start = ByteArrayUtils.insertIntToByteArray(signHead, start, size)) < 0) {
                throw new IOException();
            }
            if ((start = ByteArrayUtils.insertIntToByteArray(signHead, start, 2)) < 0) {
                throw new IOException();
            }
            if ((start = ByteArrayUtils.insertCharToByteArray(signHead, start, this.reserve)) < 0) {
                throw new IOException();
            }
        }
        catch (IOException e) {
            return new byte[0];
        }
        return signHead;
    }

    public byte[] getSignHeadLittleEndian(int subBlockSize, int subBlockNum) {
        ByteBuffer bf = ByteBuffer.allocate(32).order(ByteOrder.LITTLE_ENDIAN);
        for (char c : ELF_MAGIC) {
            bf.put((byte)c);
        }
        for (char c : VERSION) {
            bf.put((byte)c);
        }
        bf.putInt(subBlockSize);
        bf.putInt(subBlockNum);
        for (char c : this.reserve) {
            bf.put((byte)c);
        }
        return bf.array();
    }
}

