/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.hap.provider;

import com.ohos.hapsigntool.entity.Options;
import com.ohos.hapsigntool.error.InvalidParamsException;
import com.ohos.hapsigntool.error.MissingParamsException;
import com.ohos.hapsigntool.hap.provider.SignProvider;
import com.ohos.hapsigntool.utils.FileUtils;
import com.ohos.hapsigntool.utils.ParamProcessUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CRL;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalJKSSignProvider
extends SignProvider {
    private static final Logger LOGGER = LogManager.getLogger(LocalJKSSignProvider.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<X509CRL> getCrl() {
        X509CRL crl = null;
        String crlPath = (String)this.signParams.get("crl");
        if (crlPath == null) return Optional.ofNullable(crl);
        if ("".equals(crlPath)) {
            return Optional.ofNullable(crl);
        }
        try (FileInputStream input = new FileInputStream(new File(crlPath));){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            CRL baseCrl = cf.generateCRL(input);
            if (!(baseCrl instanceof X509CRL)) {
                LOGGER.error("crl is not X509CRL");
                Optional<X509CRL> optional = Optional.ofNullable(crl);
                return optional;
            }
            crl = (X509CRL)baseCrl;
            return Optional.ofNullable(crl);
        }
        catch (IOException e) {
            LOGGER.error("read CRL File has IOException!");
            crl = null;
            return Optional.ofNullable(crl);
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("Generate x509 CRL failed!");
            crl = null;
        }
        return Optional.ofNullable(crl);
    }

    private void checkPublicKeyPath() throws InvalidParamsException {
        String publicCertsFile = (String)this.signParams.get("appCertFile");
        File publicKeyFile = new File(publicCertsFile);
        try {
            FileUtils.isValidFile(publicKeyFile);
        }
        catch (IOException e) {
            LOGGER.error("file is invalid: " + publicCertsFile + System.lineSeparator(), (Throwable)e);
            throw new InvalidParamsException("Invalid file: " + publicCertsFile);
        }
    }

    @Override
    public void checkParams(Options options) throws InvalidParamsException, MissingParamsException {
        super.checkParams(options);
        String[] paramFileds = new String[]{"keystoreFile", "keystorePwd", "keyPwd"};
        Set<String> paramSet = ParamProcessUtil.initParamField(paramFileds);
        for (String paramKey : options.keySet()) {
            if (!paramSet.contains(paramKey)) continue;
            if (paramKey.endsWith("Pwd")) {
                this.signParams.put(paramKey, new String(options.getChars(paramKey)));
                continue;
            }
            this.signParams.put(paramKey, options.getString(paramKey));
        }
        this.checkSignCode();
        this.checkPublicKeyPath();
    }
}

