/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.hap.utils;

import com.ohos.hapsigntool.entity.ContentDigestAlgorithm;
import com.ohos.hapsigntool.entity.Pair;
import com.ohos.hapsigntool.error.SignatureNotFoundException;
import com.ohos.hapsigntool.hap.entity.SigningBlock;
import com.ohos.hapsigntool.zip.MessageDigestZipDataOutput;
import com.ohos.hapsigntool.zip.ZipDataInput;
import com.ohos.hapsigntool.zip.ZipFileInfo;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.Arrays;

public class HapUtils {
    private static final Logger LOGGER = LogManager.getLogger(HapUtils.class);
    public static final int HAP_SIGNATURE_SCHEME_V1_BLOCK_ID = 0x20000000;
    public static final int HAP_PROOF_OF_ROTATION_BLOCK_ID = 0x20000001;
    public static final int HAP_PROFILE_BLOCK_ID = 0x20000002;
    public static final int HAP_PROPERTY_BLOCK_ID = 0x20000003;
    public static final int HAP_CODE_SIGN_BLOCK_ID = 0x30000001;
    public static final int CONTENT_DIGESTED_CHUNK_MAX_SIZE_BYTES = 0x100000;
    public static final int CONTENT_VERSION = 2;
    public static final int BIT_SIZE = 8;
    public static final int HALF_BIT_SIZE = 4;
    public static final int INT_SIZE = 4;
    public static final int BLOCK_NUMBER = 1;
    public static final int HAP_SIGN_SCHEME_V2_BLOCK_VERSION = 2;
    public static final int HAP_SIGN_SCHEME_V3_BLOCK_VERSION = 3;
    public static final long HAP_SIG_BLOCK_MAGIC_LO_V2 = 2334950737560224072L;
    public static final long HAP_SIG_BLOCK_MAGIC_HI_V2 = 3617552046287187010L;
    public static final long HAP_SIG_BLOCK_MAGIC_LO_V3 = 7451613641622775868L;
    public static final long HAP_SIG_BLOCK_MAGIC_HI_V3 = 4497797983070462062L;
    public static final int HAP_SIG_BLOCK_HEADER_SIZE = 32;
    public static final int HAP_SIG_BLOCK_MIN_SIZE = 32;
    public static final int BLOCK_SIZE = 8;
    private static final Set<Integer> HAP_SIGNATURE_OPTIONAL_BLOCK_IDS;
    private static final int MIN_COMPATIBLE_VERSION_FOR_SCHEMA_V3 = 8;
    private static final byte[] HAP_SIGNING_BLOCK_MAGIC_V2;
    private static final byte[] HAP_SIGNING_BLOCK_MAGIC_V3;
    private static final byte ZIP_FIRST_LEVEL_CHUNK_PREFIX = 90;
    private static final byte ZIP_SECOND_LEVEL_CHUNK_PREFIX = -91;
    private static final int DIGEST_PRIFIX_LENGTH = 5;
    private static final int BUFFER_LENGTH = 4096;
    private static final char[] HEX_CHAR_ARRAY;

    private HapUtils() {
    }

    public static Set<Integer> getHapSignatureOptionalBlockIds() {
        return HAP_SIGNATURE_OPTIONAL_BLOCK_IDS;
    }

    public static byte[] getHapSigningBlockMagic(int compatibleVersion) {
        if (compatibleVersion >= 8) {
            return (byte[])HAP_SIGNING_BLOCK_MAGIC_V3.clone();
        }
        return (byte[])HAP_SIGNING_BLOCK_MAGIC_V2.clone();
    }

    public static int getHapSigningBlockVersion(int compatibleVersion) {
        if (compatibleVersion >= 8) {
            return 3;
        }
        return 2;
    }

    /*
     * Exception decompiling
     */
    public static byte[] readFileToByte(String file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static long getChunkCount(ZipDataInput[] contents) {
        long chunkCount = 0L;
        for (ZipDataInput content : contents) {
            chunkCount += (content.size() + 0x100000L - 1L) / 0x100000L;
        }
        return chunkCount;
    }

    public static Map<ContentDigestAlgorithm, byte[]> computeDigests(Set<ContentDigestAlgorithm> digestAlgorithms, ZipDataInput[] zipData, List<SigningBlock> optionalBlocks) throws DigestException, IOException {
        long chunkCountLong = HapUtils.getChunkCount(zipData);
        if (chunkCountLong > Integer.MAX_VALUE) {
            throw new DigestException("Input too long: " + chunkCountLong + " chunks");
        }
        int chunkCount = (int)chunkCountLong;
        ContentDigestAlgorithm[] contentDigestAlgorithms = digestAlgorithms.toArray(new ContentDigestAlgorithm[digestAlgorithms.size()]);
        MessageDigest[] messageDigests = new MessageDigest[contentDigestAlgorithms.length];
        int[] digestOutputSizes = new int[contentDigestAlgorithms.length];
        byte[][] digestOfChunks = new byte[contentDigestAlgorithms.length][];
        HapUtils.initComputeItem(chunkCount, contentDigestAlgorithms, messageDigests, digestOutputSizes, digestOfChunks);
        int chunkIndex = 0;
        byte[] chunkContentPrefix = new byte[5];
        chunkContentPrefix[0] = -91;
        byte[] buf = new byte[0x100000];
        MessageDigestZipDataOutput digests = new MessageDigestZipDataOutput(messageDigests);
        for (ZipDataInput content : zipData) {
            long offset = 0L;
            long remaining = content.size();
            while (remaining > 0L) {
                int chunkSize = (int)Math.min((long)buf.length, remaining);
                HapUtils.setUInt32ToByteArrayWithLittleEngian(chunkSize, chunkContentPrefix, 1);
                for (int i = 0; i < contentDigestAlgorithms.length; ++i) {
                    messageDigests[i].update(chunkContentPrefix);
                }
                try {
                    content.copyTo(offset, (long)chunkSize, digests);
                }
                catch (IOException e) {
                    throw new IOException("Failed to read chunk #" + chunkIndex, e);
                }
                HapUtils.getDigests(contentDigestAlgorithms, digestOutputSizes, messageDigests, digestOfChunks, chunkIndex);
                offset += (long)chunkSize;
                remaining -= (long)chunkSize;
                ++chunkIndex;
            }
        }
        return HapUtils.getContentDigestAlgorithmMap(optionalBlocks, contentDigestAlgorithms, messageDigests, digestOfChunks);
    }

    private static void getDigests(ContentDigestAlgorithm[] contentDigestAlgorithms, int[] digestOutputSizes, MessageDigest[] messageDigests, byte[][] digestOfChunks, int chunkIndex) throws DigestException {
        for (int i = 0; i < contentDigestAlgorithms.length; ++i) {
            int expectedDigestSizeBytes = digestOutputSizes[i];
            int actualDigestSizeBytes = messageDigests[i].digest(digestOfChunks[i], chunkIndex * expectedDigestSizeBytes + 5, expectedDigestSizeBytes);
            if (actualDigestSizeBytes == expectedDigestSizeBytes) continue;
            throw new DigestException("Unexpected output size of " + messageDigests[i].getAlgorithm() + " digest: " + actualDigestSizeBytes);
        }
    }

    private static void initComputeItem(int chunkCount, ContentDigestAlgorithm[] contentDigestAlgorithms, MessageDigest[] messageDigests, int[] digestOutputSizes, byte[][] digestOfChunks) throws DigestException {
        try {
            for (int i = 0; i < contentDigestAlgorithms.length; ++i) {
                int digestOutputSizeBytes = contentDigestAlgorithms[i].getDigestOutputByteSize();
                byte[] concatenationOfChunkCountAndChunkDigests = new byte[5 + chunkCount * digestOutputSizeBytes];
                concatenationOfChunkCountAndChunkDigests[0] = 90;
                HapUtils.setUInt32ToByteArrayWithLittleEngian(chunkCount, concatenationOfChunkCountAndChunkDigests, 1);
                digestOfChunks[i] = concatenationOfChunkCountAndChunkDigests;
                messageDigests[i] = MessageDigest.getInstance(contentDigestAlgorithms[i].getDigestAlgorithm());
                digestOutputSizes[i] = contentDigestAlgorithms[i].getDigestOutputByteSize();
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestException("Digest algorithm not supported", e);
        }
    }

    private static Map<ContentDigestAlgorithm, byte[]> getContentDigestAlgorithmMap(List<SigningBlock> optionalBlocks, ContentDigestAlgorithm[] contentDigestAlgorithms, MessageDigest[] messageDigests, byte[][] digestOfChunks) {
        HashMap<ContentDigestAlgorithm, byte[]> result = new HashMap<ContentDigestAlgorithm, byte[]>(contentDigestAlgorithms.length);
        for (int i = 0; i < contentDigestAlgorithms.length; ++i) {
            messageDigests[i].update(digestOfChunks[i]);
            for (SigningBlock signingBlock : optionalBlocks) {
                messageDigests[i].update(signingBlock.getValue());
            }
            result.put(contentDigestAlgorithms[i], messageDigests[i].digest());
        }
        return result;
    }

    private static void setUInt32ToByteArrayWithLittleEngian(int value, byte[] result, int offset) {
        for (int i = 0; i < 4; ++i) {
            result[offset + i] = (byte)(value >> 8 * i & 0xFF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer sliceBuffer(ByteBuffer source, int targetSize) {
        int limit = source.limit();
        int position = source.position();
        int targetLimit = position + targetSize;
        if (targetLimit < position || targetLimit > limit) {
            LOGGER.error("targetSize: " + targetSize);
            throw new BufferUnderflowException();
        }
        try {
            source.limit(targetLimit);
            ByteBuffer target = source.slice();
            target.order(source.order());
            ByteBuffer byteBuffer = target;
            return byteBuffer;
        }
        finally {
            source.position(targetLimit);
            source.limit(limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer sliceBuffer(ByteBuffer source, int startPos, int endPos) {
        int capacity = source.capacity();
        if (startPos < 0 || endPos < startPos || endPos > capacity) {
            throw new IllegalArgumentException("startPos: " + startPos + ", endPos: " + endPos + ", capacity: " + capacity);
        }
        int limit = source.limit();
        int position = source.position();
        try {
            source.position(0);
            source.limit(endPos);
            source.position(startPos);
            ByteBuffer target = source.slice();
            target.order(source.order());
            ByteBuffer byteBuffer = target;
            return byteBuffer;
        }
        finally {
            source.limit(limit);
            source.position(position);
        }
    }

    public static ByteBuffer reverseSliceBuffer(ByteBuffer hapSigningBlock, int startPos, int endPos) {
        ByteBuffer header = HapUtils.sliceBuffer(hapSigningBlock, startPos, endPos);
        byte[] signatureBlockBytes = new byte[header.capacity()];
        header.get(signatureBlockBytes, 0, signatureBlockBytes.length);
        return ByteBuffer.wrap(Arrays.reverse(signatureBlockBytes));
    }

    public static void checkBufferLittleEndian(ByteBuffer buffer) {
        if (buffer.order() == ByteOrder.LITTLE_ENDIAN) {
            return;
        }
        throw new IllegalArgumentException("ByteBuffer is not little endian");
    }

    public static byte[] encodeListOfPairsToByteArray(List<Pair<Integer, byte[]>> pairList) {
        int encodeSize = 0;
        encodeSize += 8;
        for (Pair<Integer, byte[]> pair : pairList) {
            encodeSize += 12 + pair.getSecond().length;
        }
        ByteBuffer encodeBytes = ByteBuffer.allocate(encodeSize);
        encodeBytes.order(ByteOrder.LITTLE_ENDIAN);
        encodeBytes.putInt(2);
        encodeBytes.putInt(1);
        for (Pair<Integer, byte[]> pair : pairList) {
            byte[] second = pair.getSecond();
            encodeBytes.putInt(8 + second.length);
            encodeBytes.putInt(pair.getFirst());
            encodeBytes.putInt(second.length);
            encodeBytes.put(second);
        }
        return encodeBytes.array();
    }

    public static String toHex(byte[] value, String separator) {
        StringBuilder sb = new StringBuilder(value.length + value.length);
        String useSeparator = separator == null ? "" : separator;
        int len = value.length;
        for (int i = 0; i < len; ++i) {
            int hi = (value[i] & 0xFF) >>> 4;
            int lo = value[i] & 0xF;
            sb.append(HEX_CHAR_ARRAY[hi]).append(HEX_CHAR_ARRAY[lo]);
            if (i == len - 1) continue;
            sb.append(useSeparator);
        }
        return sb.toString();
    }

    public static HapSignBlockInfo findHapSigningBlock(ZipDataInput hap, ZipFileInfo zipInfo) throws SignatureNotFoundException, IOException {
        long centralDirectoryEndOffset;
        long centralDirectoryStartOffset = zipInfo.getCentralDirectoryOffset();
        long centralDirectorySize = zipInfo.getCentralDirectorySize();
        long eocdOffset = zipInfo.getEocdOffset();
        if (eocdOffset != (centralDirectoryEndOffset = centralDirectoryStartOffset + centralDirectorySize)) {
            throw new SignatureNotFoundException("ZIP Central Directory is not immediately followed by End of CentralDirectory. CD end: " + centralDirectoryEndOffset + ", EoCD start: " + eocdOffset);
        }
        if (centralDirectoryStartOffset < 32L) {
            throw new SignatureNotFoundException("Hap too small for Hap Signing Block. ZIP Central Directory offset: " + centralDirectoryStartOffset);
        }
        long hapSigningBlockHeaderOffset = centralDirectoryStartOffset - 32L;
        ByteBuffer hapSigningBlockHeader = hap.createByteBuffer(hapSigningBlockHeaderOffset, 32);
        hapSigningBlockHeader.order(ByteOrder.LITTLE_ENDIAN);
        int blockCount = hapSigningBlockHeader.getInt();
        long hapSigBlockSize = hapSigningBlockHeader.getLong();
        long hapSignBlockMagicLo = hapSigningBlockHeader.getLong();
        long hapSignBlockMagicHi = hapSigningBlockHeader.getLong();
        int version = hapSigningBlockHeader.getInt();
        long hapSigningBlockOffset = HapUtils.verifySignBlock(hapSigBlockSize, hapSignBlockMagicLo, hapSignBlockMagicHi, version, centralDirectoryStartOffset);
        ByteBuffer hapSigningBlockByteBuffer = hap.createByteBuffer(hapSigningBlockOffset, (int)hapSigBlockSize).order(ByteOrder.LITTLE_ENDIAN);
        LOGGER.info("Find Hap Signing Block success, version: {}, block count: {}", (Object)version, (Object)blockCount);
        return new HapSignBlockInfo(hapSigningBlockOffset, version, hapSigningBlockByteBuffer);
    }

    private static long verifySignBlock(long hapSigBlockSize, long hapSignBlockMagicLo, long hapSignBlockMagicHi, int version, long centralDirectoryStartOffset) throws SignatureNotFoundException {
        if (!HapUtils.isVersionAndMagicNumValid(version, hapSignBlockMagicLo, hapSignBlockMagicHi)) {
            throw new SignatureNotFoundException("No Hap Signing Block before ZIP Central Directory");
        }
        if (hapSigBlockSize < 32L || hapSigBlockSize > 0x7FFFFFF7L) {
            throw new SignatureNotFoundException("Hap Signing Block size out of range: " + hapSigBlockSize);
        }
        int totalSize = (int)hapSigBlockSize;
        long hapSigningBlockOffset = centralDirectoryStartOffset - (long)totalSize;
        if (hapSigningBlockOffset < 0L) {
            throw new SignatureNotFoundException("Hap Signing Block offset out of range: " + hapSigningBlockOffset);
        }
        return hapSigningBlockOffset;
    }

    private static boolean isVersionAndMagicNumValid(int version, long hapSignBlockMagicLo, long hapSignBlockMagicHi) {
        if (version < 3) {
            return hapSignBlockMagicLo == 2334950737560224072L && hapSignBlockMagicHi == 3617552046287187010L;
        }
        return hapSignBlockMagicLo == 7451613641622775868L && hapSignBlockMagicHi == 4497797983070462062L;
    }

    static {
        HAP_SIGNING_BLOCK_MAGIC_V2 = new byte[]{72, 65, 80, 32, 83, 105, 103, 32, 66, 108, 111, 99, 107, 32, 52, 50};
        HAP_SIGNING_BLOCK_MAGIC_V3 = new byte[]{60, 104, 97, 112, 32, 115, 105, 103, 110, 32, 98, 108, 111, 99, 107, 62};
        HEX_CHAR_ARRAY = "0123456789ABCDEF".toCharArray();
        HashSet<Integer> blockIds = new HashSet<Integer>();
        blockIds.add(0x20000001);
        blockIds.add(0x20000002);
        blockIds.add(0x20000003);
        HAP_SIGNATURE_OPTIONAL_BLOCK_IDS = Collections.unmodifiableSet(blockIds);
    }

    public static class HapSignBlockInfo {
        private final long offset;
        private final int version;
        private final ByteBuffer content;

        public HapSignBlockInfo(long offset, int version, ByteBuffer content) {
            this.offset = offset;
            this.version = version;
            this.content = content;
        }

        public int getVersion() {
            return this.version;
        }

        public ByteBuffer getContent() {
            return this.content;
        }

        public long getOffset() {
            return this.offset;
        }
    }
}

