/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.profile.model;

import com.google.gson.annotations.SerializedName;
import com.ohos.hapsigntool.error.ERROR;
import com.ohos.hapsigntool.utils.ValidateUtils;
import java.util.List;

public class DebugInfo {
    private static final int MAX_DEBUG_DEVICE_NUM = 100;
    @SerializedName(value="device-id-type")
    private String deviceIdType;
    @SerializedName(value="device-ids")
    private List<String> deviceIds;

    public String getDeviceIdType() {
        return this.deviceIdType;
    }

    public void setDeviceIdType(String deviceIdType) {
        this.deviceIdType = deviceIdType;
    }

    public List<String> getDeviceIds() {
        return this.deviceIds;
    }

    public void setDeviceIds(List<String> deviceIds) {
        this.deviceIds = deviceIds;
    }

    public void enforceValid() {
        if (this.deviceIds != null) {
            ValidateUtils.throwIfMatches(this.deviceIds.size() > 100, ERROR.SIGN_ERROR, "Support at most: 100 devices!");
            ValidateUtils.throwIfMatches(!this.isDeviceIdTypeValid(), ERROR.SIGN_ERROR, "Device id type must be sn or udid, current is " + this.deviceIdType);
        }
    }

    private boolean isDeviceIdTypeValid() {
        return "sn".equals(this.deviceIdType) || "udid".equals(this.deviceIdType);
    }
}

