/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.utils;

import com.ohos.hapsigntool.error.VerifyCertificateChainException;
import com.ohos.hapsigntool.utils.CertUtils;
import com.ohos.hapsigntool.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CertificateUtils {
    private CertificateUtils() {
    }

    public static void verifyCertChain(List<X509Certificate> certs) throws VerifyCertificateChainException {
        if (certs.size() <= 1) {
            return;
        }
        for (int i = 1; i < certs.size(); ++i) {
            try {
                certs.get(i - 1).verify(certs.get(i).getPublicKey());
                certs.get(i - 1).checkValidity();
                if (!certs.get(i - 1).getIssuerDN().equals(certs.get(i).getSubjectDN())) {
                    throw new CertificateException("verify certificate chain issuer subject failed");
                }
                if (i != certs.size() - 1) continue;
                certs.get(i).checkValidity();
                continue;
            }
            catch (CertificateExpiredException | CertificateNotYetValidException e) {
                throw new VerifyCertificateChainException("The certificate has expired! " + e.getMessage());
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
                throw new VerifyCertificateChainException("verify certificate chain failed! " + e.getMessage());
            }
        }
    }

    public static List<X509Certificate> getCertListFromFile(String certsFile) throws IOException, CertificateException, VerifyCertificateChainException {
        try (FileInputStream fileInputStream = FileUtils.openInputStream(new File(certsFile));){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certificates = cf.generateCertificates(fileInputStream);
            if (certificates != null && certificates.size() > 0) {
                ArrayList<? extends Certificate> certs = new ArrayList<Certificate>(certificates);
                CertUtils.sortCertificateChain(certs);
                CertificateUtils.verifyCertChain(certs);
                ArrayList<? extends Certificate> arrayList = certs;
                return arrayList;
            }
        }
        return Collections.emptyList();
    }
}

