/*
 * Decompiled with CFR 0.152.
 */
package ohos;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import ohos.BundleException;
import ohos.FileUtils;
import ohos.Log;
import ohos.ScanErrorEnum;
import ohos.ScanStatDuplicate;
import ohos.ScanStatFileSize;
import ohos.ScanStatSuffix;
import ohos.Utility;

public class Scan {
    private static final String LINUX_FILE_SEPARATOR = "/";
    private static final String EMPTY_STRING = "";
    private static final String HTML_START = "<!DOCTYPE html><html lang=\"en\">";
    private static final String HTML_END = "</html>";
    private static final String STAT_JSON = "stat.json";
    private static final String STAT_HTML = "stat.html";
    private static final String STAT_CSS = "stat.css";
    private static final String HTML_HEAD = "<head><meta charset=\"UTF-8\" name=\"stat\"><title>stat</title><link rel=\"stylesheet\" href=\"./stat.css\"></head>";
    private static final String UNPACK_NAME = "unpack";
    private static final String BACKUPS = "backups";
    private static final String HAP = ".hap";
    private static final String HSP = ".hsp";
    private static final String TEMPLATE_HTML = "ohos/scan_template.html";
    private static final String TEMPLATE_CSS = "ohos/scan_template.css";
    private static final String DIV_BOX = "<div id=\"box\">";
    private static final String HTML_BODY = "<body>";
    private static final String HTML_DIV_END = "</div>";
    private static final String HTML_BODY_END = "</body>";
    private static final String USER_DIR = "user.dir";
    private static final String HTML_BR = "<br/>";
    private static final int BUFFER_SIZE = 10240;
    private static final Log LOG = new Log(Scan.class.toString());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scanProcess(Utility utility) {
        File file = new File(utility.getOutPath());
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists() && !file2.mkdirs()) {
            LOG.error(ScanErrorEnum.SCAN_MKDIRS_ERROR.toString());
            return false;
        }
        boolean bl = true;
        try {
            this.scanExecute(utility);
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
            LOG.error((Object)((Object)ScanErrorEnum.SCAN_NOT_FOUND_ERROR) + fileNotFoundException.getMessage());
        }
        catch (IOException | NoSuchAlgorithmException | BundleException exception) {
            bl = false;
            LOG.error((Object)((Object)ScanErrorEnum.SCAN_REMIND_ERROR) + exception.getMessage());
        }
        finally {
            if (!bl) {
                LOG.error(ScanErrorEnum.SCAN_COMPRESS_ERROR.toString());
                if (!file.delete()) {
                    LOG.error(ScanErrorEnum.SCAN_DELETE_ERROR.toString());
                }
            }
        }
        return bl;
    }

    private void scanExecute(Utility utility) throws BundleException, IOException, NoSuchAlgorithmException {
        String string;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = Scan.getJsTemplate(TEMPLATE_HTML);
        string2 = string2.replace(HTML_BR, System.lineSeparator());
        String string3 = "<!DOCTYPE html><html lang=\"en\"><head><meta charset=\"UTF-8\" name=\"stat\"><title>stat</title><link rel=\"stylesheet\" href=\"./stat.css\"></head><div id=\"box\"><body>" + string2;
        String string4 = System.getProperty(USER_DIR);
        String string5 = string4 + LINUX_FILE_SEPARATOR + UNPACK_NAME;
        List<String> list = this.getAllInputFileList(utility, string5);
        if (utility.getStatDuplicate()) {
            object = new ScanStatDuplicate();
            string = ((ScanStatDuplicate)object).statDuplicate(utility, arrayList, list);
            string3 = string3 + string;
        }
        if (null != utility.getStatFileSize() && !utility.getStatFileSize().isEmpty()) {
            object = new ScanStatFileSize();
            string = ((ScanStatFileSize)object).statFileSize(utility, arrayList, list);
            string3 = string3 + string;
        }
        if (utility.getStatSuffix()) {
            object = new ScanStatSuffix();
            string = ((ScanStatSuffix)object).statSuffix(utility, arrayList, list);
            string3 = string3 + string;
        }
        if (utility.getStatDuplicate() || utility.getStatSuffix() || !EMPTY_STRING.equals(utility.getStatFileSize())) {
            string3 = string3 + HTML_DIV_END + HTML_BODY_END + HTML_END;
            object = utility.getOutPath() + LINUX_FILE_SEPARATOR + STAT_JSON;
            string = utility.getOutPath() + LINUX_FILE_SEPARATOR + STAT_HTML;
            String string6 = utility.getOutPath() + LINUX_FILE_SEPARATOR + STAT_CSS;
            Scan.writeFile((String)object, ((Object)arrayList).toString());
            Scan.writeFile(string, string3);
            String string7 = Scan.getJsTemplate(TEMPLATE_CSS);
            Scan.writeFile(string6, string7);
        }
        object = new File(string5);
        Scan.deleteFile((File)object);
    }

    private List<String> getAllInputFileList(Utility utility, String string) throws BundleException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Scan.unpackHap(utility.getInput(), string);
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            LOG.error(ScanErrorEnum.SCAN_NO_FILE_ERROR.toString());
            return arrayList;
        }
        String string2 = string + LINUX_FILE_SEPARATOR + BACKUPS;
        for (File file2 : fileArray) {
            String string3 = file2.getName();
            if (!string3.endsWith(HSP) && !string3.endsWith(HAP)) continue;
            String string4 = file2.getCanonicalPath();
            File file3 = new File(string2);
            if (!file3.exists()) {
                file3.mkdirs();
            }
            String string5 = string2 + LINUX_FILE_SEPARATOR + string3;
            File file4 = new File(string5);
            File file5 = new File(string4);
            FileUtils.copyFile(file5, file4);
            File file6 = new File(string4);
            Scan.deleteFile(file6);
            String string6 = string + LINUX_FILE_SEPARATOR + string3;
            File file7 = new File(string6);
            if (!file7.exists()) {
                file7.mkdirs();
            }
            Scan.unpackHap(string5, string6);
        }
        File file8 = new File(string2);
        Scan.deleteFile(file8);
        FileUtils.getFileList(string, arrayList);
        return arrayList;
    }

    private static void unpackHap(String string, String string2) throws BundleException {
        try (FileInputStream fileInputStream = new FileInputStream(string);
             ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(fileInputStream));){
            File file = new File(string2);
            if (!file.exists()) {
                file.mkdirs();
            }
            Scan.unpackEntryToFile(zipInputStream, string2);
        }
        catch (IOException iOException) {
            LOG.error((Object)((Object)ScanErrorEnum.SCAN_UNPACK_ERROR) + iOException.getMessage());
            throw new BundleException(ScanErrorEnum.SCAN_UNPACK_ERROR.msg + iOException.getMessage());
        }
    }

    private static void unpackEntryToFile(ZipInputStream zipInputStream, String string) throws BundleException, IOException {
        ZipEntry zipEntry;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string2 = zipEntry.getName();
            File file = new File(string, string2);
            if (zipEntry.isDirectory()) {
                file.mkdirs();
                zipInputStream.closeEntry();
                continue;
            }
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                int n;
                byte[] byArray = new byte[10240];
                while ((n = zipInputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                LOG.error((Object)((Object)ScanErrorEnum.SCAN_UNPACK_ERROR) + iOException.getMessage());
                throw new BundleException(ScanErrorEnum.SCAN_UNPACK_ERROR.msg + iOException.getMessage());
            }
            zipInputStream.closeEntry();
        }
    }

    private static void deleteFile(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                Scan.deleteFile(file2);
            }
        }
        file.delete();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getJsTemplate(String string) throws IOException {
        ClassLoader classLoader = Scan.class.getClassLoader();
        URL uRL = classLoader.getResource(string);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), StandardCharsets.UTF_8));){
            String string2;
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
            }
            String string3 = stringBuilder.toString();
            return string3;
        }
        catch (IOException iOException) {
            LOG.error((Object)((Object)ScanErrorEnum.SCAN_GET_JS_TEMPLATE_ERROR) + iOException.getMessage());
            throw new IOException(ScanErrorEnum.SCAN_GET_JS_TEMPLATE_ERROR.msg + iOException.getMessage());
        }
    }

    private static void writeFile(String string, String string2) throws IOException {
        try (FileWriter fileWriter = new FileWriter(string);){
            fileWriter.write(string2);
            fileWriter.flush();
        }
        catch (IOException iOException) {
            LOG.error((Object)((Object)ScanErrorEnum.SCAN_WRITEFILE_ERROR) + iOException.getMessage());
            throw new IOException(ScanErrorEnum.SCAN_WRITEFILE_ERROR.msg + iOException.getMessage());
        }
    }
}

