/*
 * Decompiled with CFR 0.152.
 */
package ohos;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import ohos.FileUtils;
import ohos.Log;
import ohos.ScanErrorEnum;
import ohos.Utility;

public class ScanStatFileSize {
    private static final String FILE_SIZE_FOLDER_NAME = "fileSize";
    private static final String EMPTY_STRING = "";
    private static final String FILE_SIZE_DESC = "find files whose size exceed the limit size";
    private static final String FILE_SIZE_PARAM = "--stat-file-size";
    private static final String FILE_SIZE_PARAM_SEPARATOR = " ";
    private static final String FILE_SIZE_PARAM_VALUE = "%s";
    private static final String FILE_SIZE_RESULT_SIZE = "size";
    private static final String FILE_SIZE_RESULT_FILE = "file";
    private static final String TASK_TYPE = "taskType";
    private static final String TASK_DESC = "taskDesc";
    private static final String PARAM = "param";
    private static final String START_TIME = "startTime";
    private static final String STOP_TIME = "stopTime";
    private static final String RESULT = "result";
    private static final long FILE_SIZE_TYPE = 2L;
    private static final long SHOW_SIZE = 10L;
    private static final String HTML_BUTTON_SHOW = "<button id=\"show_%s\" type=\"button\" onclick=\"show_%s()\" style=\"display: block\">more</button>";
    private static final String HTML_BUTTON_HIDE = "<button id=\"hide_%s\" type=\"button\" onclick=\"hide_%s()\" style=\"display: none\">close</button>";
    private static final String UNPACK_NAME = "unpack";
    private static final String HTML_TABLE = "<table%s>";
    private static final String HTML_TABLE_END = "</table>";
    private static final String CLASS_BOX_TABLE = " class=\"boxTable\"";
    private static final String CLASS_FILE_SIZE_TABLE = " class=\"fileSizeTable\"";
    private static final String CLASS_FILE_SIZE_LAYOUT = " class=\"fileSizeLayout\"";
    private static final String CLASS_FILE_SIZE_KEY = " class=\"fileSizeKey\"";
    private static final String CLASS_FILE_SIZE_VALUE = " class=\"fileSizeValue\"";
    private static final String CLASS_FILE_SIZE = " class=\"fileSize\"";
    private static final String HTML_TR = "<tr%s>";
    private static final String HTML_TR_END = "</tr>";
    private static final String HTML_TD = "<td%s>";
    private static final String HTML_TD_END = "</td>";
    private static final String CLASS_LAYOUT = " class=\"layout\"";
    private static final String CLASS_KEY = " class=\"key\"";
    private static final String CLASS_VALUE = " class=\"value\"";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss:SSS";
    private static final int INPUT_BYTE_SIZE = 1024;
    private static final Log LOG = new Log(ScanStatFileSize.class.toString());

    public String statFileSize(Utility utility, List<String> list, List<String> list2) {
        Object object;
        String string2;
        FileSizeResult fileSizeResult = new FileSizeResult();
        fileSizeResult.setStartTime(ScanStatFileSize.getCurrentTime());
        ArrayList<ParamModelFileSize> arrayList = new ArrayList<ParamModelFileSize>();
        for (String string2 : list2) {
            long l = Long.parseLong(utility.getStatFileSize());
            long l2 = FileUtils.getFileSize(string2);
            if (l2 <= l * 1024L) continue;
            object = new ParamModelFileSize();
            ((ParamModelFileSize)object).setFile(this.splitPath(string2, UNPACK_NAME));
            ((ParamModelFileSize)object).setSize(l2);
            arrayList.add((ParamModelFileSize)object);
        }
        arrayList.sort(Comparator.comparing(ParamModelFileSize::getSize).reversed());
        fileSizeResult.setResult(arrayList);
        fileSizeResult.setParam(String.format(fileSizeResult.getParam(), utility.getStatFileSize()));
        fileSizeResult.setStopTime(ScanStatFileSize.getCurrentTime());
        File file = new File(utility.getOutPath());
        if (!file.exists() && !file.mkdirs()) {
            LOG.error(ScanErrorEnum.SCAN_STAT_FILE_SIZE_CREATE_FILE_PARENT_ERROR.toString());
        }
        string2 = JSON.toJSONString((Object)fileSizeResult, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat);
        String string3 = ScanStatFileSize.getHtmlRow(TASK_TYPE, fileSizeResult.getTaskType());
        String string4 = ScanStatFileSize.getHtmlRow(TASK_DESC, fileSizeResult.getTaskDesc());
        String string5 = ScanStatFileSize.getHtmlRow(PARAM, fileSizeResult.getParam());
        String string6 = ScanStatFileSize.getHtmlRow(START_TIME, fileSizeResult.getStartTime());
        object = ScanStatFileSize.getHtmlRow(STOP_TIME, fileSizeResult.getStopTime());
        String string7 = ScanStatFileSize.getResultHtmlFileSize(fileSizeResult.getResult());
        String string8 = ScanStatFileSize.getHtmlRowResultClass(RESULT, string7);
        String string9 = String.format(HTML_TABLE, CLASS_BOX_TABLE) + string3 + string4 + string5 + string6 + (String)object + string8 + HTML_TABLE_END;
        list.add(string2);
        return string9;
    }

    private String splitPath(String string, String string2) {
        String[] stringArray = string.split(string2);
        if (stringArray.length > 1) {
            return stringArray[1];
        }
        return string;
    }

    private static String getResultHtmlFileSize(List<ParamModelFileSize> list) {
        StringBuilder stringBuilder = new StringBuilder(EMPTY_STRING);
        stringBuilder.append(String.format(HTML_TABLE, CLASS_FILE_SIZE_TABLE));
        String string = ScanStatFileSize.getHtmlRowResult(FILE_SIZE_RESULT_FILE, FILE_SIZE_RESULT_SIZE, CLASS_FILE_SIZE_LAYOUT, CLASS_FILE_SIZE_KEY, CLASS_FILE_SIZE_VALUE);
        stringBuilder.append(string);
        for (int i = 0; i < list.size(); ++i) {
            ParamModelFileSize paramModelFileSize = list.get(i);
            String string2 = 10L > (long)i ? ScanStatFileSize.getHtmlRowResult(paramModelFileSize.getFile(), paramModelFileSize.getSize(), CLASS_FILE_SIZE_LAYOUT, CLASS_FILE_SIZE_KEY, CLASS_FILE_SIZE_VALUE) : ScanStatFileSize.getHtmlRowResult(paramModelFileSize.getFile(), paramModelFileSize.getSize(), CLASS_FILE_SIZE, CLASS_FILE_SIZE_KEY, CLASS_FILE_SIZE_VALUE);
            stringBuilder.append(string2);
        }
        stringBuilder.append(HTML_TABLE_END);
        if ((long)list.size() > 10L) {
            stringBuilder.append(String.format(HTML_BUTTON_SHOW, FILE_SIZE_FOLDER_NAME, FILE_SIZE_FOLDER_NAME));
            stringBuilder.append(String.format(HTML_BUTTON_HIDE, FILE_SIZE_FOLDER_NAME, FILE_SIZE_FOLDER_NAME));
        }
        return stringBuilder.toString();
    }

    private static String getHtmlRow(String string, String string2) {
        return String.format(HTML_TR, CLASS_LAYOUT) + String.format(HTML_TD, CLASS_KEY) + string + HTML_TD_END + String.format(HTML_TD, CLASS_VALUE) + string2 + HTML_TD_END + HTML_TR_END;
    }

    private static String getHtmlRow(String string, long l) {
        return String.format(HTML_TR, CLASS_LAYOUT) + String.format(HTML_TD, CLASS_KEY) + string + HTML_TD_END + String.format(HTML_TD, CLASS_VALUE) + l + HTML_TD_END + HTML_TR_END;
    }

    private static String getHtmlRowResultClass(String string, String string2) {
        return String.format(HTML_TR, CLASS_LAYOUT) + String.format(HTML_TD, CLASS_KEY) + string + HTML_TD_END + String.format(HTML_TD, CLASS_VALUE) + string2 + HTML_TD_END + HTML_TR_END;
    }

    private static String getHtmlRowResult(String string, String string2, String string3, String string4, String string5) {
        return String.format("<tr%s><td%s>" + string + HTML_TD_END + HTML_TD + string2 + HTML_TD_END + HTML_TR_END, string3, string4, string5);
    }

    private static String getHtmlRowResult(String string, long l, String string2, String string3, String string4) {
        return String.format("<tr%s><td%s>" + string + HTML_TD_END + HTML_TD + l + HTML_TD_END + HTML_TR_END, string2, string3, string4);
    }

    private static String getCurrentTime() {
        long l = System.currentTimeMillis();
        return new SimpleDateFormat(DATE_FORMAT).format(l);
    }

    private static class FileSizeResult {
        private long taskType = 2L;
        private String taskDesc = "find files whose size exceed the limit size";
        private String param = "--stat-file-size %s";
        private String startTime = "";
        private String stopTime = "";
        private List<ParamModelFileSize> result = new ArrayList<ParamModelFileSize>();

        private FileSizeResult() {
        }

        public long getTaskType() {
            return this.taskType;
        }

        public void setTaskType(long l) {
            this.taskType = l;
        }

        public String getTaskDesc() {
            return this.taskDesc;
        }

        public void setTaskDesc(String string) {
            this.taskDesc = string;
        }

        public String getParam() {
            return this.param;
        }

        public void setParam(String string) {
            this.param = string;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String string) {
            this.startTime = string;
        }

        public String getStopTime() {
            return this.stopTime;
        }

        public void setStopTime(String string) {
            this.stopTime = string;
        }

        public List<ParamModelFileSize> getResult() {
            return this.result;
        }

        public void setResult(List<ParamModelFileSize> list) {
            this.result = list;
        }
    }

    private static class ParamModelFileSize {
        private String file = "";
        private long size;

        private ParamModelFileSize() {
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long l) {
            this.size = l;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String string) {
            this.file = string;
        }
    }
}

