/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.cert;

import com.ohos.hapsigntool.api.ServiceApi;
import com.ohos.hapsigntool.cert.CertLevel;
import com.ohos.hapsigntool.error.CustomException;
import com.ohos.hapsigntool.error.ERROR;
import com.ohos.hapsigntool.utils.CertUtils;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class CertBuilder {
    private static final Logger logger = LogManager.getLogger(ServiceApi.class);
    private final KeyPair keyPair;
    private final X509v3CertificateBuilder x509v3CertificateBuilder;

    public CertBuilder(KeyPair keyPair, X500Name issuer, byte[] csr, long certExpire) {
        this.keyPair = keyPair;
        LocalDateTime notBefore = LocalDateTime.now();
        LocalDateTime notAfter = notBefore.plusDays(certExpire);
        PKCS10CertificationRequest request = null;
        try {
            request = new PKCS10CertificationRequest(csr);
        }
        catch (IOException exception) {
            logger.debug(exception.getMessage(), (Throwable)exception);
            CustomException.throwException(ERROR.IO_CSR_ERROR, exception.getMessage());
        }
        this.x509v3CertificateBuilder = new X509v3CertificateBuilder(issuer, CertUtils.randomSerial(), Date.from(notBefore.atZone(ZoneId.systemDefault()).toInstant()), Date.from(notAfter.atZone(ZoneId.systemDefault()).toInstant()), request.getSubject(), request.getSubjectPublicKeyInfo());
        try {
            JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
            this.x509v3CertificateBuilder.addExtension(Extension.subjectKeyIdentifier, false, extUtils.createSubjectKeyIdentifier(request.getSubjectPublicKeyInfo()));
        }
        catch (NoSuchAlgorithmException exception) {
            logger.debug(exception.getMessage(), (Throwable)exception);
            CustomException.throwException(ERROR.NOT_SUPPORT_ERROR, exception.getMessage());
        }
        catch (CertIOException exception) {
            logger.debug(exception.getMessage(), (Throwable)exception);
            CustomException.throwException(ERROR.IO_CERT_ERROR, exception.getMessage());
        }
    }

    public CertBuilder withAuthorityKeyIdentifier(CertLevel certLevel) {
        try {
            JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
            if (certLevel == CertLevel.SUB_CA) {
                this.x509v3CertificateBuilder.addExtension(Extension.authorityKeyIdentifier, false, extUtils.createAuthorityKeyIdentifier(SubjectPublicKeyInfo.getInstance(this.keyPair.getPublic().getEncoded())));
            }
        }
        catch (NoSuchAlgorithmException exception) {
            logger.debug(exception.getMessage(), (Throwable)exception);
            CustomException.throwException(ERROR.NOT_SUPPORT_ERROR, exception.getMessage());
        }
        catch (CertIOException exception) {
            logger.debug(exception.getMessage(), (Throwable)exception);
            CustomException.throwException(ERROR.IO_CERT_ERROR, exception.getMessage());
        }
        return this;
    }

    public CertBuilder withBasicConstraints(CertLevel certLevel, boolean basicConstraintsCritical, boolean basicConstraintsCa, Integer basicConstraintsPathLen) throws CertIOException {
        BasicConstraints basicConstraints = certLevel == CertLevel.END_ENTITY ? new BasicConstraints(basicConstraintsCritical) : (basicConstraintsPathLen == null ? new BasicConstraints(basicConstraintsCa) : new BasicConstraints(basicConstraintsPathLen));
        this.x509v3CertificateBuilder.addExtension(Extension.basicConstraints, basicConstraintsCritical, basicConstraints);
        return this;
    }

    public CertBuilder withKeyUsages(KeyUsage keyUsage, boolean keyUsageCritical) throws CertIOException {
        this.x509v3CertificateBuilder.addExtension(Extension.keyUsage, keyUsageCritical, keyUsage);
        return this;
    }

    public CertBuilder withExtKeyUsages(KeyPurposeId[] extKeyUsages, boolean extKeyUsageCritical) throws CertIOException {
        if (extKeyUsages != null) {
            ExtendedKeyUsage extendedKeyUsage = new ExtendedKeyUsage(extKeyUsages);
            this.x509v3CertificateBuilder.addExtension(Extension.extendedKeyUsage, extKeyUsageCritical, extendedKeyUsage);
        }
        return this;
    }

    public CertBuilder withSigningCapabilty(byte[] signingCapabiltyBytes) throws CertIOException {
        ASN1ObjectIdentifier signingCapabiltyIdentifier = new ASN1ObjectIdentifier("1.3.6.1.4.1.2011.2.376.1.3").intern();
        this.x509v3CertificateBuilder.addExtension(signingCapabiltyIdentifier, false, signingCapabiltyBytes);
        return this;
    }

    public X509Certificate build(String signAlgorithm) {
        ContentSigner contentSigner = CertUtils.createFixedContentSigner(this.keyPair.getPrivate(), signAlgorithm);
        X509Certificate cert = null;
        try {
            cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(this.x509v3CertificateBuilder.build(contentSigner));
            cert.verify(this.keyPair.getPublic());
        }
        catch (InvalidKeyException exception) {
            logger.debug(exception.getMessage(), (Throwable)exception);
            CustomException.throwException(ERROR.KEY_ERROR, exception.getMessage());
        }
        catch (SignatureException exception) {
            logger.debug(exception.getMessage(), (Throwable)exception);
            CustomException.throwException(ERROR.SIGN_ERROR, exception.getMessage());
        }
        catch (CertificateException exception) {
            logger.debug(exception.getMessage(), (Throwable)exception);
            CustomException.throwException(ERROR.CERTIFICATE_ERROR, exception.getMessage());
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException exception) {
            logger.debug(exception.getMessage(), (Throwable)exception);
            CustomException.throwException(ERROR.NOT_SUPPORT_ERROR, exception.getMessage());
        }
        return cert;
    }
}

