/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.entity;

import com.ohos.hapsigntool.error.CustomException;
import com.ohos.hapsigntool.error.ERROR;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Options
extends HashMap<String, Object> {
    public static final String APP_CERT_FILE = "appCertFile";
    public static final String BASIC_CONSTRAINTS = "basicConstraints";
    public static final String BASIC_CONSTRAINTS_CA = "basicConstraintsCa";
    public static final String BASIC_CONSTRAINTS_CRITICAL = "basicConstraintsCritical";
    public static final String BASIC_CONSTRAINTS_PATH_LEN = "basicConstraintsPathLen";
    public static final String OUT_FORM = "outForm";
    public static final String CA_CERT_FILE = "rootCaCertFile";
    public static final String SUB_CA_CERT_FILE = "subCaCertFile";
    public static final String EXT_CFG_FILE = "extCfgFile";
    public static final String EXT_KEY_USAGE = "extKeyUsage";
    public static final String EXT_KEY_USAGE_CRITICAL = "extKeyUsageCritical";
    public static final String IN_FILE = "inFile";
    public static final String IN_FORM = "inForm";
    public static final String ISSUER = "issuer";
    public static final String ISSUER_KEY_ALIAS = "issuerKeyAlias";
    public static final String ISSUER_KEY_RIGHTS = "issuerKeyPwd";
    public static final String ISSUER_KEY_STORE_FILE = "issuerKeystoreFile";
    public static final String ISSUER_KEY_STORE_RIGHTS = "issuerKeystorePwd";
    public static final String KEY_ALG = "keyAlg";
    public static final String KEY_ALIAS = "keyAlias";
    public static final String KEY_RIGHTS = "keyPwd";
    public static final String KEY_SIZE = "keySize";
    public static final String KEY_STORE_FILE = "keystoreFile";
    public static final String KEY_STORE_RIGHTS = "keystorePwd";
    public static final String KEY_USAGE = "keyUsage";
    public static final String KEY_USAGE_CRITICAL = "keyUsageCritical";
    public static final String MODE = "mode";
    public static final String OUT_FILE = "outFile";
    public static final String OUT_CERT_CHAIN = "outCertChain";
    public static final String OUT_PROFILE = "outProfile";
    public static final String PROFILE_CERT_FILE = "profileCertFile";
    public static final String PROFILE_FILE = "profileFile";
    public static final String PROFILE_SIGNED = "profileSigned";
    public static final String SIGN_ALG = "signAlg";
    public static final String SUBJECT = "subject";
    public static final String TRUSTED_APP_SOURCE_FILE = "trustedAppSourceFile";
    public static final String TRUSTED_ROOT_CA_FILE = "trustedRootCaFile";
    public static final String VALIDITY = "validity";
    public static final String EXT_KEY_USAGE_SCOPE = "clientAuthentication,serverAuthentication,codeSignature,emailProtection,smartCardLogin,timestamp,ocspSignature";
    public static final String KEY_USAGE_SCOPE = "digitalSignature,nonRepudiation,keyEncipherment,dataEncipherment,keyAgreement,certificateSignature,crlSignature,encipherOnly,decipherOnly";
    public static final String OUT_FORM_SCOPE = "cert,certChain";
    private static final long serialVersionUID = 1L;
    private static final char[] NO_CHAR = new char[0];
    private static final Logger logger = LogManager.getLogger(Options.class);

    public void required(String ... keys) {
        for (String key : keys) {
            if (this.isEmpty(key) || this.containsKey(key)) continue;
            CustomException.throwException(ERROR.COMMAND_ERROR, String.format("Params '%s' is required", key));
        }
    }

    private boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public char[] getChars(String key) {
        Object value = this.get(key);
        if (value instanceof char[]) {
            return (char[])value;
        }
        return NO_CHAR;
    }

    public String getString(String key, String defValue) {
        Object value = this.get(key);
        if (!(value instanceof String)) {
            return defValue;
        }
        return (String)value;
    }

    public String getString(String key) {
        return this.getString(key, "");
    }

    public boolean getBoolean(String key, boolean defValue) {
        Object value = this.get(key);
        boolean result = defValue;
        if (value instanceof Boolean) {
            result = (Boolean)value;
        }
        if (value instanceof String) {
            if ("true".equalsIgnoreCase((String)value)) {
                result = true;
            }
            if ("false".equalsIgnoreCase((String)value)) {
                result = false;
            }
        }
        return result;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public int getInt(String key, int defValue) {
        Object value = this.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException exception) {
                logger.debug(exception.getMessage(), (Throwable)exception);
            }
        }
        return defValue;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }
}

