/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.hap.verify;

import com.ohos.hapsigntool.codesigning.exception.FsVerityDigestException;
import com.ohos.hapsigntool.codesigning.exception.VerifyCodeSignException;
import com.ohos.hapsigntool.codesigning.sign.VerifyCodeSignature;
import com.ohos.hapsigntool.entity.Options;
import com.ohos.hapsigntool.entity.Pair;
import com.ohos.hapsigntool.error.HapFormatException;
import com.ohos.hapsigntool.error.ProfileException;
import com.ohos.hapsigntool.error.SignatureNotFoundException;
import com.ohos.hapsigntool.hap.entity.SigningBlock;
import com.ohos.hapsigntool.hap.utils.HapUtils;
import com.ohos.hapsigntool.hap.verify.HapVerify;
import com.ohos.hapsigntool.hap.verify.VerifyResult;
import com.ohos.hapsigntool.hap.verify.VerifyUtils;
import com.ohos.hapsigntool.utils.FileUtils;
import com.ohos.hapsigntool.utils.StringUtils;
import com.ohos.hapsigntool.zip.ByteBufferZipDataInput;
import com.ohos.hapsigntool.zip.RandomAccessFileZipDataInput;
import com.ohos.hapsigntool.zip.UnsignedDecimalUtil;
import com.ohos.hapsigntool.zip.ZipDataInput;
import com.ohos.hapsigntool.zip.ZipFileInfo;
import com.ohos.hapsigntool.zip.ZipUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.util.Arrays;

public class VerifyHap {
    private static final Logger LOGGER = LogManager.getLogger(VerifyHap.class);
    private static final int ZIP_HEAD_OF_SIGNING_BLOCK_LENGTH = 32;
    private static final int ZIP_HEAD_OF_SIGNING_BLOCK_COUNT_OFFSET_REVERSE = 28;
    private static final int ZIP_HEAD_OF_SUBSIGNING_BLOCK_LENGTH = 12;
    private final boolean isPrintCert;

    public VerifyHap() {
        this(true);
    }

    public VerifyHap(boolean isPrintCert) {
        this.isPrintCert = isPrintCert;
    }

    private static String getProfileContent(byte[] profile) throws ProfileException {
        try {
            CMSSignedData cmsSignedData = new CMSSignedData(profile);
            if (!VerifyUtils.verifyCmsSignedData(cmsSignedData)) {
                throw new ProfileException("Verify profile pkcs7 failed! Profile is invalid");
            }
            Object contentObj = cmsSignedData.getSignedContent().getContent();
            if (!(contentObj instanceof byte[])) {
                throw new ProfileException("Check profile failed, signed profile content is not byte array!");
            }
            return new String((byte[])contentObj, StandardCharsets.UTF_8);
        }
        catch (CMSException e) {
            return new String(profile, StandardCharsets.UTF_8);
        }
    }

    public boolean checkParams(Options options) {
        if (!options.containsKey("outCertChain")) {
            LOGGER.error("Missing parameter: {}", (Object)"outCertChain");
            return false;
        }
        if (!options.containsKey("outProfile")) {
            LOGGER.error("Missing parameter: {}", (Object)"outProfile");
            return false;
        }
        if (!options.containsKey("outproof")) {
            LOGGER.warn("Missing parameter: {}", (Object)"outproof");
        }
        return true;
    }

    public boolean verify(Options options) {
        VerifyResult verifyResult;
        try {
            if (!this.checkParams(options)) {
                LOGGER.error("Check params failed!");
                throw new IOException();
            }
            String filePath = options.getString("inFile");
            if (StringUtils.isEmpty(filePath)) {
                LOGGER.error("Not found verify file path!");
                throw new IOException();
            }
            File signedFile = new File(filePath);
            if (!this.checkSignFile(signedFile)) {
                LOGGER.error("Check input signature hap false!");
                throw new IOException();
            }
            verifyResult = this.verifyHap(filePath);
            if (!verifyResult.isVerified()) {
                LOGGER.error("verify: {}", (Object)verifyResult.getMessage());
                throw new IOException();
            }
            String outputCertPath = options.getString("outCertChain");
            if (verifyResult.getCertificates() != null) {
                this.writeCertificate(outputCertPath, verifyResult.getCertificates());
            }
        }
        catch (IOException e) {
            LOGGER.error("Write certificate chain error", (Throwable)e);
            return false;
        }
        String outputProfileFile = options.getString("outProfile");
        String outputProofFile = options.getString("outproof");
        String outputPropertyFile = options.getString("outproperty");
        try {
            this.outputOptionalBlocks(outputProfileFile, outputProofFile, outputPropertyFile, verifyResult);
        }
        catch (IOException e) {
            LOGGER.error("Output optional blocks error", (Throwable)e);
            return false;
        }
        LOGGER.info("verify: {}", (Object)verifyResult.getMessage());
        return true;
    }

    private void writeCertificate(String destFile, List<X509Certificate> certificates) throws IOException {
        try (JcaPEMWriter writer = new JcaPEMWriter(new FileWriter(destFile));){
            for (X509Certificate cert : certificates) {
                writer.write(cert.getSubjectDN().toString() + System.lineSeparator());
                writer.writeObject(cert);
            }
            LOGGER.info("Write certificate chain success!");
        }
    }

    private void outputOptionalBlocks(String outputProfileFile, String outputProofFile, String outputPropertyFile, VerifyResult verifyResult) throws IOException {
        byte[] profile;
        List<SigningBlock> optionalBlocks = verifyResult.getOptionalBlocks();
        if (optionalBlocks != null && optionalBlocks.size() > 0) {
            block5: for (SigningBlock optionalBlock : optionalBlocks) {
                int type = optionalBlock.getType();
                switch (type) {
                    case 0x20000002: {
                        this.writeOptionalBytesToFile(optionalBlock.getValue(), outputProfileFile);
                        continue block5;
                    }
                    case 0x20000001: {
                        this.writeOptionalBytesToFile(optionalBlock.getValue(), outputProofFile);
                        continue block5;
                    }
                    case 0x20000003: {
                        this.writeOptionalBytesToFile(optionalBlock.getValue(), outputPropertyFile);
                        continue block5;
                    }
                }
                throw new IOException("Unsupported Block Id: 0x" + Long.toHexString(type));
            }
        }
        if ((profile = verifyResult.getProfile()) != null) {
            this.writeOptionalBytesToFile(profile, outputProfileFile);
        }
    }

    private void writeOptionalBytesToFile(byte[] data, String outputFile) throws IOException {
        if (outputFile == null || outputFile.isEmpty()) {
            return;
        }
        try (OutputStream out = Files.newOutputStream(Paths.get(outputFile, new String[0]), new OpenOption[0]);){
            out.write(data);
            out.flush();
        }
    }

    private boolean checkSignFile(File signedFile) {
        try {
            FileUtils.isValidFile(signedFile);
        }
        catch (IOException e) {
            LOGGER.error("signedFile is invalid.", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VerifyResult verifyHap(String hapFilePath) {
        try (RandomAccessFile fle = new RandomAccessFile(hapFilePath, "r");){
            RandomAccessFileZipDataInput hapFile = new RandomAccessFileZipDataInput(fle);
            ZipFileInfo zipInfo = ZipUtils.findZipInfo(hapFile);
            long eocdOffset = zipInfo.getEocdOffset();
            if (ZipUtils.checkZip64EoCDLocatorIsPresent(hapFile, eocdOffset)) {
                String errorMsg = "ZIP64 format not supported!";
                LOGGER.error(errorMsg);
                VerifyResult verifyResult = new VerifyResult(false, 10003, errorMsg);
                return verifyResult;
            }
            HapUtils.HapSignBlockInfo hapSigningBlockAndOffsetInFile = HapUtils.findHapSigningBlock(hapFile, zipInfo);
            ByteBuffer signingBlock = hapSigningBlockAndOffsetInFile.getContent();
            signingBlock.order(ByteOrder.LITTLE_ENDIAN);
            Pair<ByteBuffer, List<SigningBlock>> blockPair = this.getHapSignatureSchemeBlockAndOptionalBlocks(signingBlock);
            ByteBuffer signatureSchemeBlock = blockPair.getFirst();
            List<SigningBlock> optionalBlocks = blockPair.getSecond();
            Collections.reverse(optionalBlocks);
            if (!this.checkCodeSign(hapFilePath, optionalBlocks)) {
                String errMsg = "code sign verify failed";
                VerifyResult verifyResult = new VerifyResult(false, 10012, errMsg);
                return verifyResult;
            }
            HapVerify verifyEngine = this.getHapVerify(hapFile, zipInfo, hapSigningBlockAndOffsetInFile, signatureSchemeBlock, optionalBlocks);
            VerifyResult result = verifyEngine.verify();
            result.setSignBlockVersion(hapSigningBlockAndOffsetInFile.getVersion());
            return result;
        }
        catch (IOException e) {
            LOGGER.error("Verify Hap has IO error!", (Throwable)e);
            return new VerifyResult(false, 10002, e.getMessage());
        }
        catch (SignatureNotFoundException e) {
            LOGGER.error("Verify Hap failed, signature not found.", (Throwable)e);
            return new VerifyResult(false, 10008, e.getMessage());
        }
        catch (HapFormatException e) {
            LOGGER.error("Verify Hap failed, unsupported format hap.", (Throwable)e);
            return new VerifyResult(false, 10003, e.getMessage());
        }
        catch (FsVerityDigestException e) {
            LOGGER.error("Verify Hap failed, fs-verity digest generate failed.", (Throwable)e);
            return new VerifyResult(false, 10007, e.getMessage());
        }
        catch (VerifyCodeSignException e) {
            LOGGER.error("Verify Hap failed, code sign block verify failed.", (Throwable)e);
            return new VerifyResult(false, 10013, e.getMessage());
        }
        catch (CMSException e) {
            LOGGER.error("Verify Hap failed, code signature verify failed.", (Throwable)e);
            return new VerifyResult(false, 10009, e.getMessage());
        }
        catch (ProfileException e) {
            LOGGER.error("Verify Hap failed, parse app-identifier from profile failed, profile is invalid", (Throwable)e);
            return new VerifyResult(false, 10013, e.getMessage());
        }
    }

    private HapVerify getHapVerify(ZipDataInput hapFile, ZipFileInfo zipInfo, HapUtils.HapSignBlockInfo hapSigningBlockAndOffsetInFile, ByteBuffer signatureSchemeBlock, List<SigningBlock> optionalBlocks) {
        long signingBlockOffset = hapSigningBlockAndOffsetInFile.getOffset();
        ZipDataInput beforeHapSigningBlock = hapFile.slice(0L, signingBlockOffset);
        ZipDataInput centralDirectoryBlock = hapFile.slice(zipInfo.getCentralDirectoryOffset(), zipInfo.getCentralDirectorySize());
        ByteBuffer eocdBbyteBuffer = zipInfo.getEocd();
        ZipUtils.setCentralDirectoryOffset(eocdBbyteBuffer, signingBlockOffset);
        ByteBufferZipDataInput eocdBlock = new ByteBufferZipDataInput(eocdBbyteBuffer);
        HapVerify verifyEngine = new HapVerify(beforeHapSigningBlock, signatureSchemeBlock, centralDirectoryBlock, eocdBlock, optionalBlocks);
        verifyEngine.setIsPrintCert(this.isPrintCert);
        return verifyEngine;
    }

    private boolean checkCodeSign(String hapFilePath, List<SigningBlock> optionalBlocks) throws FsVerityDigestException, IOException, VerifyCodeSignException, CMSException, ProfileException {
        Map<Integer, byte[]> map = optionalBlocks.stream().collect(Collectors.toMap(SigningBlock::getType, SigningBlock::getValue));
        byte[] propertyBlockArray = map.get(0x20000003);
        if (propertyBlockArray != null && propertyBlockArray.length > 0) {
            LOGGER.info("trying verify codesign block");
            String[] fileNameArray = hapFilePath.split("\\.");
            if (fileNameArray.length < 2) {
                LOGGER.error("ZIP64 format not supported");
                return false;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(propertyBlockArray);
            ByteBuffer header = HapUtils.reverseSliceBuffer(byteBuffer, 0, 12);
            long blockOffset = UnsignedDecimalUtil.getUnsignedInt(header);
            int blockLength = header.getInt();
            int blockType = header.getInt();
            if (blockType != 0x30000001) {
                LOGGER.error("Verify Hap has no code sign data error!");
                return false;
            }
            File outputFile = new File(hapFilePath);
            String suffix = fileNameArray[fileNameArray.length - 1];
            byte[] profileArray = map.get(0x20000002);
            String profileContent = VerifyHap.getProfileContent(profileArray);
            boolean isCodeSign = VerifyCodeSignature.verifyHap(outputFile, blockOffset, blockLength, suffix, profileContent);
            if (!isCodeSign) {
                LOGGER.error("Verify Hap has no code sign data error!");
                return false;
            }
            LOGGER.info("verify codesign success");
            return true;
        }
        LOGGER.info("can not find codesign block");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<ByteBuffer, List<SigningBlock>> getHapSignatureSchemeBlockAndOptionalBlocks(ByteBuffer hapSigningBlock) throws SignatureNotFoundException {
        try {
            ByteBuffer header = HapUtils.reverseSliceBuffer(hapSigningBlock, hapSigningBlock.capacity() - 32, hapSigningBlock.capacity());
            ByteBuffer value = HapUtils.reverseSliceBuffer(hapSigningBlock, 0, hapSigningBlock.capacity() - 32);
            byte[] signatureValueBytes = new byte[value.capacity()];
            value.get(signatureValueBytes, 0, signatureValueBytes.length);
            signatureValueBytes = Arrays.reverse(signatureValueBytes);
            header.position(28);
            int blockCount = header.getInt();
            int current = value.capacity() - 12 * blockCount;
            value.position(current);
            int blockType = -1;
            int blockLength = -1;
            int blockOffset = -1;
            ByteBuffer hapSigningPkcs7Block = null;
            ArrayList<SigningBlock> optionalBlocks = new ArrayList<SigningBlock>();
            for (int i = 0; i < blockCount; ++i) {
                blockOffset = value.getInt();
                blockLength = value.getInt();
                blockType = value.getInt();
                if (blockOffset + blockLength > signatureValueBytes.length) {
                    throw new SignatureNotFoundException("block end pos: " + (blockOffset + blockLength) + " is larger than block len: " + signatureValueBytes.length);
                }
                if (HapUtils.getHapSignatureOptionalBlockIds().contains(blockType)) {
                    byte[] blockValue = Arrays.copyOfRange(signatureValueBytes, blockOffset, blockOffset + blockLength);
                    optionalBlocks.add(new SigningBlock(blockType, blockValue));
                }
                if (blockType != 0x20000000) continue;
                byte[] result = Arrays.copyOfRange(signatureValueBytes, blockOffset, blockOffset + blockLength);
                hapSigningPkcs7Block = ByteBuffer.wrap(result);
            }
            Pair pair = Pair.create(hapSigningPkcs7Block, optionalBlocks);
            return pair;
        }
        finally {
            hapSigningBlock.clear();
        }
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

