/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.utils;

import com.ohos.hapsigntool.error.CustomException;
import com.ohos.hapsigntool.error.ERROR;
import com.ohos.hapsigntool.error.VerifyCertificateChainException;
import com.ohos.hapsigntool.utils.CertificateUtils;
import com.ohos.hapsigntool.utils.StringUtils;
import com.ohos.hapsigntool.utils.ValidateUtils;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public final class CertUtils {
    private static final Logger LOGGER = LogManager.getLogger(CertUtils.class);
    private static final int MAX_LINE_LENGTH = 65;
    private static final int RANDOM_SERIAL_LENGTH = 32;
    private static final int SECOND_INDEX = 2;
    private static final String ECC = "ECDSA";
    private static final Pattern SIGN_ALGORITHM_PATTERN = Pattern.compile("^SHA([0-9]{3})with([A-Z]{1,5})$");

    private CertUtils() {
    }

    public static int parseKeyUsage(String keyUsageStr) {
        int keyUsage = 0;
        if (keyUsageStr.contains("digitalSignature")) {
            keyUsage |= 0x80;
        }
        if (keyUsageStr.contains("nonRepudiation")) {
            keyUsage |= 0x40;
        }
        if (keyUsageStr.contains("keyEncipherment")) {
            keyUsage |= 0x20;
        }
        if (keyUsageStr.contains("dataEncipherment")) {
            keyUsage |= 0x10;
        }
        if (keyUsageStr.contains("keyAgreement")) {
            keyUsage |= 8;
        }
        if (keyUsageStr.contains("certificateSignature")) {
            keyUsage |= 4;
        }
        if (keyUsageStr.contains("crlSignature")) {
            keyUsage |= 2;
        }
        if (keyUsageStr.contains("encipherOnly")) {
            keyUsage |= 1;
        }
        if (keyUsageStr.contains("decipherOnly")) {
            keyUsage |= 0x8000;
        }
        return keyUsage;
    }

    public static KeyPurposeId[] parseExtKeyUsage(String extKeyUsageStr) {
        ArrayList<KeyPurposeId> ids = new ArrayList<KeyPurposeId>();
        if (extKeyUsageStr.contains("clientAuthentication")) {
            ids.add(KeyPurposeId.id_kp_clientAuth);
        }
        if (extKeyUsageStr.contains("serverAuthentication")) {
            ids.add(KeyPurposeId.id_kp_serverAuth);
        }
        if (extKeyUsageStr.contains("codeSignature")) {
            ids.add(KeyPurposeId.id_kp_codeSigning);
        }
        if (extKeyUsageStr.contains("emailProtection")) {
            ids.add(KeyPurposeId.id_kp_emailProtection);
        }
        if (extKeyUsageStr.contains("smartCardLogin")) {
            ids.add(KeyPurposeId.id_kp_smartcardlogon);
        }
        if (extKeyUsageStr.contains("timestamp")) {
            ids.add(KeyPurposeId.id_kp_timeStamping);
        }
        if (extKeyUsageStr.contains("ocspSignature")) {
            ids.add(KeyPurposeId.id_kp_OCSPSigning);
        }
        return ids.toArray(new KeyPurposeId[0]);
    }

    public static X500Name buildDN(String nameString) {
        CertUtils.checkDN(nameString);
        X500Name dn = null;
        try {
            dn = new X500Name(nameString);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException exception) {
            LOGGER.debug(exception.getMessage(), (Throwable)exception);
            CustomException.throwException(ERROR.COMMAND_ERROR, String.format("Error params near: %s. Reason: %s", nameString, exception.getMessage()));
        }
        return dn;
    }

    private static void checkDN(String nameString) {
        String[] pairs;
        String errorMsg = String.format("Format error, must be \"X=xx,XX=xxx,...\", please check: \"%s\"", nameString);
        ValidateUtils.throwIfNotMatches(!StringUtils.isEmpty(nameString), ERROR.COMMAND_ERROR, errorMsg);
        for (String pair : pairs = nameString.split(",")) {
            ValidateUtils.throwIfNotMatches(!StringUtils.isEmpty(nameString.trim()), ERROR.COMMAND_ERROR, errorMsg);
            String[] kvPair = pair.split("=");
            ValidateUtils.throwIfNotMatches(kvPair.length == 2, ERROR.COMMAND_ERROR, errorMsg);
            ValidateUtils.throwIfNotMatches(!StringUtils.isEmpty(kvPair[1].trim()), ERROR.COMMAND_ERROR, errorMsg);
        }
    }

    public static String toCsrTemplate(byte[] csr) {
        return "-----BEGIN NEW CERTIFICATE REQUEST-----\n" + Base64.getMimeEncoder(65, "\n".getBytes(StandardCharsets.UTF_8)).encodeToString(csr) + "\n-----END NEW CERTIFICATE REQUEST-----\n";
    }

    public static String generateCertificateInCer(X509Certificate certificate) throws CertificateEncodingException {
        return "-----BEGIN CERTIFICATE-----\n" + Base64.getMimeEncoder(65, "\n".getBytes(StandardCharsets.UTF_8)).encodeToString(certificate.getEncoded()) + "\n-----END CERTIFICATE-----\n";
    }

    public static BigInteger randomSerial() {
        try {
            return new BigInteger(32, SecureRandom.getInstanceStrong());
        }
        catch (NoSuchAlgorithmException e) {
            return new BigInteger(32, new SecureRandom());
        }
    }

    public static List<X509Certificate> generateCertificates(byte[] cert) throws CertificateException, VerifyCertificateChainException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        List certificates = (List)factory.generateCertificates(new ByteArrayInputStream(cert));
        CertUtils.sortCertificateChain(certificates);
        CertificateUtils.verifyCertChain(certificates);
        return certificates;
    }

    public static void sortCertificateChain(List<X509Certificate> certificates) {
        X500Principal beforeIssuerX500Principal;
        int size;
        X500Principal lastSubjectX500Principal;
        if (certificates != null && certificates.size() > 1 && !(lastSubjectX500Principal = certificates.get((size = certificates.size()) - 1).getSubjectX500Principal()).equals(beforeIssuerX500Principal = certificates.get(size - 2).getIssuerX500Principal())) {
            Collections.reverse(certificates);
        }
    }

    public static ContentSigner createFixedContentSigner(PrivateKey privateKey, String signAlgorithm) {
        Matcher matcher = SIGN_ALGORITHM_PATTERN.matcher(signAlgorithm);
        ValidateUtils.throwIfNotMatches(matcher.matches(), ERROR.NOT_SUPPORT_ERROR, "Not Support " + signAlgorithm);
        String signAlg = signAlgorithm;
        if (privateKey instanceof ECPrivateKey && signAlgorithm.contains("RSA")) {
            signAlg = signAlgorithm.replace("RSA", ECC);
        } else if (privateKey instanceof RSAPrivateKey && signAlgorithm.contains(ECC)) {
            signAlg = signAlgorithm.replace(ECC, "RSA");
        }
        JcaContentSignerBuilder jcaContentSignerBuilder = new JcaContentSignerBuilder(signAlg);
        jcaContentSignerBuilder.setProvider("BC");
        try {
            return jcaContentSignerBuilder.build(privateKey);
        }
        catch (OperatorCreationException exception) {
            LOGGER.debug(exception.getMessage(), (Throwable)exception);
            CustomException.throwException(ERROR.OPERATOR_CREATION_ERROR, exception.getMessage());
            return null;
        }
    }
}

