/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.utils;

import com.ohos.hapsigntool.error.CustomException;
import com.ohos.hapsigntool.error.ERROR;
import com.ohos.hapsigntool.utils.CertUtils;
import com.ohos.hapsigntool.utils.FileUtils;
import com.ohos.hapsigntool.utils.StringUtils;
import com.ohos.hapsigntool.utils.ValidateUtils;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;

public class KeyStoreHelper {
    private static final String KEYSTORE_TYPE_PKCS12 = "pkcs12";
    private static final String KEYSTORE_TYPE_JKS = "jks";
    private static final String FILE_TYPE_JKS = "jks";
    private static final String FILE_TYPE_PKCS12 = "p12";
    private static final int NUM_ONE_HUNDRED = 100;
    private static final Logger logger = LogManager.getLogger(KeyStoreHelper.class);
    private final String keyStorePath;
    private final char[] keyStorePwd;
    private final KeyStore keyStore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStoreHelper(String keyStorePath, char[] storePwd) {
        FileInputStream fis;
        block6: {
            char[] pwd = storePwd;
            ValidateUtils.throwIfMatches(StringUtils.isEmpty(keyStorePath), ERROR.COMMAND_ERROR, "Missed params: 'keyStorePath'");
            if (pwd == null) {
                pwd = new char[]{};
            }
            this.keyStorePwd = pwd;
            this.keyStorePath = keyStorePath;
            this.keyStore = this.createKeyStoreAccordingFileType(keyStorePath);
            fis = null;
            try {
                if (FileUtils.isFileExist(keyStorePath)) {
                    logger.info("{} is exist. Try to load it with given passwd", (Object)keyStorePath);
                    fis = new FileInputStream(keyStorePath);
                    this.keyStore.load(fis, pwd);
                    break block6;
                }
                this.keyStore.load(null, null);
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException exception) {
                try {
                    logger.debug(exception.getMessage(), (Throwable)exception);
                    CustomException.throwException(ERROR.ACCESS_ERROR, "Init keystore failed: " + exception.getMessage() + "\nSolutions:\n> The key store file does not exist, please check the key store file path.\n> Incorrect keystore password, please input the correct plaintext password.\n> The keystore was created by a newer JDK version, please use the same JDK version");
                }
                catch (Throwable throwable) {
                    FileUtils.close(fis);
                    throw throwable;
                }
                FileUtils.close(fis);
            }
        }
        FileUtils.close(fis);
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void errorOnExist(String alias) {
        ValidateUtils.throwIfMatches(this.hasAlias(alias), ERROR.ACCESS_ERROR, String.format("Could not overwrite! Already exist '%s' in %s", alias, this.keyStorePath));
    }

    public void errorIfNotExist(String alias) {
        ValidateUtils.throwIfNotMatches(this.hasAlias(alias), ERROR.FILE_NOT_FOUND, String.format("Not exist '%s' in %s", alias, this.keyStorePath));
    }

    public boolean hasAlias(String alias) {
        try {
            return this.keyStore.containsAlias(alias);
        }
        catch (KeyStoreException exception) {
            logger.debug(exception.getMessage(), (Throwable)exception);
            CustomException.throwException(ERROR.ACCESS_ERROR, exception.getMessage());
            return false;
        }
    }

    public KeyPair loadKeyPair(String alias, char[] certPwd) {
        List<X509Certificate> certificates = this.loadCertificates(alias);
        PrivateKey privateKey = this.loadPrivateKey(alias, certPwd);
        return new KeyPair(certificates.get(0).getPublicKey(), privateKey);
    }

    public PrivateKey loadPrivateKey(String alias, char[] certPwd) {
        char[] pwd = certPwd;
        if (pwd == null) {
            pwd = new char[]{};
        }
        try {
            Key key = this.keyStore.getKey(alias, pwd);
            if (key instanceof PrivateKey) {
                return (PrivateKey)key;
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException exception) {
            logger.debug(exception.getMessage(), (Throwable)exception);
            CustomException.throwException(ERROR.ACCESS_ERROR, exception.getMessage());
        }
        catch (UnrecoverableKeyException exception) {
            logger.debug(exception.getMessage(), (Throwable)exception);
            CustomException.throwException(ERROR.ACCESS_ERROR, "Password error of '" + alias + "'");
        }
        return null;
    }

    private void putValidCert(List<X509Certificate> certificates, Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            return;
        }
        X509Certificate cert = (X509Certificate)certificate;
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException | CertificateNotYetValidException exception) {
            logger.info("p12's certificates is not valid");
        }
        certificates.add(cert);
    }

    public List<X509Certificate> loadCertificates(String alias) {
        ValidateUtils.throwIfNotMatches(this.hasAlias(alias), ERROR.FILE_NOT_FOUND, String.format("Not found '%s' in %s", alias, this.keyStorePath));
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        try {
            if (this.keyStore.isKeyEntry(alias)) {
                Certificate[] certs;
                for (Certificate certificate : certs = this.keyStore.getCertificateChain(alias)) {
                    this.putValidCert(certificates, certificate);
                }
            } else if (this.keyStore.isCertificateEntry(alias)) {
                Certificate cert = this.keyStore.getCertificate(alias);
                this.putValidCert(certificates, cert);
            }
        }
        catch (KeyStoreException exception) {
            logger.debug(exception.getMessage(), (Throwable)exception);
            CustomException.throwException(ERROR.KEYSTORE_OPERATION_ERROR, exception.getMessage());
        }
        ValidateUtils.throwIfNotMatches(certificates.size() > 0, ERROR.ACCESS_ERROR, "No usable cert found in " + this.keyStorePath);
        return certificates;
    }

    public boolean store(String alias, char[] keyPwd, KeyPair keyPair, X509Certificate[] certs) {
        Certificate[] certificates;
        this.errorOnExist(alias);
        char[] pwd = keyPwd;
        if (pwd == null) {
            pwd = new char[]{};
        }
        if ((certificates = certs) == null) {
            X509Certificate certificate = this.createKeyOnly(keyPair, alias);
            certificates = new X509Certificate[]{certificate};
        }
        try (FileOutputStream fos = new FileOutputStream(this.keyStorePath);){
            this.keyStore.setKeyEntry(alias, keyPair.getPrivate(), pwd, certificates);
            this.keyStore.store(fos, this.keyStorePwd);
            fos.flush();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            logger.debug(exception.getMessage(), (Throwable)exception);
            CustomException.throwException(ERROR.WRITE_FILE_ERROR, exception.getMessage());
            return false;
        }
        return true;
    }

    private X509Certificate createKeyOnly(KeyPair keyPair, String alias) {
        X500NameBuilder nameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        nameBuilder.addRDN(BCStyle.CN, alias);
        LocalDateTime notBefore = LocalDateTime.now();
        LocalDateTime notAfter = notBefore.plusYears(100L);
        JcaX509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(nameBuilder.build(), CertUtils.randomSerial(), Date.from(notBefore.atZone(ZoneId.systemDefault()).toInstant()), Date.from(notAfter.atZone(ZoneId.systemDefault()).toInstant()), nameBuilder.build(), keyPair.getPublic());
        ContentSigner contentSigner = CertUtils.createFixedContentSigner(keyPair.getPrivate(), "SHA256withRSA");
        try {
            return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateBuilder.build(contentSigner));
        }
        catch (CertificateException exception) {
            logger.debug(exception.getMessage(), (Throwable)exception);
            CustomException.throwException(ERROR.IO_CERT_ERROR, exception.getMessage());
            return null;
        }
    }

    private KeyStore createKeyStoreAccordingFileType(String keyFile) {
        KeyStore typeKeyStore = null;
        String type = FileUtils.getSuffix(keyFile);
        try {
            typeKeyStore = type.equalsIgnoreCase(FILE_TYPE_PKCS12) ? KeyStore.getInstance(KEYSTORE_TYPE_PKCS12) : (type.equalsIgnoreCase("jks") ? KeyStore.getInstance("jks") : KeyStore.getInstance(KeyStore.getDefaultType()));
        }
        catch (KeyStoreException exception) {
            logger.debug(exception.getMessage(), (Throwable)exception);
            CustomException.throwException(ERROR.KEYSTORE_OPERATION_ERROR, exception.getMessage());
        }
        return typeKeyStore;
    }
}

