/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.flow.handlers;

import com.ibm.streams.flow.handlers.StreamHandler;
import com.ibm.streams.operator.StreamingData;
import com.ibm.streams.operator.Tuple;
import java.util.Collection;
import java.util.LinkedList;

public class StreamCollector<C extends Collection<T>, T>
implements StreamHandler<T> {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2013, 2013    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    private final C tuples;

    public static StreamCollector<LinkedList<Tuple>, Tuple> newLinkedListCollector() {
        return new StreamCollector<LinkedList<Tuple>, Tuple>(new LinkedList());
    }

    public StreamCollector(C tuples) {
        this.tuples = tuples;
    }

    public C getTuples() {
        return this.tuples;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTupleCount() {
        C c = this.tuples;
        synchronized (c) {
            return this.getTuples().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tuple(T tuple) throws Exception {
        C c = this.tuples;
        synchronized (c) {
            this.tuples.add(tuple);
        }
    }

    @Override
    public void mark(StreamingData.Punctuation mark) throws Exception {
    }
}

