/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.flow.handlers;

import com.ibm.streams.flow.handlers.StreamHandler;
import com.ibm.streams.operator.StreamingData;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class StreamCounter<T>
implements StreamHandler<T> {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2013, 2018    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    private final Map<StreamingData.Punctuation, Long> markCounts = new EnumMap<StreamingData.Punctuation, Long>(StreamingData.Punctuation.class);
    private long tupleCount;

    public StreamCounter() {
        this.reset();
    }

    public synchronized long getTupleCount() {
        return this.tupleCount;
    }

    public synchronized long getMarkCount(StreamingData.Punctuation mark) {
        return this.markCounts.get((Object)mark);
    }

    @Override
    public synchronized void tuple(T tuple) throws Exception {
        ++this.tupleCount;
        this.notifyAll();
    }

    @Override
    public synchronized void mark(StreamingData.Punctuation mark) throws Exception {
        this.markCounts.put(mark, this.markCounts.get((Object)mark) + 1L);
    }

    public synchronized void reset() {
        this.tupleCount = 0L;
        for (StreamingData.Punctuation mark : StreamingData.Punctuation.values()) {
            this.markCounts.put(mark, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForTuples(int count, long timeout, TimeUnit unit) throws InterruptedException {
        long ems = System.currentTimeMillis() + unit.toMillis(timeout);
        StreamCounter streamCounter = this;
        synchronized (streamCounter) {
            while (this.tupleCount < (long)count) {
                long waitms = ems - System.currentTimeMillis();
                if (waitms <= 0L) {
                    return false;
                }
                this.wait(waitms);
            }
        }
        return true;
    }
}

