/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator;

import com.ibm.streams.operator.Operator;
import com.ibm.streams.operator.OperatorContext;
import com.ibm.streams.operator.OutputTuple;
import com.ibm.streams.operator.StreamingData;
import com.ibm.streams.operator.StreamingInput;
import com.ibm.streams.operator.StreamingOutput;
import com.ibm.streams.operator.Tuple;
import com.ibm.streams.operator.control.ControlPlaneContext;
import com.ibm.streams.operator.management.OperatorContextMXBean;
import com.ibm.streams.operator.management.OperatorManagement;
import com.ibm.streams.spl.messages.Message;
import com.ibm.streams.spl.messages.MessageKey;
import com.ibm.streams.spl.messages.general.StreamsSPLJavaMessagesKey;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;

public abstract class AbstractOperator
implements Operator {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2010, 2020    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    private OperatorContext context;

    @Override
    public synchronized void initialize(OperatorContext context) throws Exception {
        this.context = context;
    }

    @Override
    public void allPortsReady() throws Exception {
    }

    public final synchronized OperatorContext getOperatorContext() {
        return this.context;
    }

    @Override
    public void process(StreamingInput<Tuple> stream, Tuple tuple) throws Exception {
    }

    @Override
    public void processPunctuation(StreamingInput<Tuple> stream, StreamingData.Punctuation mark) throws Exception {
        if (mark != StreamingData.Punctuation.WINDOW_MARKER) {
            return;
        }
        for (StreamingOutput<OutputTuple> output : this.getOperatorContext().getStreamingOutputs()) {
            output.punctuate(mark);
        }
    }

    @Override
    public void shutdown() throws Exception {
    }

    @Deprecated
    public final void checkPorts(int numberInputPorts, int numberOutputPorts) {
        if (numberInputPorts >= 0) {
            if (this.getOperatorContext().getNumberOfStreamingInputs() != numberInputPorts) {
                throw new IllegalStateException(new Message((MessageKey)StreamsSPLJavaMessagesKey.Key.AO_INVALID_NUMBER_INPUT_PORTS, new Object[]{this.getClass().getName(), numberInputPorts}).getLocalizedMessageAndPrefix());
            }
        } else if (this.getOperatorContext().getNumberOfStreamingInputs() < (numberInputPorts *= -1)) {
            throw new IllegalStateException(new Message((MessageKey)StreamsSPLJavaMessagesKey.Key.AO_TOO_FEW_INPUT_PORTS, new Object[]{this.getClass().getName(), numberInputPorts}).getLocalizedMessageAndPrefix());
        }
        if (numberOutputPorts >= 0) {
            if (this.getOperatorContext().getNumberOfStreamingOutputs() != numberOutputPorts) {
                throw new IllegalStateException(new Message((MessageKey)StreamsSPLJavaMessagesKey.Key.AO_INVALID_NUMBER_OUTPUT_PORTS, new Object[]{this.getClass().getName(), numberOutputPorts}).getLocalizedMessageAndPrefix());
            }
        } else if (this.getOperatorContext().getNumberOfStreamingOutputs() < (numberOutputPorts *= -1)) {
            throw new IllegalStateException(new Message((MessageKey)StreamsSPLJavaMessagesKey.Key.AO_TOO_FEW_OUTPUT_PORTS, new Object[]{this.getClass().getName(), numberOutputPorts}).getLocalizedMessageAndPrefix());
        }
    }

    public final StreamingInput<Tuple> getInput(int port) {
        return this.getOperatorContext().getStreamingInputs().get(port);
    }

    public final StreamingOutput<OutputTuple> getOutput(int port) {
        return this.getOperatorContext().getStreamingOutputs().get(port);
    }

    public final StreamingOutput<OutputTuple> getException(int port) {
        return this.getOperatorContext().getStreamingExceptions().get(port);
    }

    public final void setLoggerAspects(String loggerName, String ... aspects) {
        this.getOperatorContext().getPE().setLoggerAspects(loggerName, aspects);
    }

    public Thread createAvoidCompletionThread() {
        return AbstractOperator.createAvoidCompletionThread(this.getOperatorContext());
    }

    public Thread createAvoidCompletionThreadIfNoInputs() {
        if (this.getOperatorContext().getNumberOfStreamingInputs() == 0) {
            return this.createAvoidCompletionThread();
        }
        return null;
    }

    public static Thread createAvoidCompletionThread(OperatorContext context) {
        final Thread avoidCompletion = context.getThreadFactory().newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        });
        avoidCompletion.setDaemon(false);
        avoidCompletion.setName(avoidCompletion.getName() + " - AvoidCompletion");
        OperatorContextMXBean ocmxb = OperatorManagement.getOperatorContextMXBean(context);
        NotificationEmitter ocne = (NotificationEmitter)((Object)ocmxb);
        ocne.addNotificationListener(new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                String type = notification.getType();
                if ("com.ibm.streams.operator.lifecycle.allPortsReady".equals(type)) {
                    avoidCompletion.start();
                } else if ("com.ibm.streams.operator.lifecycle.shutdown.notify".equals(type)) {
                    avoidCompletion.interrupt();
                }
            }
        }, null, null);
        return avoidCompletion;
    }

    public final ControlPlaneContext getControlPlaneContext() {
        ControlPlaneContext cpc = this.getOperatorContext().getOptionalContext(ControlPlaneContext.class);
        if (cpc == null) {
            throw new IllegalStateException();
        }
        return cpc;
    }

    @Override
    public void setTagData(String tagName, Map<String, String> tagValues) {
        this.getOperatorContext().getPE().setTagData(tagName, tagValues);
    }
}

