/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator;

import com.ibm.streams.operator.OptionalContext;
import com.ibm.streams.operator.OutputTuple;
import com.ibm.streams.operator.ProcessingElement;
import com.ibm.streams.operator.StreamingInput;
import com.ibm.streams.operator.StreamingOutput;
import com.ibm.streams.operator.Tuple;
import com.ibm.streams.operator.metrics.OperatorMetrics;
import com.ibm.streams.operator.state.StateHandler;
import java.io.File;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

public interface OperatorContext {
    public String getName();

    public int getNumberOfStreamingInputs();

    public List<StreamingInput<Tuple>> getStreamingInputs();

    public int getNumberOfStreamingOutputs();

    public List<StreamingOutput<OutputTuple>> getStreamingOutputs();

    public List<String> getParameterValues(String var1);

    public Set<String> getParameterNames();

    public ScheduledExecutorService getScheduledExecutorService();

    public ThreadFactory getThreadFactory();

    public ProcessingElement getPE();

    public OperatorMetrics getMetrics();

    public String getKind();

    public void addClassLibraries(String[] var1) throws MalformedURLException;

    public int getChannel();

    public int getLocalChannel();

    public List<Integer> getAllChannels();

    public int getMaxChannels();

    public int getLocalMaxChannels();

    public List<Integer> getAllMaxChannels();

    public String getLogicalName();

    public <O extends OptionalContext> O getOptionalContext(Class<O> var1);

    public void registerStateHandler(StateHandler var1);

    public File getToolkitDirectory();

    public int getNumberOfStreamingExceptions();

    public List<StreamingOutput<OutputTuple>> getStreamingExceptions();

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ContextCheck {
        public boolean compile() default true;

        public boolean runtime() default true;
    }
}

