/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator;

import com.ibm.streams.operator.StreamSchema;
import com.ibm.streams.operator.meta.CollectionType;
import com.ibm.streams.operator.meta.EnumType;
import com.ibm.streams.operator.meta.MapType;
import com.ibm.streams.operator.meta.OptionalType;
import com.ibm.streams.operator.meta.TupleType;
import com.ibm.streams.operator.meta.XMLType;
import com.ibm.streams.operator.spi.internal.TypeProvider;
import java.io.IOException;
import java.math.MathContext;
import java.net.URL;
import java.util.Random;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public interface Type {
    public MetaType getMetaType();

    public String getLanguageType();

    public Class<?> getObjectType();

    public Class<?> getAsCompositeElementType();

    public Object getDefaultValue();

    public Object randomValue(Random var1);

    public String toString(Object var1);

    public static final class Factory {
        public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2010, 2018    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";

        public static TupleType getTupleType(String tupleType) {
            return TypeProvider.provider.getTupleType(tupleType);
        }

        public static TupleType getTupleType(Source tupleTypeModel) throws TransformerFactoryConfigurationError, TransformerException, SAXException, IOException, ParserConfigurationException {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMResult dr = new DOMResult();
            transformer.transform(tupleTypeModel, dr);
            return Factory.getTupleType(dr.getNode());
        }

        public static TupleType getTupleType(Node tupleTypeModel) throws SAXException, IOException, ParserConfigurationException {
            Element tupleElement;
            URL typeModelUrl = StreamSchema.class.getResource("/com/ibm/streams/operator/internal/schema/tupleTypeModel.xsd");
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema typeModelSchema = sf.newSchema(typeModelUrl);
            Validator validator = typeModelSchema.newValidator();
            validator.validate(new DOMSource(tupleTypeModel));
            switch (tupleTypeModel.getNodeType()) {
                case 9: {
                    tupleElement = (Element)((Document)tupleTypeModel).getElementsByTagNameNS("*", "tuple").item(0);
                    break;
                }
                case 1: {
                    tupleElement = (Element)tupleTypeModel;
                    if (tupleElement.getLocalName().equals("tuple")) break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            String tupleSPL = Factory.getTupleType(tupleElement);
            return Factory.getTupleType(tupleSPL);
        }

        private static String getTupleType(Element tupleElement) throws SAXException, IOException, ParserConfigurationException {
            assert (tupleElement.getLocalName().equals("tuple"));
            StringBuilder sb = new StringBuilder();
            boolean seenFirstAttribute = false;
            sb.append("tuple<");
            NodeList attributes = tupleElement.getChildNodes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node node = attributes.item(i);
                if (node.getNodeType() != 1) continue;
                Element attr = (Element)node;
                String attributeName = attr.getAttribute("name");
                if (seenFirstAttribute) {
                    sb.append(",");
                } else {
                    seenFirstAttribute = true;
                }
                sb.append(Factory.extractType(attr, "type"));
                sb.append(" ");
                sb.append(attributeName);
            }
            sb.append(">");
            return sb.toString();
        }

        private static String extractType(Element element, String primtiveTypeName) throws SAXException, IOException, ParserConfigurationException {
            String valueType;
            String bound;
            String tagLocalName;
            String type;
            String string = type = primtiveTypeName == null ? "" : element.getAttribute(primtiveTypeName);
            if (type.length() != 0) {
                return type;
            }
            Node compositeType = null;
            NodeList childNodes = element.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i);
                if (node.getNodeType() != 1) continue;
                compositeType = (Element)node;
                break;
            }
            if ("tuple".equals(tagLocalName = compositeType.getLocalName())) {
                return Factory.getTupleType((Element)compositeType);
            }
            if ("optional".equals(tagLocalName)) {
                return "optional<" + Factory.extractType((Element)compositeType, "type") + ">";
            }
            if ("list".equals(tagLocalName)) {
                type = "list<" + Factory.extractType((Element)compositeType, "elementType") + ">";
                bound = compositeType.getAttribute("bound");
                if (bound.length() != 0) {
                    type = type + "[" + bound + "]";
                }
                return type;
            }
            if ("set".equals(tagLocalName)) {
                type = "set<" + Factory.extractType((Element)compositeType, "elementType") + ">";
                bound = compositeType.getAttribute("bound");
                if (bound.length() != 0) {
                    type = type + "[" + bound + "]";
                }
                return type;
            }
            String keyType = compositeType.getAttribute("keyType");
            if (keyType.length() == 0) {
                Element keyElement = (Element)compositeType.getElementsByTagNameNS("*", "key").item(0);
                keyType = Factory.extractType(keyElement, null);
            }
            if ((valueType = compositeType.getAttribute("valueType")).length() == 0) {
                Element valueElement = (Element)compositeType.getElementsByTagNameNS("*", "value").item(0);
                valueType = Factory.extractType(valueElement, null);
            }
            type = "map<" + keyType + "," + valueType + ">";
            String bound2 = compositeType.getAttribute("bound");
            if (bound2.length() != 0) {
                type = type + "[" + bound2 + "]";
            }
            return type;
        }

        public static StreamSchema getStreamSchema(String schema) {
            return Factory.getTupleType(schema).getTupleSchema();
        }
    }

    public static enum MetaType {
        BOOLEAN("boolean"),
        INT8("int8"){

            @Override
            public MathContext getMathContext() {
                return MathContext.UNLIMITED;
            }
        }
        ,
        INT16("int16"){

            @Override
            public MathContext getMathContext() {
                return MathContext.UNLIMITED;
            }
        }
        ,
        INT32("int32"){

            @Override
            public MathContext getMathContext() {
                return MathContext.UNLIMITED;
            }
        }
        ,
        INT64("int64"){

            @Override
            public MathContext getMathContext() {
                return MathContext.UNLIMITED;
            }
        }
        ,
        UINT8("uint8"){

            @Override
            public MathContext getMathContext() {
                return MathContext.UNLIMITED;
            }
        }
        ,
        UINT16("uint16"){

            @Override
            public MathContext getMathContext() {
                return MathContext.UNLIMITED;
            }
        }
        ,
        UINT32("uint32"){

            @Override
            public MathContext getMathContext() {
                return MathContext.UNLIMITED;
            }
        }
        ,
        UINT64("uint64"){

            @Override
            public MathContext getMathContext() {
                return MathContext.UNLIMITED;
            }
        }
        ,
        FLOAT32("float32"){

            @Override
            public MathContext getMathContext() {
                return MathContext.UNLIMITED;
            }
        }
        ,
        FLOAT64("float64"){

            @Override
            public MathContext getMathContext() {
                return MathContext.UNLIMITED;
            }
        }
        ,
        DECIMAL32("decimal32"){

            @Override
            public MathContext getMathContext() {
                return MathContext.DECIMAL32;
            }
        }
        ,
        DECIMAL64("decimal64"){

            @Override
            public MathContext getMathContext() {
                return MathContext.DECIMAL64;
            }
        }
        ,
        DECIMAL128("decimal128"){

            @Override
            public MathContext getMathContext() {
                return MathContext.DECIMAL128;
            }
        }
        ,
        COMPLEX32("complex32"){

            @Override
            public MathContext getMathContext() {
                return MathContext.UNLIMITED;
            }
        }
        ,
        COMPLEX64("complex64"){

            @Override
            public MathContext getMathContext() {
                return MathContext.UNLIMITED;
            }
        }
        ,
        TIMESTAMP("timestamp"),
        RSTRING("rstring"),
        USTRING("ustring"),
        BSTRING(null),
        BLOB("blob"),
        LIST(null, CollectionType.class),
        BLIST(null, CollectionType.class),
        SET(null, CollectionType.class),
        BSET(null, CollectionType.class),
        MAP(null, MapType.class),
        BMAP(null, MapType.class),
        OPTIONAL(null, OptionalType.class),
        TUPLE(null, TupleType.class),
        XML("xml", XMLType.class),
        ENUM(null, EnumType.class);

        private final String splType;
        private final Class<? extends Type> metaInterface;

        private MetaType(String splType) {
            this(splType, Type.class);
        }

        private MetaType(String splType, Class<? extends Type> metaInterface) {
            this.splType = splType;
            this.metaInterface = metaInterface;
        }

        public final String getLanguageType() {
            return this.splType;
        }

        public final Class<? extends Type> getMetaTypeInteface() {
            return this.metaInterface;
        }

        public final boolean isList() {
            return LIST == this || BLIST == this;
        }

        public final boolean isMap() {
            return MAP == this || BMAP == this;
        }

        public final boolean isSet() {
            return SET == this || BSET == this;
        }

        public final boolean isCollectionType() {
            return this.isList() || this.isSet() || this.isMap();
        }

        public final boolean isOptional() {
            return OPTIONAL == this;
        }

        public MathContext getMathContext() {
            return null;
        }
    }
}

