/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.control;

import java.math.BigInteger;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public final class ControlPlaneManagement {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2014, 2018    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    public static final String DOMAIN = "com.ibm.streams.control";
    public static final String RESERVED_DOMAIN = "com.ibm.streams.control.reserved";
    public static final String CONTROL_PLANE_METRIC = "controlPlaneConnection";
    public static final String JOB_CONTROL_PLANE = "com.ibm.streams.control.job.";
    public static final ObjectName MGMT_NAME;
    public static final ObjectName JOB_NAME;
    public static final ObjectName MLET_NAME;
    public static final ObjectName TIMER_NAME;

    private ControlPlaneManagement() {
    }

    public static ObjectName getPEName(BigInteger peId) {
        try {
            Hashtable<String, String> keys = new Hashtable<String, String>();
            keys.put("type", "pe");
            keys.put("id", peId.toString());
            return ObjectName.getInstance(DOMAIN, keys);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        new ControlPlaneManagement();
        try {
            MLET_NAME = ObjectName.getInstance(DOMAIN, "type", "mlet");
            TIMER_NAME = ObjectName.getInstance(DOMAIN, "type", "timer");
            MGMT_NAME = ObjectName.getInstance(DOMAIN, "type", "controlplane");
            JOB_NAME = ObjectName.getInstance(DOMAIN, "type", "job");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }
}

