/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.control;

import javax.management.AttributeChangeNotification;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;

public abstract class NotifierSupport<T>
extends NotificationBroadcasterSupport
implements MBeanRegistration {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2014, 2014    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    private ObjectName objectName;
    private MBeanServer server;
    private long sequence;
    public static final MBeanNotificationInfo ATTRIBUTE_CHANGE_INFO = new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), "Attribute changes for this MBean");

    protected NotifierSupport(MBeanNotificationInfo ... info) {
        super(info);
    }

    protected synchronized MBeanServer getServer() {
        return this.server;
    }

    protected synchronized ObjectName getObjectName() {
        return this.objectName;
    }

    protected synchronized long nextSequence() {
        return this.sequence++;
    }

    protected synchronized void sendNotification(String type) {
        this.sendNotification(new Notification(type, this, this.nextSequence()));
    }

    protected synchronized void sendNotification(String type, T userData) {
        Notification notification = new Notification(type, this, this.nextSequence());
        notification.setUserData(userData);
        this.sendNotification(notification);
    }

    protected AttributeChangeNotification sendAttributeChangeNotification(String attributeName, String attributeType, Object oldValue, Object newValue) {
        AttributeChangeNotification acn = new AttributeChangeNotification(this, this.nextSequence(), System.currentTimeMillis(), "Attribute " + attributeName + " changed from " + oldValue + " to " + newValue, attributeName, attributeType, oldValue, newValue);
        this.sendNotification(acn);
        return acn;
    }

    protected void sendBooleanAttributeChangeNotification(String attributeName, boolean newValue) {
        this.sendAttributeChangeNotification(attributeName, "Boolean", !newValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        NotifierSupport notifierSupport = this;
        synchronized (notifierSupport) {
            this.server = server;
            this.objectName = name;
        }
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }
}

