/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.control.variable;

import com.ibm.streams.operator.control.variable.AbstractControlVariable;
import com.ibm.streams.operator.control.variable.DoubleControlVariableMXBean;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.management.MBeanNotificationInfo;

public class DoubleControlVariable
extends AbstractControlVariable<Object>
implements DoubleControlVariableMXBean {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2015, 2015    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    private double value;

    public DoubleControlVariable() {
        super(new MBeanNotificationInfo[0]);
    }

    public DoubleControlVariable(double initialValue) {
        super(new MBeanNotificationInfo[0]);
        this.value = initialValue;
    }

    @Override
    public synchronized double getValue() {
        return this.value;
    }

    @Override
    public synchronized void setValue(double value) throws IOException {
        if (this.value == value) {
            return;
        }
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.putDouble(value);
        this.persistControlState(bb.array());
        this._setValue(value);
    }

    private synchronized void _setValue(double value) {
        double oldValue = this.value;
        this.value = value;
        this.sendAttributeChangeNotification("Value", "double", oldValue, value);
    }

    @Override
    public void updateControlState(byte[] controlState) {
        ByteBuffer bb = ByteBuffer.wrap(controlState);
        this._setValue(bb.getDouble());
    }
}

