/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.control.variable;

import com.ibm.streams.operator.control.variable.AbstractControlVariable;
import com.ibm.streams.operator.control.variable.LongControlVariableMXBean;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.management.MBeanNotificationInfo;

public class LongControlVariable
extends AbstractControlVariable<Object>
implements LongControlVariableMXBean {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2015, 2015    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    private long value;

    public LongControlVariable() {
        super(new MBeanNotificationInfo[0]);
    }

    public LongControlVariable(long initialValue) {
        super(new MBeanNotificationInfo[0]);
        this.value = initialValue;
    }

    @Override
    public synchronized long getValue() {
        return this.value;
    }

    @Override
    public synchronized void setValue(long value) throws IOException {
        if (this.value == value) {
            return;
        }
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.putLong(value);
        this.persistControlState(bb.array());
        this._setValue(value);
    }

    private synchronized void _setValue(long value) {
        long oldValue = this.value;
        this.value = value;
        this.sendAttributeChangeNotification("Value", "long", oldValue, value);
    }

    @Override
    public void updateControlState(byte[] controlState) {
        ByteBuffer bb = ByteBuffer.wrap(controlState);
        this._setValue(bb.getLong());
    }
}

