/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.encoding;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.streams.operator.StreamSchema;
import com.ibm.streams.operator.encoding.BinaryEncoding;
import com.ibm.streams.operator.encoding.JSONEncoding;
import com.ibm.streams.operator.encoding.JSONTupleEncoding;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class EncodingFactory {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2012, 2013    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    private static final JSONEncoding<? extends Map, ? extends List> GENERIC_JSON_ENCODING = EncodingFactory.newJSONEncoding(HashMap.class, ArrayList.class);

    private EncodingFactory() {
    }

    public static BinaryEncoding newNativeBinaryEncoding(StreamSchema schema) {
        return schema.newNativeBinaryEncoding();
    }

    public static JSONEncoding<JSONObject, JSONArray> getJSONEncoding() {
        return JSONTupleEncoding.JSON4JEncoding;
    }

    public static JSONEncoding<? extends Map, ? extends List> getGenericJSONEncoding() {
        return GENERIC_JSON_ENCODING;
    }

    public static <O extends Map, A extends List> JSONEncoding<O, A> newJSONEncoding(Class<O> jsonObjectClass, Class<A> jsonArrayClass) {
        return new JSONTupleEncoding<O, A>(jsonObjectClass, jsonArrayClass);
    }
}

