/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.encoding;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.streams.operator.Attribute;
import com.ibm.streams.operator.Tuple;
import com.ibm.streams.operator.Type;
import com.ibm.streams.operator.encoding.JSONEncoding;
import com.ibm.streams.operator.meta.CollectionType;
import com.ibm.streams.operator.meta.MapType;
import com.ibm.streams.operator.meta.OptionalType;
import com.ibm.streams.operator.types.Timestamp;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

final class JSONTupleEncoding<O extends Map, A extends List>
implements JSONEncoding<O, A> {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2012, 2018    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    static final JSONEncoding<JSONObject, JSONArray> JSON4JEncoding = new JSONTupleEncoding<JSONObject, JSONArray>(JSONObject.class, JSONArray.class);
    private final Class<O> jsonObjectClass;
    private final Class<A> jsonArrayClass;

    JSONTupleEncoding(Class<O> jsonObjectClass, Class<A> jsonArrayClass) {
        this.jsonObjectClass = jsonObjectClass;
        this.jsonArrayClass = jsonArrayClass;
        this.newJSONObject();
        this.newJSONArray();
    }

    @Override
    public O newJSONObject() {
        return (O)((Map)this.newObject(this.jsonObjectClass));
    }

    @Override
    public A newJSONArray() {
        return (A)((List)this.newObject(this.jsonArrayClass));
    }

    private <T> T newObject(Class<T> classT) {
        try {
            return classT.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Object getAttributeObject(Tuple tuple, String name) {
        return this.getAttributeObject(tuple, tuple.getStreamSchema().getAttribute(name));
    }

    @Override
    public Object getAttributeObject(Tuple tuple, Attribute attr) {
        Object value;
        int index = attr.getIndex();
        switch (attr.getType().getMetaType()) {
            case BOOLEAN: 
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT32: 
            case FLOAT64: 
            case DECIMAL32: 
            case DECIMAL64: 
            case DECIMAL128: 
            case USTRING: 
            case ENUM: {
                value = tuple.getObject(index);
                break;
            }
            case UINT8: 
            case UINT16: {
                value = tuple.getInt(index);
                break;
            }
            case UINT32: {
                value = tuple.getLong(index);
                break;
            }
            case UINT64: {
                value = new BigDecimal(tuple.getString(index)).toBigInteger();
                break;
            }
            case RSTRING: 
            case BSTRING: {
                value = tuple.getString(index);
                break;
            }
            case TUPLE: {
                value = this.encodeTuple(tuple.getTuple(index));
                break;
            }
            case TIMESTAMP: {
                value = tuple.getTimestamp(index).getTimeAsSeconds();
                break;
            }
            case MAP: 
            case BMAP: {
                MapType mt = (MapType)attr.getType();
                switch (mt.getKeyType().getMetaType()) {
                    case XML: 
                    case BLOB: 
                    case TIMESTAMP: 
                    case BLIST: 
                    case LIST: 
                    case MAP: 
                    case BMAP: 
                    case SET: 
                    case BSET: 
                    case COMPLEX32: 
                    case COMPLEX64: 
                    case TUPLE: 
                    case OPTIONAL: {
                        throw this.unsupported(mt);
                    }
                }
                value = this.jsonObjectFromMap(mt, tuple.getMap(index));
                break;
            }
            case SET: 
            case BSET: {
                CollectionType ct = (CollectionType)attr.getType();
                value = this.jsonArrayFromCollection(ct, tuple.getSet(index));
                break;
            }
            case BLIST: 
            case LIST: {
                CollectionType ct = (CollectionType)attr.getType();
                value = this.jsonArrayFromCollection(ct, tuple.getList(index));
                break;
            }
            case OPTIONAL: {
                OptionalType ot = (OptionalType)attr.getType();
                value = this.jsonObjectFromOptional(ot, tuple.getObject(index));
                break;
            }
            default: {
                throw this.unsupported(attr.getType());
            }
        }
        return value;
    }

    private O jsonObjectFromMap(MapType type, Map map) {
        O om = this.newJSONObject();
        for (Object k : map.keySet()) {
            om.put((String)k.toString(), (Object)this.jsonObjectFromElement(type.getValueType(), map.get(k)));
        }
        return om;
    }

    private A jsonArrayFromCollection(CollectionType type, Collection c) {
        A oa = this.newJSONArray();
        for (Object e : c) {
            oa.add((Object)this.jsonObjectFromElement(type.getElementType(), e));
        }
        return oa;
    }

    private Object jsonObjectFromOptional(OptionalType type, Object object) {
        Type valueType;
        if (object == null) {
            return null;
        }
        return this.jsonObjectFromElement(valueType, (valueType = type.getValueType()).getMetaType().isList() && !(object instanceof List) ? this.convertArrayToList((CollectionType)valueType, object) : object);
    }

    private List<?> convertArrayToList(CollectionType listType, Object array) {
        switch (listType.getElementType().getMetaType()) {
            case BOOLEAN: 
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT32: 
            case FLOAT64: 
            case USTRING: {
                int length = Array.getLength(array);
                ArrayList<Object> list = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    list.add(Array.get(array, i));
                }
                return list;
            }
        }
        return (List)array;
    }

    private UnsupportedOperationException unsupported(Type type) {
        return new UnsupportedOperationException(MessageFormat.format("JSON encoding not supported for {1} (MetaType.{0}))", new Object[]{type.getMetaType(), type.getLanguageType()}));
    }

    private Object jsonObjectFromElement(Type elementType, Object cv) {
        switch (elementType.getMetaType()) {
            case XML: 
            case BLOB: {
                throw this.unsupported(elementType);
            }
            case RSTRING: 
            case BSTRING: {
                return cv.toString();
            }
            case MAP: 
            case BMAP: {
                return this.jsonObjectFromMap((MapType)elementType, (Map)cv);
            }
            case BLIST: 
            case LIST: 
            case SET: 
            case BSET: {
                return this.jsonArrayFromCollection((CollectionType)elementType, (Collection)cv);
            }
            case OPTIONAL: {
                return this.jsonObjectFromOptional((OptionalType)elementType, cv);
            }
            case TIMESTAMP: {
                return ((Timestamp)cv).getTimeAsSeconds();
            }
            case TUPLE: {
                return this.encodeTuple((Tuple)cv);
            }
            case UINT8: {
                return ((Byte)cv).intValue() & 0xFF;
            }
            case UINT16: {
                return ((Short)cv).intValue() & 0xFFFF;
            }
            case UINT32: {
                return ((Integer)cv).longValue() & 0xFFFFFFFFL;
            }
            case UINT64: {
                return new BigInteger(Long.toHexString((Long)cv), 16);
            }
        }
        return cv;
    }

    @Override
    public O encodeTuple(Tuple tuple, O data) {
        this.encodeTupleAsMap(tuple, (Map)data);
        return data;
    }

    private void encodeTupleAsMap(Tuple tuple, Map data) {
        for (Attribute attr : tuple.getStreamSchema()) {
            data.put(attr.getName(), this.getAttributeObject(tuple, attr));
        }
    }

    @Override
    public final String encodeAsString(Tuple tuple) throws IOException {
        return JSON4JEncoding.encodeTuple(tuple, new JSONObject()).serialize();
    }

    @Override
    public O encodeTuple(Tuple tuple) {
        return this.encodeTuple(tuple, this.newJSONObject());
    }
}

