/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

public abstract class AbstractModel {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2013, 2013    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    private final List<AnnotationMirror> annotations = new ArrayList<AnnotationMirror>();

    public void addAnnotation(AnnotationMirror anno) {
        this.annotations.add(anno);
    }

    public void writeAsString(StringBuffer buffer) {
        for (AnnotationMirror anno : this.annotations) {
            buffer.append("\n");
            buffer.append(this.getStringRepresentation(anno));
        }
    }

    private String getStringRepresentation(AnnotationMirror anno) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("@");
        buffer.append(anno.getAnnotationType().toString());
        buffer.append("(");
        Map<? extends ExecutableElement, ? extends AnnotationValue> elements = anno.getElementValues();
        Map<String, String> additionalElements = this.addAnnotationElements(anno);
        Iterator<String> it = additionalElements.keySet().iterator();
        while (it.hasNext()) {
            String elementName = it.next();
            String elementValue = additionalElements.get(elementName);
            buffer.append(elementName);
            buffer.append('=');
            buffer.append(elementValue);
            if (!it.hasNext() && elements.isEmpty()) continue;
            buffer.append(", ");
        }
        Iterator<? extends ExecutableElement> keys = elements.keySet().iterator();
        while (keys.hasNext()) {
            ExecutableElement e = keys.next();
            AnnotationValue val = elements.get(e);
            this.getStringRepresentation(buffer, e, val, keys.hasNext());
        }
        buffer.append(")");
        return buffer.toString();
    }

    protected Map<String, String> addAnnotationElements(AnnotationMirror anno) {
        return Collections.emptyMap();
    }

    static boolean isAnnotation(AnnotationMirror anno, Class<?> annClass) {
        return anno.getAnnotationType().toString().equals(annClass.getCanonicalName());
    }

    protected final boolean containsElement(AnnotationMirror anno, String name) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> elements = anno.getElementValues();
        if (elements.isEmpty()) {
            return false;
        }
        for (ExecutableElement executableElement : elements.keySet()) {
            if (!executableElement.getSimpleName().toString().equals(name)) continue;
            return true;
        }
        return false;
    }

    private void getStringRepresentation(StringBuffer buffer, ExecutableElement e, AnnotationValue val, boolean addSpace) {
        String element = e.getSimpleName().toString();
        buffer.append(element);
        buffer.append("=");
        buffer.append(this.getStringRepresentation(val));
        if (addSpace) {
            buffer.append(", ");
        }
    }

    private String getStringRepresentation(AnnotationValue val) {
        Object obj = val.getValue();
        if (obj instanceof String) {
            return "\"" + (String)obj + "\"";
        }
        if (obj instanceof VariableElement) {
            VariableElement elem = (VariableElement)obj;
            String parent = elem.getEnclosingElement().getSimpleName().toString();
            String enumName = elem.getSimpleName().toString();
            return parent + "." + enumName;
        }
        if (obj instanceof AnnotationMirror) {
            return this.getStringRepresentation((AnnotationMirror)obj);
        }
        if (obj instanceof List) {
            List list = (List)obj;
            StringBuffer buffer = new StringBuffer();
            buffer.append("{");
            for (int i = 0; i < list.size(); ++i) {
                AnnotationValue av = (AnnotationValue)list.get(i);
                buffer.append(this.getStringRepresentation(av));
                if (i == list.size() - 1) continue;
                buffer.append(", ");
            }
            buffer.append("}");
            return buffer.toString();
        }
        return val.toString();
    }
}

