/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.internal.model;

import com.ibm.streams.operator.internal.model.AbstractModel;
import com.ibm.streams.operator.internal.model.FieldModel;
import com.ibm.streams.operator.internal.model.MethodModel;
import com.ibm.streams.operator.internal.model.processors.Util;
import com.ibm.streams.operator.model.Namespace;
import com.ibm.streams.operator.model.PrimitiveOperator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;

public class ClassModel
extends AbstractModel {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2013, 2014    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    private final String simpleBinaryName;
    private final String name;
    private final String packageName;
    private final boolean isOperatorClass;
    final String defaultNamespace;
    private final List<FieldModel> fields;
    private final List<MethodModel> methods;

    public ClassModel(ProcessingEnvironment processingEnv, PackageElement packageElement, TypeElement classElement, boolean isOperatorClass) {
        this.packageName = packageElement.getQualifiedName().toString();
        this.name = processingEnv.getElementUtils().getBinaryName(classElement).toString();
        this.simpleBinaryName = Util.getBinarySimpleName(processingEnv, classElement, packageElement);
        this.isOperatorClass = isOperatorClass;
        this.fields = new ArrayList<FieldModel>();
        this.methods = new ArrayList<MethodModel>();
        Namespace ns = packageElement.getAnnotation(Namespace.class);
        this.defaultNamespace = ns == null ? packageElement.getQualifiedName().toString() : ns.value();
    }

    public void addField(FieldModel field) {
        this.fields.add(field);
    }

    public void addMethod(MethodModel method) {
        this.methods.add(method);
    }

    @Override
    public void writeAsString(StringBuffer buffer) {
        if (this.packageName.length() > 0) {
            buffer.append("package ");
            buffer.append(this.packageName);
            buffer.append(";\n");
        }
        if (this.isOperatorClass) {
            buffer.append("import com.ibm.streams.operator.metrics.Metric.Kind;\n");
            buffer.append("import com.ibm.streams.operator.model.InputPortSet.WindowMode;\n");
            buffer.append("import com.ibm.streams.operator.model.InputPortSet.WindowPunctuationInputMode;\n");
            buffer.append("import com.ibm.streams.operator.model.OutputPortSet.WindowPunctuationOutputMode;\n");
        }
        super.writeAsString(buffer);
        buffer.append("\n");
        buffer.append("@com.ibm.streams.operator.internal.model.ShadowClass(\"");
        buffer.append(this.name);
        buffer.append("\")\n");
        buffer.append("@javax.annotation.Generated(\"com.ibm.streams.operator.internal.model.processors.ShadowClassGenerator\")\n");
        buffer.append("public class ");
        buffer.append(this.simpleBinaryName);
        buffer.append("$StreamsModel");
        if (this.isOperatorClass) {
            buffer.append(" extends com.ibm.streams.operator.AbstractOperator\n");
        }
        buffer.append(" {\n");
        for (FieldModel field : this.fields) {
            field.writeAsString(buffer);
            buffer.append("\n");
        }
        for (MethodModel method : this.methods) {
            method.writeAsString(buffer);
            buffer.append("\n");
        }
        buffer.append("}");
    }

    @Override
    protected Map<String, String> addAnnotationElements(AnnotationMirror anno) {
        HashMap<String, String> additionalElements = new HashMap<String, String>();
        this.addDefaultNamespace(anno, PrimitiveOperator.class, additionalElements);
        return additionalElements;
    }

    final void addDefaultNamespace(AnnotationMirror anno, Class<?> annotationClass, Map<String, String> additionalElements) {
        if (ClassModel.isAnnotation(anno, annotationClass) && !this.containsElement(anno, "namespace")) {
            additionalElements.put("namespace", "\"" + this.defaultNamespace + "\"");
        }
    }
}

