/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.internal.model;

import com.ibm.streams.function.model.Function;
import com.ibm.streams.operator.internal.model.AbstractModel;
import com.ibm.streams.operator.internal.model.ClassModel;
import com.ibm.streams.operator.internal.model.MethodParameterModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;

public class MethodModel
extends AbstractModel {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2013, 2015    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    private final ClassModel classModel;
    private final String name;
    private final String returnType;
    private final boolean isPrimitiveReturnType;
    private final List<MethodParameterModel> parameters;
    private final boolean isStatic;

    public MethodModel(ClassModel classModel, String name, String returnType, boolean isPrimitiveReturnType, boolean isStatic) {
        this.classModel = classModel;
        this.name = name;
        this.returnType = returnType;
        this.isPrimitiveReturnType = isPrimitiveReturnType;
        this.isStatic = isStatic;
        this.parameters = new ArrayList<MethodParameterModel>();
    }

    public void addParameter(MethodParameterModel param) {
        this.parameters.add(param);
    }

    @Override
    public void writeAsString(StringBuffer buffer) {
        int i;
        super.writeAsString(buffer);
        buffer.append("\n");
        buffer.append("@com.ibm.streams.operator.internal.model.MethodParameters({");
        for (i = 0; i < this.parameters.size(); ++i) {
            buffer.append("\"" + this.parameters.get((int)i).name + "\"");
            if (i >= this.parameters.size() - 1) continue;
            buffer.append(", ");
        }
        buffer.append("})\n");
        buffer.append("public ");
        if (this.isStatic) {
            buffer.append("static ");
        }
        buffer.append(this.returnType);
        buffer.append(" ");
        buffer.append(this.name);
        buffer.append("(");
        for (i = 0; i < this.parameters.size(); ++i) {
            MethodParameterModel param = this.parameters.get(i);
            param.writeAsString(buffer);
            if (i >= this.parameters.size() - 1) continue;
            buffer.append(", ");
        }
        buffer.append(") {");
        if (this.returnType.equals("void")) {
            buffer.append("}");
        } else if (this.isPrimitiveReturnType) {
            if (this.returnType.equals("boolean")) {
                buffer.append("return false; }");
            } else {
                buffer.append("return 0; }");
            }
        } else {
            buffer.append("return null; }");
        }
    }

    @Override
    protected Map<String, String> addAnnotationElements(AnnotationMirror anno) {
        HashMap<String, String> additionalElements = new HashMap<String, String>();
        this.classModel.addDefaultNamespace(anno, Function.class, additionalElements);
        return additionalElements;
    }
}

