/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.internal.model.processors;

import com.ibm.streams.operator.internal.model.processors.Util;
import com.ibm.streams.operator.model.Namespace;
import com.ibm.streams.spl.messages.Message;
import com.ibm.streams.spl.messages.MessageKey;
import com.ibm.streams.spl.messages.general.StreamsSPLJavaMessagesKey;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

abstract class AbstractModelProcessor
extends AbstractProcessor {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2013, 2018    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";

    AbstractModelProcessor() {
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                this.validateElement(typeElement, element);
            }
        }
        return false;
    }

    protected abstract void validateElement(TypeElement var1, Element var2);

    protected void validateNonStatic(TypeElement annotation, Element e) {
        if (e.getModifiers().contains((Object)Modifier.STATIC)) {
            this.simpleError(annotation, e, StreamsSPLJavaMessagesKey.Key.AMP_INSTANCE);
        }
    }

    protected void validateStatic(TypeElement annotation, Element e) {
        if (!e.getModifiers().contains((Object)Modifier.STATIC)) {
            this.simpleError(annotation, e, StreamsSPLJavaMessagesKey.Key.AMP_STATIC);
        }
    }

    protected void validateVoid(TypeElement annotation, ExecutableElement e) {
        if (e.getReturnType().getKind() != TypeKind.VOID) {
            this.simpleError(annotation, e, StreamsSPLJavaMessagesKey.Key.AMP_VOID);
        }
    }

    protected void validatePublic(TypeElement annotation, Element e) {
        if (!e.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.simpleError(annotation, e, StreamsSPLJavaMessagesKey.Key.AMP_PUBLIC);
        }
    }

    protected void validateNonAbstract(TypeElement annotation, Element e) {
        if (e.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.simpleError(annotation, e, StreamsSPLJavaMessagesKey.Key.AMP_CONCRETE);
        }
    }

    protected void validateSetter(TypeElement annotation, ExecutableElement method) {
        this.validateNonStatic(annotation, method);
        this.validateVoid(annotation, method);
        if (method.getParameters().size() != 1) {
            this.simpleError(annotation, method, StreamsSPLJavaMessagesKey.Key.AMP_SETTER);
        }
    }

    protected void simpleError(TypeElement annotation, Element e, StreamsSPLJavaMessagesKey.Key msgKey) {
        this.error(annotation, e, msgKey, annotation.getSimpleName(), e.getSimpleName());
    }

    protected void error(TypeElement annotation, Element e, StreamsSPLJavaMessagesKey.Key msgKey, Object ... msgArguments) {
        if (msgArguments == null) {
            msgArguments = new Object[]{""};
        }
        String msg = new Message((MessageKey)msgKey, msgArguments).getLocalizedMessageAndPrefix();
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e, AbstractModelProcessor.getAnnotationMirror(e, annotation));
    }

    static AnnotationMirror getAnnotationMirror(Element e, TypeElement annotation) {
        for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().asElement().equals(annotation)) continue;
            return annotationMirror;
        }
        return null;
    }

    protected boolean isAnnotationType(TypeElement annotation, Class<?> annotationClass) {
        return annotation.getQualifiedName().toString().equals(annotationClass.getCanonicalName());
    }

    protected boolean isTypeClassType(TypeMirror type, Class<?> ... classTypes) {
        if (type.getKind() != TypeKind.DECLARED) {
            return false;
        }
        for (Class<?> classType : classTypes) {
            if (!this.processingEnv.getTypeUtils().isSameType(type, this.getClassTypeMirror(classType))) continue;
            return true;
        }
        return false;
    }

    protected TypeMirror getClassTypeMirror(Class<?> type) {
        return this.processingEnv.getElementUtils().getTypeElement(type.getCanonicalName()).asType();
    }

    protected void validateSPLName(TypeElement annotation, Element element, String name) {
        if (name.length() == 0) {
            name = element.getSimpleName().toString();
        }
        if (!Util.isSPLIdentifier(name) || Util.isReservedDir(name) || Util.isRestrictedKeyword(name)) {
            this.simpleError(annotation, element, StreamsSPLJavaMessagesKey.Key.AMP_SPLID);
        }
    }

    protected void validateDefinedSPLNamespace(TypeElement annotation, Element element, String namespace) {
        if (namespace.length() == 0) {
            PackageElement pkg = this.processingEnv.getElementUtils().getPackageOf(element);
            if (pkg.getAnnotation(Namespace.class) != null) {
                return;
            }
            namespace = pkg.getQualifiedName().toString();
        }
        this.validateSPLNamespace(annotation, element, namespace);
    }

    protected void validateSPLNamespace(TypeElement annotation, Element element, String namespace) {
        if (namespace != null && namespace.length() != 0) {
            String[] sections;
            for (String token : sections = namespace.split("\\.", -1)) {
                if (token.length() != 0 && Util.isSPLIdentifier(token) && !Util.isReservedDir(token) && !Util.isRestrictedKeyword(token)) continue;
                this.error(annotation, element, StreamsSPLJavaMessagesKey.Key.AMP_SPLNS, annotation.getSimpleName(), namespace);
            }
        }
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }
}

