/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.internal.model.processors;

import com.ibm.streams.operator.internal.model.processors.AbstractModelProcessor;
import com.ibm.streams.operator.internal.model.processors.Util;
import com.ibm.streams.operator.model.DefaultAttribute;
import com.ibm.streams.operator.model.Parameter;
import com.ibm.streams.spl.messages.general.StreamsSPLJavaMessagesKey;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;

@SupportedAnnotationTypes(value={"com.ibm.streams.operator.model.DefaultAttribute"})
public class DefaultAttributeVerifier
extends AbstractModelProcessor {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2015, 2018    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";

    @Override
    protected void validateElement(TypeElement annotation, Element e) {
        assert (e.getKind() == ElementKind.METHOD);
        if (e.getAnnotation(Parameter.class) == null) {
            this.simpleError(annotation, e, StreamsSPLJavaMessagesKey.Key.PV_DEFAULTATTRIBUTE_NOPARAM);
            return;
        }
        ExecutableElement method = (ExecutableElement)e;
        this.validateSetterParameter(annotation, method);
        this.validateAttributeName(annotation, method);
    }

    private void validateAttributeName(TypeElement annotation, ExecutableElement method) {
        String value = method.getAnnotation(DefaultAttribute.class).value();
        if (value.length() == 0 || !Util.isSPLIdentifier(value) || Util.isRestrictedKeyword(value)) {
            this.error(annotation, method, StreamsSPLJavaMessagesKey.Key.PV_DEFAULTATTRIBUTE_INVALIDVALUE, annotation.getSimpleName(), value);
        }
    }

    private void validateSetterParameter(TypeElement annotation, ExecutableElement method) {
        VariableElement pve = method.getParameters().get(0);
        switch (pve.asType().getKind()) {
            case DECLARED: {
                Element typeElem = ((DeclaredType)pve.asType()).asElement();
                if (typeElem.getKind() != ElementKind.INTERFACE || !this.isAttribute(pve.asType())) break;
                return;
            }
        }
        this.error(annotation, method, StreamsSPLJavaMessagesKey.Key.FV_TYPE, annotation.getSimpleName(), method.getSimpleName(), pve.asType().toString());
    }

    private boolean isAttribute(TypeMirror type) {
        DeclaredType infoElemWildCard = this.getTupleAttributeTypeMirror();
        if (infoElemWildCard != null) {
            return this.processingEnv.getTypeUtils().isAssignable(type, infoElemWildCard);
        }
        return false;
    }

    private DeclaredType getTupleAttributeTypeMirror() {
        TypeElement infoElement = this.processingEnv.getElementUtils().getTypeElement("com.ibm.streams.operator.TupleAttribute");
        WildcardType wildCard = this.processingEnv.getTypeUtils().getWildcardType(null, null);
        DeclaredType infoElemWildCard = this.processingEnv.getTypeUtils().getDeclaredType(infoElement, wildCard, wildCard);
        return infoElemWildCard;
    }
}

