/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.internal.model.processors;

import com.ibm.streams.function.model.Function;
import com.ibm.streams.operator.internal.model.processors.AbstractModelProcessor;
import com.ibm.streams.spl.messages.general.StreamsSPLJavaMessagesKey;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

@SupportedAnnotationTypes(value={"com.ibm.streams.function.model.Function"})
public class FunctionVerifier
extends AbstractModelProcessor {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2013, 2018    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";

    @Override
    protected void validateElement(TypeElement annotation, Element e) {
        assert (e.getKind() == ElementKind.METHOD);
        ExecutableElement method = (ExecutableElement)e;
        this.validatePublic(annotation, method);
        this.validateStatic(annotation, method);
        if (method.isVarArgs()) {
            this.simpleError(annotation, e, StreamsSPLJavaMessagesKey.Key.FV_VARARGS);
        }
        for (VariableElement variableElement : method.getParameters()) {
            this.validateFunctionParameter(annotation, method, variableElement);
        }
        if (method.getReturnType().getKind() != TypeKind.VOID) {
            this.validateFunctionType(annotation, method, method.getReturnType());
        }
        Function function = e.getAnnotation(Function.class);
        this.validateSPLName(annotation, e, function.name());
        this.validateDefinedSPLNamespace(annotation, e, function.namespace());
    }

    private void validateFunctionParameter(TypeElement annotation, ExecutableElement method, VariableElement pve) {
        this.validateFunctionType(annotation, method, pve.asType());
    }

    private void validateFunctionType(TypeElement annotation, ExecutableElement method, TypeMirror type) {
        block0 : switch (type.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return;
            }
            case DECLARED: {
                if (!this.isTypeClassType(type, String.class)) break;
                return;
            }
            case ARRAY: {
                ArrayType at = (ArrayType)type;
                switch (at.getComponentType().getKind()) {
                    case BOOLEAN: 
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return;
                    }
                    case DECLARED: {
                        if (!this.isTypeClassType(at.getComponentType(), String.class)) break block0;
                        return;
                    }
                }
                break;
            }
        }
        this.error(annotation, method, StreamsSPLJavaMessagesKey.Key.FV_TYPE, annotation.getSimpleName(), method.getSimpleName(), type.toString());
    }
}

