/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.internal.model.processors;

import com.ibm.streams.operator.internal.model.processors.AbstractModelProcessor;
import com.ibm.streams.operator.model.DefaultAttribute;
import com.ibm.streams.operator.model.Parameter;
import com.ibm.streams.spl.messages.general.StreamsSPLJavaMessagesKey;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;

@SupportedAnnotationTypes(value={"com.ibm.streams.operator.model.Parameter"})
public class ParameterVerifier
extends AbstractModelProcessor {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2013, 2018    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";

    @Override
    protected void validateElement(TypeElement annotation, Element e) {
        assert (e.getKind() == ElementKind.METHOD);
        ExecutableElement method = (ExecutableElement)e;
        this.validatePublic(annotation, method);
        this.validateSetter(annotation, method);
        this.validateSetterParameter(annotation, method);
        this.validateSPLName(annotation, e, e.getAnnotation(Parameter.class).name());
        this.validateOptionalAttribute(annotation, method);
    }

    private void validateOptionalAttribute(TypeElement annotation, ExecutableElement method) {
        if (this.isDefaultAttributeAnnotationPresent(method)) {
            this.enforceSingleCardinality(annotation, method, StreamsSPLJavaMessagesKey.Key.PV_DEFAULTATTRIBUTE_SINGLE);
            AnnotationMirror mirror = ParameterVerifier.getAnnotationMirror(method, annotation);
            for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
                AnnotationValue value;
                boolean isOptional;
                if (!executableElement.getSimpleName().contentEquals("optional") || (isOptional = ((Boolean)(value = mirror.getElementValues().get(executableElement)).getValue()).booleanValue())) continue;
                this.simpleError(annotation, method, StreamsSPLJavaMessagesKey.Key.PV_OPTIONAL);
            }
        }
    }

    private boolean isDefaultAttributeAnnotationPresent(ExecutableElement method) {
        DefaultAttribute defaultAttr = method.getAnnotation(DefaultAttribute.class);
        return defaultAttr != null;
    }

    private void enforceSingleCardinality(TypeElement annotation, ExecutableElement method) {
        this.enforceSingleCardinality(annotation, method, StreamsSPLJavaMessagesKey.Key.PV_SINGLE);
    }

    private void enforceSingleCardinality(TypeElement annotation, ExecutableElement method, StreamsSPLJavaMessagesKey.Key keyString) {
        AnnotationMirror mirror = ParameterVerifier.getAnnotationMirror(method, annotation);
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            if (!executableElement.getSimpleName().contentEquals("cardinality")) continue;
            this.simpleError(annotation, method, keyString);
        }
    }

    private void verifyMultiCardinality(TypeElement annotation, ExecutableElement method) {
        AnnotationMirror mirror = ParameterVerifier.getAnnotationMirror(method, annotation);
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            if (!executableElement.getSimpleName().contentEquals("cardinality")) continue;
            AnnotationValue value = mirror.getElementValues().get(executableElement);
            int cardinality = (Integer)value.getValue();
            if (cardinality == -1 || cardinality > 1) {
                return;
            }
            this.simpleError(annotation, method, StreamsSPLJavaMessagesKey.Key.PV_CARDINALITY);
        }
    }

    private void validateSetterParameter(TypeElement annotation, ExecutableElement method) {
        VariableElement pve = method.getParameters().get(0);
        block0 : switch (pve.asType().getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                this.enforceSingleCardinality(annotation, method);
                return;
            }
            case DECLARED: {
                DeclaredType dType;
                Element typeElem = ((DeclaredType)pve.asType()).asElement();
                if (typeElem.getKind() == ElementKind.ENUM || this.isTypeClassType(pve.asType(), String.class, BigDecimal.class, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class)) {
                    this.enforceSingleCardinality(annotation, method);
                    return;
                }
                if (typeElem.getKind() == ElementKind.INTERFACE && this.isAttribute(pve.asType()) && this.isValidAttributeType(dType = (DeclaredType)pve.asType())) {
                    this.enforceSingleCardinality(annotation, method);
                    return;
                }
                TypeElement list = this.processingEnv.getElementUtils().getTypeElement("java.util.List");
                DeclaredType listString = this.processingEnv.getTypeUtils().getDeclaredType(list, this.getClassTypeMirror(String.class));
                if (this.processingEnv.getTypeUtils().isSameType(pve.asType(), listString)) {
                    this.verifyMultiCardinality(annotation, method);
                    return;
                }
                DeclaredType listDecimal = this.processingEnv.getTypeUtils().getDeclaredType(list, this.getClassTypeMirror(BigDecimal.class));
                if (this.processingEnv.getTypeUtils().isSameType(pve.asType(), listDecimal)) {
                    this.verifyMultiCardinality(annotation, method);
                    return;
                }
                DeclaredType type = (DeclaredType)pve.asType();
                DeclaredType rawType = this.processingEnv.getTypeUtils().getDeclaredType((TypeElement)type.asElement(), new TypeMirror[0]);
                if (!rawType.toString().equals("java.util.List")) break;
                for (TypeMirror typeMirror : type.getTypeArguments()) {
                    DeclaredType dType2;
                    if (!this.processingEnv.getTypeUtils().isAssignable(typeMirror, this.getTupleAttributeTypeMirror()) || !this.isValidAttributeType(dType2 = (DeclaredType)typeMirror)) continue;
                    this.verifyMultiCardinality(annotation, method);
                    return;
                }
                break;
            }
            case ARRAY: {
                ArrayType at = (ArrayType)pve.asType();
                switch (at.getComponentType().getKind()) {
                    case BOOLEAN: 
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        this.verifyMultiCardinality(annotation, method);
                        return;
                    }
                    case DECLARED: {
                        if (!this.isAttribute(at.getComponentType()) && !this.isTypeClassType(at.getComponentType(), String.class, BigDecimal.class)) break block0;
                        this.verifyMultiCardinality(annotation, method);
                        return;
                    }
                }
                break;
            }
        }
        this.error(annotation, method, StreamsSPLJavaMessagesKey.Key.FV_TYPE, annotation.getSimpleName(), method.getSimpleName(), pve.asType().toString());
    }

    private boolean isValidAttributeType(DeclaredType dType) {
        TypeMirror type;
        List<? extends TypeMirror> list = dType.getTypeArguments();
        return list.size() == 2 && (this.isTypeClassType(type = list.get(1), String.class, BigDecimal.class, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class) || type instanceof WildcardType);
    }

    private boolean isAttribute(TypeMirror type) {
        DeclaredType infoElemWildCard = this.getTupleAttributeTypeMirror();
        if (infoElemWildCard != null) {
            return this.processingEnv.getTypeUtils().isAssignable(type, infoElemWildCard);
        }
        return false;
    }

    private DeclaredType getTupleAttributeTypeMirror() {
        TypeElement infoElement = this.processingEnv.getElementUtils().getTypeElement("com.ibm.streams.operator.TupleAttribute");
        WildcardType wildCard = this.processingEnv.getTypeUtils().getWildcardType(null, null);
        DeclaredType infoElemWildCard = this.processingEnv.getTypeUtils().getDeclaredType(infoElement, wildCard, wildCard);
        return infoElemWildCard;
    }
}

