/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.internal.model.processors;

import com.ibm.streams.operator.model.InputPortSet;
import com.ibm.streams.operator.model.InputPorts;
import com.ibm.streams.operator.model.OutputPortSet;
import com.ibm.streams.operator.model.OutputPorts;
import com.ibm.streams.spl.messages.Message;
import com.ibm.streams.spl.messages.MessageKey;
import com.ibm.streams.spl.messages.general.StreamsSPLJavaMessagesKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.ibm.streams.operator.model.InputPorts", "com.ibm.streams.operator.model.InputPortSet", "com.ibm.streams.operator.model.OutputPorts", "com.ibm.streams.operator.model.OutputPortSet"})
public class PortAnnotationsProcessor
extends AbstractProcessor {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2013, 2018    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            for (Element element : roundEnv.getRootElements()) {
                AnnotationMirror inputPortAnnotationMirror;
                List values;
                Map<? extends ExecutableElement, ? extends AnnotationValue> map;
                ArrayList<String> ids = new ArrayList<String>();
                ArrayList<AnnotationMirror> outputAnnotationList = new ArrayList<AnnotationMirror>();
                List<? extends AnnotationMirror> annoMirrors = this.processingEnv.getElementUtils().getAllAnnotationMirrors(element);
                for (AnnotationMirror annotationMirror : annoMirrors) {
                    if (this.isAnnotationType(annotationMirror, OutputPorts.class)) {
                        boolean isOpenOutputPortSeen = false;
                        map = annotationMirror.getElementValues();
                        for (AnnotationValue annotationValue : map.values()) {
                            values = (List)annotationValue.getValue();
                            for (AnnotationValue value : values) {
                                inputPortAnnotationMirror = (AnnotationMirror)value.getValue();
                                boolean isOpenOutputPort = this.addToOutputIdList(element, outputAnnotationList, inputPortAnnotationMirror);
                                if (isOpenOutputPort && isOpenOutputPortSeen) {
                                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, new Message((MessageKey)StreamsSPLJavaMessagesKey.Key.PAP_OUTPUT_CARDINALITY_REQUIRED, new Object[]{""}).getLocalizedMessage(), element, inputPortAnnotationMirror);
                                    continue;
                                }
                                isOpenOutputPortSeen = isOpenOutputPort;
                            }
                        }
                        continue;
                    }
                    if (!this.isAnnotationType(annotationMirror, OutputPortSet.class)) continue;
                    this.addToOutputIdList(element, outputAnnotationList, annotationMirror);
                }
                for (AnnotationMirror annotationMirror : annoMirrors) {
                    if (this.isAnnotationType(annotationMirror, InputPorts.class)) {
                        boolean isOpenInputPortSeen = false;
                        map = annotationMirror.getElementValues();
                        for (AnnotationValue annotationValue : map.values()) {
                            values = (List)annotationValue.getValue();
                            for (AnnotationValue value : values) {
                                inputPortAnnotationMirror = (AnnotationMirror)value.getValue();
                                boolean isOpenInputPort = this.checkAndAddToInputIdList(element, ids, inputPortAnnotationMirror);
                                if (isOpenInputPort && isOpenInputPortSeen) {
                                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, new Message((MessageKey)StreamsSPLJavaMessagesKey.Key.PAP_INPUT_CARDINALITY_REQUIRED, new Object[]{""}).getLocalizedMessage(), element, inputPortAnnotationMirror);
                                    continue;
                                }
                                isOpenInputPortSeen = isOpenInputPort;
                            }
                        }
                        continue;
                    }
                    if (!this.isAnnotationType(annotationMirror, InputPortSet.class)) continue;
                    this.checkAndAddToInputIdList(element, ids, annotationMirror);
                }
                for (AnnotationMirror annotationMirror : outputAnnotationList) {
                    Map<? extends ExecutableElement, ? extends AnnotationValue> map2 = annotationMirror.getElementValues();
                    for (ExecutableElement executableElement : map2.keySet()) {
                        AnnotationValue annotationValue;
                        String id;
                        if (!executableElement.getSimpleName().toString().equals("windowPunctuationInputPort") || ids.contains(id = (String)(annotationValue = map2.get(executableElement)).getValue())) continue;
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, new Message((MessageKey)StreamsSPLJavaMessagesKey.Key.PAP_INVALID_PUNCTUATION_INPUT_PORT, new Object[]{id}).getLocalizedMessage(), element, annotationMirror);
                    }
                }
                if (element.getAnnotation(InputPorts.class) != null && element.getAnnotation(InputPortSet.class) != null) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, new Message((MessageKey)StreamsSPLJavaMessagesKey.Key.PAP_INVALID_INPUT_PORTS, new Object[]{""}).getLocalizedMessage(), element, this.getAnnotationMirror(element, InputPortSet.class, InputPorts.class));
                }
                if (element.getAnnotation(OutputPorts.class) == null || element.getAnnotation(OutputPortSet.class) == null) continue;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, new Message((MessageKey)StreamsSPLJavaMessagesKey.Key.PAP_INVALID_OUTPUT_PORTS, new Object[]{""}).getLocalizedMessage(), element, this.getAnnotationMirror(element, OutputPortSet.class, OutputPorts.class));
            }
        }
        return false;
    }

    AnnotationMirror getAnnotationMirror(Element e, Class<?> ... clazz) {
        for (Class<?> cls : clazz) {
            TypeElement primOper = this.processingEnv.getElementUtils().getTypeElement(cls.getCanonicalName());
            for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().asElement().equals(primOper)) continue;
                return annotationMirror;
            }
        }
        return null;
    }

    private boolean checkAndAddToInputIdList(Element elem, ArrayList<String> ids, AnnotationMirror mirror) {
        boolean isOpenInputPort = true;
        Map<? extends ExecutableElement, ? extends AnnotationValue> map = mirror.getElementValues();
        for (ExecutableElement executableElement : map.keySet()) {
            int cardinality;
            AnnotationValue val;
            String attributeName = executableElement.getSimpleName().toString();
            if (executableElement.getSimpleName().toString().equals("id")) {
                val = map.get(executableElement);
                String str = (String)val.getValue();
                if (str == null || str.length() <= 0) continue;
                if (!ids.contains(str)) {
                    ids.add(str);
                    continue;
                }
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, new Message((MessageKey)StreamsSPLJavaMessagesKey.Key.PAP_DUPLICATE_INPUT_PORT_ID, new Object[]{""}).getLocalizedMessage(), elem, mirror);
                continue;
            }
            if (!attributeName.equals("cardinality") || (cardinality = ((Integer)(val = map.get(executableElement)).getValue()).intValue()) == (Integer)executableElement.getDefaultValue().getValue()) continue;
            isOpenInputPort = false;
        }
        return isOpenInputPort;
    }

    private boolean addToOutputIdList(Element elem, ArrayList<AnnotationMirror> outputAnnotationList, AnnotationMirror mirror) {
        boolean isOpenOutputPort = true;
        boolean isPunctInputPortSpecified = false;
        VariableElement mode = null;
        Map<? extends ExecutableElement, ? extends AnnotationValue> map = mirror.getElementValues();
        for (ExecutableElement executableElement : map.keySet()) {
            int cardinality;
            AnnotationValue val;
            String attributeName = executableElement.getSimpleName().toString();
            if (attributeName.equals("windowPunctuationInputPort")) {
                val = map.get(executableElement);
                String str = (String)val.getValue();
                if (str == null || str.length() <= 0) continue;
                outputAnnotationList.add(mirror);
                isPunctInputPortSpecified = true;
                continue;
            }
            if (attributeName.equals("windowPunctuationOutputMode")) {
                val = map.get(executableElement);
                Object value = val.getValue();
                if (!(value instanceof VariableElement)) continue;
                mode = (VariableElement)value;
                continue;
            }
            if (!attributeName.equals("cardinality") || (cardinality = ((Integer)(val = map.get(executableElement)).getValue()).intValue()) == (Integer)executableElement.getDefaultValue().getValue()) continue;
            isOpenOutputPort = false;
        }
        if (isPunctInputPortSpecified && (mode == null || !mode.getSimpleName().toString().equals(OutputPortSet.WindowPunctuationOutputMode.Preserving.name()))) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, new Message((MessageKey)StreamsSPLJavaMessagesKey.Key.PAP_REQUIRE_PUNCTUATION_PRESERVING, new Object[]{""}).getLocalizedMessage(), elem, mirror);
        }
        return isOpenOutputPort;
    }

    private boolean isAnnotationType(AnnotationMirror mirror, Class<?> clazz) {
        TypeElement element = (TypeElement)mirror.getAnnotationType().asElement();
        return element.getQualifiedName().toString().equals(clazz.getCanonicalName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }
}

