/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.internal.model.processors;

import com.ibm.streams.function.model.Function;
import com.ibm.streams.operator.internal.model.AbstractModel;
import com.ibm.streams.operator.internal.model.ClassModel;
import com.ibm.streams.operator.internal.model.MethodModel;
import com.ibm.streams.operator.internal.model.MethodParameterModel;
import com.ibm.streams.operator.internal.model.ShadowClass;
import com.ibm.streams.operator.model.CustomMetric;
import com.ibm.streams.operator.model.Parameter;
import com.ibm.streams.operator.model.PrimitiveOperator;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"com.ibm.streams.operator.model.PrimitiveOperator", "com.ibm.streams.function.model.Function"})
public class ShadowClassGenerator
extends AbstractProcessor {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2013, 2014    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    private static final String DEFAULT_PARAM_NAME_PREFIX = "__p_";

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            for (Element element : roundEnv.getElementsAnnotatedWith(PrimitiveOperator.class)) {
                if (element.getKind() != ElementKind.CLASS) continue;
                TypeElement typeElement = (TypeElement)element;
                this.generateShadowClass(typeElement, true);
            }
            ArrayList<TypeElement> classesAlreadyProcessed = new ArrayList<TypeElement>();
            for (Element element : roundEnv.getElementsAnnotatedWith(Function.class)) {
                TypeElement classElement;
                Element parentElem;
                if (element.getKind() != ElementKind.METHOD || (parentElem = element.getEnclosingElement()).getKind() != ElementKind.CLASS || parentElem.getAnnotation(PrimitiveOperator.class) != null || classesAlreadyProcessed.contains(classElement = (TypeElement)parentElem)) continue;
                classesAlreadyProcessed.add(classElement);
                this.generateShadowClass(classElement, false);
            }
        }
        return false;
    }

    private void generateShadowClass(TypeElement classElement, boolean isOperatorClass) {
        if (classElement.getAnnotation(ShadowClass.class) == null) {
            PackageElement packageElement = this.processingEnv.getElementUtils().getPackageOf(classElement);
            ClassModel classModel = new ClassModel(this.processingEnv, packageElement, classElement, isOperatorClass);
            this.addAnnotations(classModel, classElement);
            List<? extends Element> elements = this.processingEnv.getElementUtils().getAllMembers(classElement);
            for (Element element : elements) {
                boolean isFunction;
                if (element.getKind() != ElementKind.METHOD) continue;
                ExecutableElement method = (ExecutableElement)element;
                boolean isParameterOrMetricSetter = method.getAnnotation(Parameter.class) != null || method.getAnnotation(CustomMetric.class) != null;
                boolean bl = isFunction = method.getAnnotation(Function.class) != null;
                if (!isParameterOrMetricSetter && !isFunction) continue;
                String name = method.getSimpleName().toString();
                String returnType = method.getReturnType().toString();
                boolean isPrimitiveReturnType = method.getReturnType().getKind() != TypeKind.DECLARED && method.getReturnType().getKind() != TypeKind.ARRAY;
                boolean isStatic = method.getModifiers().contains((Object)Modifier.STATIC);
                if (isStatic && !element.getEnclosingElement().equals(classElement)) continue;
                MethodModel methodModel = new MethodModel(classModel, name, returnType, isPrimitiveReturnType, isStatic);
                classModel.addMethod(methodModel);
                int pi = 0;
                for (VariableElement variableElement : method.getParameters()) {
                    Name pn = variableElement.getSimpleName();
                    String paramName = pn == null ? DEFAULT_PARAM_NAME_PREFIX + pi++ : pn.toString();
                    String type = variableElement.asType().toString();
                    MethodParameterModel paramModel = new MethodParameterModel(paramName, type);
                    methodModel.addParameter(paramModel);
                }
                this.addAnnotations(methodModel, method);
            }
            try {
                Name binaryName = this.processingEnv.getElementUtils().getBinaryName(classElement);
                JavaFileObject javaFileObject = this.processingEnv.getFiler().createSourceFile(binaryName.toString() + "$StreamsModel", classElement);
                BufferedWriter wtr = new BufferedWriter(javaFileObject.openWriter());
                StringBuffer buffer = new StringBuffer();
                classModel.writeAsString(buffer);
                wtr.append(buffer.toString());
                wtr.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void addAnnotations(AbstractModel model, Element elem) {
        for (AnnotationMirror annotationMirror : this.processingEnv.getElementUtils().getAllAnnotationMirrors(elem)) {
            model.addAnnotation(annotationMirror);
        }
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }
}

