/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.management;

import com.ibm.streams.operator.OperatorContext;
import com.ibm.streams.operator.management.OperatorContextMXBean;
import com.ibm.streams.operator.management.OperatorManagement;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;

public class OperatorLifeCycle {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2013, 2018    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    private static final Map<OperatorContext, CloseableNotificationListener> closeOnShutdowns = new WeakHashMap<OperatorContext, CloseableNotificationListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeOnShutdown(OperatorContext context, Closeable closeable) {
        CloseableNotificationListener listener;
        Map<OperatorContext, CloseableNotificationListener> map = closeOnShutdowns;
        synchronized (map) {
            listener = closeOnShutdowns.get(context);
            if (listener == null) {
                listener = new CloseableNotificationListener();
                closeOnShutdowns.put(context, listener);
                OperatorLifeCycle.addShutdownAction(context, listener);
            }
        }
        listener.addCloseable(closeable);
    }

    public static void addShutdownAction(OperatorContext context, NotificationListener listener) {
        try {
            OperatorLifeCycle.addOneShotAction(context, "com.ibm.streams.operator.lifecycle.shutdown.notify", listener);
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof InstanceNotFoundException) {
                Notification fakeShutdown = new Notification("com.ibm.streams.operator.lifecycle.shutdown.notify", OperatorManagement.getName(context), -1L);
                listener.handleNotification(fakeShutdown, null);
            }
            throw e;
        }
    }

    public static void addAllPortsReadyAction(OperatorContext context, NotificationListener listener) {
        OperatorLifeCycle.addOneShotAction(context, "com.ibm.streams.operator.lifecycle.allPortsReady", listener);
    }

    private static void addOneShotAction(OperatorContext context, String notificationType, final NotificationListener listener) {
        OperatorContextMXBean ocmx = OperatorManagement.getOperatorContextMXBean(context);
        final NotificationEmitter ocm = (NotificationEmitter)((Object)ocmx);
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType(notificationType);
        NotificationListener oneShotListener = new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                listener.handleNotification(notification, handback);
                try {
                    ocm.removeNotificationListener(this);
                }
                catch (ListenerNotFoundException listenerNotFoundException) {
                    // empty catch block
                }
            }
        };
        try {
            ocm.addNotificationListener(oneShotListener, filter, null);
        }
        catch (UndeclaredThrowableException ute) {
            if (ute.getCause() instanceof InstanceNotFoundException) {
                throw new IllegalStateException(ute.getCause());
            }
            throw ute;
        }
    }

    private static class CloseableNotificationListener
    implements NotificationListener {
        private final Map<Closeable, Boolean> closeables = new WeakHashMap<Closeable, Boolean>();
        private boolean shutdown;

        private CloseableNotificationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleNotification(Notification notification, Object handback) {
            Set<Closeable> items;
            CloseableNotificationListener closeableNotificationListener = this;
            synchronized (closeableNotificationListener) {
                this.shutdown = true;
                items = this.closeables.keySet();
            }
            for (Closeable closeable : items) {
                this.close(closeable);
            }
        }

        synchronized void addCloseable(Closeable closeable) {
            if (this.shutdown) {
                this.close(closeable);
                return;
            }
            this.closeables.put(closeable, Boolean.FALSE);
        }

        private void close(Closeable closeable) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

